/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.tconfig.gui.TConfigEntryListWidget;

public abstract class TConfigEntry
extends TConfigEntryListWidget.TConfigEntryForList {
    public static final String CHANGED_COLOR = "\u00a7a";
    private final Component text;
    private final Component tooltip;

    public TConfigEntry(@Translatable String text, @Translatable String tooltip) {
        this.text = ETFVersionDifferenceHandler.getTextFromTranslation(text);
        this.tooltip = tooltip == null || tooltip.isBlank() ? null : ETFVersionDifferenceHandler.getTextFromTranslation(tooltip);
    }

    public TConfigEntry(@Translatable String text) {
        this(text, null);
    }

    public Component getText() {
        return this.text;
    }

    public Button.OnTooltip getTooltip() {
        return TConfigEntry.getTooltip(this.tooltip);
    }

    public static List<Component> getAsLines(Component toolTipText) {
        String[] strings = toolTipText.getString().split("\n");
        ArrayList<Component> lines = new ArrayList<Component>();
        for (String str : strings) {
            lines.add(Component.m_130674_((String)str.strip()));
        }
        return lines;
    }

    public static Button.OnTooltip getTooltip(@Translatable String toolTipText) {
        if (toolTipText == null || toolTipText.isBlank()) {
            return Button.f_93716_;
        }
        return TConfigEntry.getTooltip(ETFVersionDifferenceHandler.getTextFromTranslation(toolTipText));
    }

    public static Button.OnTooltip getTooltip(Component toolTipText) {
        if (toolTipText == null || toolTipText.getString().isEmpty()) {
            return Button.f_93716_;
        }
        List<Component> lines = TConfigEntry.getAsLines(toolTipText);
        return (buttonWidget, matrices, mouseX, mouseY) -> {
            if (buttonWidget.m_198029_() && !toolTipText.getString().isEmpty()) {
                assert (Minecraft.m_91087_().f_91080_ != null);
                Minecraft.m_91087_().f_91080_.m_96597_(matrices, lines, mouseX, mouseY);
            }
        };
    }

    @Nullable
    public static ElementTooltipSupplier getTooltipForElement(String toolTipText) {
        if (toolTipText == null || toolTipText.isBlank()) {
            return null;
        }
        Component text = ETFVersionDifferenceHandler.getTextFromTranslation(toolTipText);
        List<Component> lines = TConfigEntry.getAsLines(text);
        return (element, matrices, mouseX, mouseY) -> {
            if (element.m_5953_((double)mouseX, (double)mouseY) && !text.getString().isEmpty()) {
                assert (Minecraft.m_91087_().f_91080_ != null);
                Minecraft.m_91087_().f_91080_.m_96597_(matrices, lines, mouseX, mouseY);
            }
        };
    }

    public TConfigEntry setEnabled(boolean enabled) {
        AbstractWidget widget = this.getWidget(0, 0, 0, 0);
        widget.f_93623_ = enabled;
        return this;
    }

    abstract boolean hasChangedFromInitial();

    abstract boolean saveValuesToConfig();

    abstract void setValuesToDefault();

    abstract void resetValuesToInitial();

    public static interface ElementTooltipSupplier {
        public void onTooltip(GuiEventListener var1, PoseStack var2, int var3, int var4);
    }

    public static class Empty
    extends TConfigEntry {
        public Empty() {
            super("", null);
        }

        @Override
        public AbstractWidget getWidget(int x, int y, int width, int height) {
            return null;
        }

        @Override
        boolean hasChangedFromInitial() {
            return false;
        }

        @Override
        boolean saveValuesToConfig() {
            return false;
        }

        @Override
        void setValuesToDefault() {
        }

        @Override
        void resetValuesToInitial() {
        }
    }
}

