/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlabfishModel<E extends Slabfish>
extends AgeableListModel<E> {
    public ModelPart body;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart rightArm;
    public ModelPart leftArm;
    public ModelPart fin;
    public ModelPart backpack;
    public TextureAtlasSprite sprite;
    private float partialTicks;

    public SlabfishModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightArm = this.body.m_171324_("right_arm");
        this.fin = this.body.m_171324_("fin");
        this.backpack = this.body.m_171324_("backpack");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-5.0f, -10.0f, -2.0f, 10.0f, 10.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171506_(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, true), PartPose.m_171423_((float)5.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.43633232f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171506_(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)-5.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.43633232f));
        PartDefinition fin = body.m_171599_("fin", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171506_(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)2.0f, (float)-0.21816616f, (float)0.0f, (float)0.0f));
        PartDefinition backpack = body.m_171599_("backpack", CubeListBuilder.m_171558_().m_171514_(8, 20).m_171506_(-4.0f, -8.0f, 2.0f, 8.0f, 8.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(-1.5f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, false), PartPose.m_171423_((float)-2.5f, (float)19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(-1.5f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, true), PartPose.m_171423_((float)2.5f, (float)19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.partialTicks = partialTicks;
    }

    public void setupAnim(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.fin.f_104207_ = !((Slabfish)((Object)entityIn)).hasBackpack();
        this.body.f_104205_ = 0.1f * Mth.m_14031_((float)(limbSwing * 0.5f)) * 1.25f * limbSwingAmount;
        if (!entityIn.m_20069_()) {
            if (((Slabfish)((Object)entityIn)).isPartying()) {
                float f = Mth.m_14089_((float)((float)((Slabfish)((Object)entityIn)).f_19797_ + this.partialTicks));
                float f1 = Mth.m_14031_((float)((float)((Slabfish)((Object)entityIn)).f_19797_ + this.partialTicks));
                this.body.f_104202_ = f;
                this.body.f_104201_ = 19.75f - f1;
            }
            this.rightArm.f_104205_ = ageInTicks;
            this.leftArm.f_104205_ = -ageInTicks;
            this.rightLeg.f_104203_ = entityIn.m_21825_() || entityIn.m_20202_() != null ? -1.57f : Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.5f * limbSwingAmount;
            this.leftLeg.f_104203_ = entityIn.m_21825_() || entityIn.m_20202_() != null ? -1.57f : Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.5f * limbSwingAmount;
        } else {
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
            this.rightArm.f_104205_ = ageInTicks;
            this.leftArm.f_104205_ = -ageInTicks;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_7695_(matrixStack, this.sprite.m_118381_(buffer), packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg);
    }
}

