/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Lists;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PineconeBlock
extends FallingBlock
implements BonemealableBlock {
    public PineconeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (PineconeBlock.canFall(level, pos) && pos.m_123342_() >= level.m_141937_()) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
            this.m_6788_(fallingblockentity);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42784_)) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, stack);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            BlockState newState = ((Block)EnvironmentalBlocks.WAXED_PINECONE.get()).m_49966_();
            level.m_7731_(pos, newState, 11);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
            level.m_5898_(player, 3003, pos, 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(3) != 0) {
            BlockState sapling = ((Block)EnvironmentalBlocks.PINE_SAPLING.get()).m_49966_();
            ArrayList list = Lists.newArrayList();
            PineconeBlock.addPossibleSaplingPositionsFromNeighbors(4, 4, 4, list, level, pos.m_7918_(-4, -4, -4), new BlockPos.MutableBlockPos(), new boolean[9][9][9]);
            for (int i = 0; i < 12 && !list.isEmpty(); ++i) {
                BlockPos blockpos = (BlockPos)list.remove(random.m_188503_(list.size()));
                if (!level.isAreaLoaded(blockpos, 1) || level.m_46803_(blockpos.m_7494_()) < 9 || !PineconeBlock.hasSpaceForTree(blockpos, level, false)) continue;
                level.m_46597_(blockpos, sapling);
                this.spawnBoneMealParticles(level, this.m_49966_(), pos);
                this.spawnBoneMealParticles(level, sapling, blockpos);
                return;
            }
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public static boolean canFall(ServerLevel level, BlockPos pos) {
        return !PineconeBlock.supportedFromAbove(level, pos) && PineconeBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()));
    }

    public static boolean supportedFromAbove(ServerLevel level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos.m_7494_());
        return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)level, pos.m_7494_()), (Direction)Direction.DOWN) && !(blockstate.m_60734_() instanceof FallingBlock);
    }

    public boolean m_7370_(BlockGetter p_50897_, BlockPos p_50898_, BlockState p_50899_, boolean p_50900_) {
        return true;
    }

    public boolean m_214167_(Level p_220878_, RandomSource random, BlockPos p_220880_, BlockState p_220881_) {
        return random.m_188503_(3) != 0;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState sapling = ((Block)EnvironmentalBlocks.PINE_SAPLING.get()).m_49966_();
        ArrayList list = Lists.newArrayList();
        PineconeBlock.addPossibleSaplingPositionsFromNeighbors(4, 4, 4, list, level, pos.m_7918_(-4, -4, -4), new BlockPos.MutableBlockPos(), new boolean[9][9][9]);
        for (int i = 0; i < 12 && !list.isEmpty(); ++i) {
            BlockPos blockpos = (BlockPos)list.remove(random.m_188503_(list.size()));
            if (!level.isAreaLoaded(blockpos, 1) || !PineconeBlock.hasSpaceForTree(blockpos, level, true)) continue;
            level.m_46597_(blockpos, sapling);
            this.spawnBoneMealParticles(level, sapling, blockpos);
            return;
        }
    }

    private void spawnBoneMealParticles(ServerLevel level, BlockState state, BlockPos pos) {
        double d1;
        int amount = 15;
        double d0 = 0.5;
        if (state.m_60713_((Block)EnvironmentalBlocks.PINECONE.get())) {
            amount *= 2;
            d0 = 4.0;
            d1 = 1.5;
        } else if (state.m_60804_((BlockGetter)level, pos)) {
            pos = pos.m_7494_();
            amount *= 3;
            d0 = 3.0;
            d1 = 1.0;
        } else {
            d1 = state.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
        }
        level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        RandomSource random = level.m_213780_();
        for (int i = 0; i < amount; ++i) {
            double d2 = random.m_188583_() * 0.02;
            double d3 = random.m_188583_() * 0.02;
            double d4 = random.m_188583_() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)pos.m_123341_() + d5 + random.m_188500_() * d0 * 2.0;
            double d7 = (double)pos.m_123342_() + random.m_188500_() * d1;
            double d8 = (double)pos.m_123343_() + d5 + random.m_188500_() * d0 * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, d6, d7, d8, 0, d2, d3, d4, 0.0);
        }
    }

    private static void addPossibleSaplingPositions(int x, int y, int z, List<BlockPos> list, ServerLevel level, BlockPos origin, BlockPos.MutableBlockPos mutablepos, boolean[][][] foundpositions) {
        if (x < 0 || x >= 9 || y < 0 || y >= 9 || z < 0 || z >= 9) {
            return;
        }
        if (foundpositions[x][y][z]) {
            return;
        }
        mutablepos.m_122154_((Vec3i)origin, x, y, z);
        foundpositions[x][y][z] = true;
        if (level.m_8055_((BlockPos)mutablepos).m_204336_(BlockTags.f_144274_)) {
            if (level.m_46859_((BlockPos)mutablepos.m_122173_(Direction.UP))) {
                list.add(mutablepos.m_7949_());
            }
            PineconeBlock.addPossibleSaplingPositionsFromNeighbors(x, y, z, list, level, origin, mutablepos, foundpositions);
        }
    }

    private static void addPossibleSaplingPositionsFromNeighbors(int x, int y, int z, List<BlockPos> list, ServerLevel level, BlockPos origin, BlockPos.MutableBlockPos mutablepos, boolean[][][] foundpositions) {
        PineconeBlock.addPossibleSaplingPositions(x - 1, y, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x + 1, y, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y - 1, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y + 1, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y, z - 1, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y, z + 1, list, level, origin, mutablepos, foundpositions);
    }

    private static boolean hasSpaceForTree(BlockPos pos, ServerLevel level, boolean bonemeal) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int y = -2; y <= 3; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    mutablepos.m_122154_((Vec3i)pos, x, y, z);
                    if ((y <= 0 || TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)mutablepos) || bonemeal) && !level.m_8055_((BlockPos)mutablepos).m_204336_(BlockTags.f_13104_)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

