/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.slabfish;

import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class SlabbyBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    protected final Slabfish animal;
    private final Class<? extends Slabfish> mateClass;
    protected final Level world;
    protected Slabfish targetMate;
    private int loveTime;
    private final double moveSpeed;

    public SlabbyBreedGoal(Slabfish animal, double speedIn) {
        this(animal, speedIn, ((Object)((Object)animal)).getClass());
    }

    public SlabbyBreedGoal(Slabfish p_i47306_1_, double p_i47306_2_, Class<? extends Slabfish> p_i47306_4_) {
        this.animal = p_i47306_1_;
        this.world = p_i47306_1_.f_19853_;
        this.mateClass = p_i47306_4_;
        this.moveSpeed = p_i47306_2_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.animal.m_27593_()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean m_8045_() {
        return this.targetMate.m_6084_() && this.targetMate.m_27593_() && this.loveTime < 60;
    }

    public void m_8041_() {
        this.targetMate = null;
        this.loveTime = 0;
    }

    public void m_8037_() {
        this.animal.m_21563_().m_24960_((Entity)this.targetMate, 10.0f, (float)this.animal.m_8132_());
        this.animal.m_21573_().m_5624_((Entity)this.targetMate, this.moveSpeed);
        ++this.loveTime;
        if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    @Nullable
    private Slabfish getNearbyMate() {
        List list = this.world.m_45971_(this.mateClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        Slabfish slabfish = null;
        for (Slabfish slabfish1 : list) {
            if (!this.animal.m_7848_((Animal)slabfish1) || !(this.animal.m_20280_((Entity)slabfish1) < d0)) continue;
            slabfish = slabfish1;
            d0 = this.animal.m_20280_((Entity)slabfish1);
        }
        return slabfish;
    }

    @Deprecated
    protected void spawnBaby() {
        Slabfish slabby = this.animal.getBreedOffspring((ServerLevel)this.world, (AgeableMob)this.targetMate);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.animal, (Mob)this.targetMate, (AgeableMob)slabby);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        slabby = (Slabfish)event.getChild();
        if (cancelled) {
            this.animal.m_146762_(6000);
            this.targetMate.m_146762_(6000);
            this.animal.m_27594_();
            this.targetMate.m_27594_();
            return;
        }
        if (slabby != null) {
            ServerPlayer player = this.animal.m_27592_();
            if (player == null && this.targetMate.m_27592_() != null) {
                player = this.targetMate.m_27592_();
            }
            this.animal.m_146762_(6000);
            this.targetMate.m_146762_(6000);
            this.animal.m_27594_();
            this.targetMate.m_27594_();
            slabby.m_146762_(-24000);
            slabby.m_7678_(this.animal.m_20185_(), this.animal.m_20186_(), this.animal.m_20189_(), 0.0f, 0.0f);
            SlabfishType slabfishType = SlabfishManager.get((LevelReader)this.world).getSlabfishType(SlabfishConditionContext.breeding(slabby, this.animal.m_27592_(), this.animal, this.targetMate)).orElse(SlabfishManager.DEFAULT_SLABFISH);
            slabby.setSlabfishType(slabfishType.getRegistryName());
            if (player != null) {
                player.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(player, (Animal)this.animal, (Animal)this.targetMate, (AgeableMob)slabby);
            }
            this.world.m_7967_((Entity)slabby);
            this.world.m_7605_((Entity)this.animal, (byte)18);
            if (this.world.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.world.m_7967_((Entity)new ExperienceOrb(this.world, this.animal.m_20185_(), this.animal.m_20186_(), this.animal.m_20189_(), this.animal.m_217043_().m_188503_(7) + 1));
            }
        }
    }
}

