/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.environmental.common.item.YakPantsItem;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IForgeShearable;

public class Yak
extends Animal
implements IForgeShearable,
Shearable,
NeutralMob {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Yak.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(Yak.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private static final UUID SPEED_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(SPEED_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private EatBlockGoal eatGrassGoal;
    private UUID lastHurtBy;
    private int grassEatTimer;

    public Yak(EntityType<? extends Yak> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(EnvironmentalItemTags.YAK_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)this.eatGrassGoal);
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Yak)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sheared", this.getSheared());
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_("Sheared"));
        this.m_147285_(this.f_19853_, compound);
    }

    protected void m_8024_() {
        this.grassEatTimer = this.eatGrassGoal.m_25213_();
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_21660_()) {
            if (!this.m_6162_() && !modifiableattributeinstance.m_22109_(ATTACKING_SPEED_BOOST)) {
                modifiableattributeinstance.m_22118_(ATTACKING_SPEED_BOOST);
            }
        } else if (modifiableattributeinstance.m_22109_(ATTACKING_SPEED_BOOST)) {
            modifiableattributeinstance.m_22130_(ATTACKING_SPEED_BOOST);
        }
        this.m_21666_((ServerLevel)this.f_19853_, true);
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_ && this.grassEatTimer > 0) {
            --this.grassEatTimer;
        }
        super.m_8107_();
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.grassEatTimer = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            player.m_5496_((SoundEvent)EnvironmentalSoundEvents.YAK_MILK.get(), 1.0f, 1.0f);
            ItemStack newStack = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(hand, newStack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_204132_(EnvironmentalItemTags.YAK_FOOD).test(stack);
    }

    public float getHeadEatingOffset(float partialTicks) {
        if (this.grassEatTimer <= 0) {
            return 0.0f;
        }
        if (this.grassEatTimer >= 4 && this.grassEatTimer <= 36) {
            return 1.0f;
        }
        return this.grassEatTimer < 4 ? ((float)this.grassEatTimer - partialTicks) / 4.0f : -((float)(this.grassEatTimer - 40) - partialTicks) / 4.0f;
    }

    public float getHeadPitch(float partialTicks) {
        if (this.grassEatTimer > 4 && this.grassEatTimer <= 36) {
            return 0.62831855f + 0.22f * Mth.m_14031_((float)(((float)(this.grassEatTimer - 4) - partialTicks) / 32.0f * 28.7f));
        }
        return this.grassEatTimer > 0 ? 0.62831855f : Mth.m_14179_((float)partialTicks, (float)this.f_19860_, (float)this.m_146909_()) * ((float)Math.PI / 180);
    }

    public void m_8035_() {
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    public boolean getSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.getSheared() && !this.m_6162_();
    }

    public boolean isShearable(ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, (double)1.2f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public float m_6100_() {
        return 0.8f;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!world.f_46443_) {
            this.setSheared(true);
            if (!player.m_150110_().f_35937_ && !(player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof YakPantsItem)) {
                this.m_6710_((LivingEntity)player);
            }
            int i = 4 + this.f_19796_.m_188503_(12);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((ItemLike)EnvironmentalItems.YAK_HAIR.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)EnvironmentalEntityTypes.YAK.get()).m_20615_((Level)world);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.95f : 1.3f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)EnvironmentalItems.YAK_SPAWN_EGG.get());
    }

    public void m_5851_(SoundSource category) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, category, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 4 + this.f_19796_.m_188503_(12);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_20000_((ItemLike)EnvironmentalItems.YAK_HAIR.get(), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(UUID target) {
        this.lastHurtBy = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_RANGE.m_214085_(this.f_19796_));
    }
}

