/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.slabfish;

import net.minecraft.ChatFormatting;

public enum SlabfishRarity {
    COMMON(ChatFormatting.GRAY, 1.0f),
    UNCOMMON(ChatFormatting.GREEN, 0.55f),
    RARE(ChatFormatting.AQUA, 0.15f),
    EPIC(ChatFormatting.LIGHT_PURPLE, 0.08f),
    LEGENDARY(ChatFormatting.GOLD, 0.02f);

    private final ChatFormatting color;
    private final float chance;

    private SlabfishRarity(ChatFormatting color, float chance) {
        this.color = color;
        this.chance = chance;
    }

    public ChatFormatting getFormatting() {
        return this.color;
    }

    public float getChance() {
        return this.chance;
    }

    public static SlabfishRarity byChance(float chance) {
        for (int i = SlabfishRarity.values().length - 1; i > 0; --i) {
            if (!(chance <= SlabfishRarity.values()[i].getChance())) continue;
            return SlabfishRarity.values()[i];
        }
        return COMMON;
    }

    public static SlabfishRarity byId(int id) {
        if (id < 0 || id >= SlabfishRarity.values().length) {
            return COMMON;
        }
        return SlabfishRarity.values()[id];
    }
}

