/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item;

import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import com.teamabnormals.environmental.common.slabfish.BackpackType;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.common.slabfish.SweaterType;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutablePair;

public class SlabfishBucketItem
extends MobBucketItem {
    private static final Map<String, ResourceLocation> LOCATION_CACHE = new HashMap<String, ResourceLocation>();
    private static final MutablePair<CompoundTag, SweaterType> SWEATER_TYPE_CACHE = new MutablePair(null, (Object)SlabfishManager.EMPTY_SWEATER);
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> Items.f_42459_);

    public SlabfishBucketItem(Item.Properties builder) {
        super(() -> EnvironmentalEntityTypes.SLABFISH.get(), () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, builder);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, group, items);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            SlabfishType slabfishType;
            SlabfishManager slabfishManager = SlabfishManager.get((LevelReader)worldIn);
            if (tag.m_128425_("SlabfishType", 8) && (slabfishType = slabfishManager.getSlabfishType(LOCATION_CACHE.computeIfAbsent(tag.m_128461_("SlabfishType"), ResourceLocation::new)).orElse(SlabfishManager.DEFAULT_SLABFISH)) != SlabfishManager.DEFAULT_SLABFISH) {
                tooltip.add((Component)slabfishType.getDisplayName().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, slabfishType.getRarity().getFormatting()}));
            }
            if (tag.m_128425_("Age", 99) && tag.m_128451_("Age") < 0) {
                tooltip.add((Component)Component.m_237115_((String)"entity.environmental.slabfish.baby").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (tag.m_128425_("BackpackType", 8)) {
                BackpackType backpackType = slabfishManager.getBackpackType(LOCATION_CACHE.computeIfAbsent(tag.m_128461_("BackpackType"), ResourceLocation::new)).orElse(SlabfishManager.BROWN_BACKPACK);
                tooltip.add((Component)backpackType.getDisplayName().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (!tag.equals(SWEATER_TYPE_CACHE.getLeft())) {
                SWEATER_TYPE_CACHE.setLeft((Object)tag);
                SWEATER_TYPE_CACHE.setRight((Object)SlabfishManager.EMPTY_SWEATER);
                ListTag list = tag.m_128437_("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag slotNbt = list.m_128728_(i);
                    int index = slotNbt.m_128445_("Slot") & 0xFF;
                    if (index != 0) continue;
                    ItemStack slotStack = ItemStack.m_41712_((CompoundTag)slotNbt);
                    SWEATER_TYPE_CACHE.setRight((Object)slabfishManager.getSweaterType(slotStack).orElse(SlabfishManager.EMPTY_SWEATER));
                    break;
                }
            }
            if (!SlabfishManager.EMPTY_SWEATER.equals(SWEATER_TYPE_CACHE.getRight())) {
                tooltip.add((Component)((SweaterType)SWEATER_TYPE_CACHE.getRight()).getDisplayName().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
    }
}

