/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item.explorer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teamabnormals.environmental.client.model.WandererBootsModel;
import com.teamabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class WandererBootsItem
extends ExplorerArmorItem {
    public static final String NBT_TAG = "WandererBootsUses";

    public WandererBootsItem(Item.Properties properties) {
        super(EquipmentSlot.FEET, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return WandererBootsModel.INSTANCE;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.m_7167_(this.m_40402_()));
        UUID uuid = UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B");
        int uses = Math.round(stack.m_41784_().m_128457_(NBT_TAG));
        double increase = 0.15f + 0.05f * (float)this.getIncreaseForUses(uses);
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Speed modifier", increase, AttributeModifier.Operation.MULTIPLY_BASE));
        return slot == this.f_40377_ ? builder.build() : super.m_7167_(slot);
    }

    @SubscribeEvent
    public static void onFallEvent(LivingFallEvent event) {
        if (event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_() == EnvironmentalItems.WANDERER_BOOTS.get() && event.getEntity().f_19789_ < 6.0f) {
            event.setDamageMultiplier(0.0f);
        }
    }

    public float getIncreaseForUses(float uses) {
        int increase = 0;
        for (int level : this.getLevelCaps()) {
            if (!(uses >= (float)level)) continue;
            ++increase;
        }
        return increase;
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 1000, 5000, 10000, 50000};
    }

    public float levelUp(ItemStack stack, LivingEntity entity, float increase) {
        CompoundTag tag = stack.m_41784_();
        float uses = tag.m_128457_(this.getUsesTag());
        float level = this.getIncreaseForUses(uses);
        tag.m_128350_(this.getUsesTag(), uses + increase);
        float newLevel = this.getIncreaseForUses(uses + increase);
        if (newLevel > level) {
            this.playEffects(newLevel, entity);
        }
        return newLevel;
    }
}

