/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.block.wood.LogBlock;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class PineTreeFeature
extends BlueprintTreeFeature {
    public PineTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        int leafbranches;
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        int trunkheight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkheight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        float f = random.m_188501_();
        int n = f > 0.6f ? 4 : (f > 0.25f ? 3 : (leafbranches = f > 0.05f ? 2 : 1));
        if (trunkheight >= 14 && random.m_188499_()) {
            ++leafbranches;
        }
        if (trunkheight >= 16) {
            ++leafbranches;
        }
        if (trunkheight >= 16 && leafbranches < 4) {
            leafbranches = 4;
        }
        if (trunkheight >= 18) {
            ++leafbranches;
        }
        ArrayList branchdirections = Lists.newArrayList();
        Direction.Plane.HORIZONTAL.forEach(branchdirections::add);
        int y = trunkheight - 4;
        while (y > 0) {
            BlockPos blockpos = origin.m_6630_(y);
            if (leafbranches > 0) {
                Direction direction = (Direction)branchdirections.remove(random.m_188503_(branchdirections.size()));
                this.createBranchWithLeaves(blockpos, direction, random, config);
                --leafbranches;
                if (branchdirections.isEmpty()) {
                    Direction.Plane.HORIZONTAL.forEach(branchdirections::add);
                    branchdirections.remove(direction);
                }
            } else if (random.m_188503_(y > 5 ? 2 : 6) == 0) {
                this.createBranch(blockpos, Direction.Plane.HORIZONTAL.m_235690_(random), random, config);
            }
            if (leafbranches == 0) {
                y -= 2 + random.m_188503_(2);
                continue;
            }
            if (leafbranches == 1 && random.m_188503_(3) == 0) {
                y -= 2;
                continue;
            }
            --y;
        }
        this.createTopLeaves(origin.m_6630_(trunkheight));
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.PINE_SAPLING.get()).m_49966_();
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        BlockPos blockpos = pos.m_121945_(direction);
        this.addSpecialLog(blockpos, (BlockState)config.f_68185_.m_213972_(random, blockpos).m_61124_((Property)LogBlock.f_55923_, (Comparable)direction.m_122434_()));
    }

    private void createBranchWithLeaves(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos blockpos = pos.m_121945_(direction);
        this.createBranch(pos, direction, random, config);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                mutable.m_122154_((Vec3i)blockpos, x, 0, z);
                this.addFoliage((BlockPos)mutable);
                if (x != 0 && z != 0) continue;
                this.addFoliage(mutable.m_7494_());
            }
        }
        if (random.m_188503_(3) == 0) {
            this.addFoliage(blockpos.m_5484_(direction, 2));
        }
    }

    private void createTopLeaves(BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y <= 3; ++y) {
            int r = y < 3 ? y : 1;
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) + Math.abs(z) > r) continue;
                    mutable.m_122154_((Vec3i)pos, x, 1 - y, z);
                    this.addFoliage((BlockPos)mutable);
                }
            }
        }
    }
}

