/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import com.teamabnormals.environmental.common.block.ColoredWisteriaLeavesBlock;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;

public class WisteriaTreeUtil {
    public static int getLengthByNeighbors(LevelSimulatedRW world, RandomSource random, BlockPos pos) {
        int length = random.m_188503_(6);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || direction == Direction.DOWN) continue;
            if (world.m_7433_(pos.m_121945_(direction), BlockBehaviour.BlockStateBase::m_60795_)) {
                ++length;
                continue;
            }
            if (!TreeUtil.isLeaves((LevelSimulatedReader)world, (BlockPos)pos.m_121945_(direction))) continue;
            --length;
        }
        return length;
    }

    public static void placeVines(LevelSimulatedRW world, RandomSource random, BlockPos pos, BlockState leaf) {
        int length = WisteriaTreeUtil.getLengthByNeighbors(world, random, pos);
        if (random.m_188503_(6) != 5 && world.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_) && !TreeUtil.isLog((LevelSimulatedReader)world, (BlockPos)pos)) {
            switch (length) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    if (!world.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_)) break;
                    WisteriaTreeUtil.placeLeafAt(world, pos, leaf);
                    break;
                }
                case 4: {
                    if (world.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_)) {
                        WisteriaTreeUtil.placeLeafAt(world, pos, leaf);
                    }
                    if (!world.m_7433_(pos.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) break;
                    WisteriaTreeUtil.placeLeafAt(world, pos.m_7495_(), leaf);
                    break;
                }
                case 5: {
                    if (world.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_)) {
                        WisteriaTreeUtil.placeLeafAt(world, pos, leaf);
                    }
                    if (world.m_7433_(pos.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) {
                        WisteriaTreeUtil.placeLeafAt(world, pos.m_7495_(), leaf);
                    }
                    if (!world.m_7433_(pos.m_6625_(2), BlockBehaviour.BlockStateBase::m_60795_)) break;
                    WisteriaTreeUtil.placeLeafAt(world, pos.m_6625_(2), leaf);
                }
            }
        }
    }

    public static boolean isAirOrLeavesOrReplaceable(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, Feature.m_204735_((TagKey)BlockTags.f_198158_));
    }

    public static void placeLeafAt(LevelSimulatedRW worldIn, BlockPos pos, BlockState leaf) {
        if (WisteriaTreeUtil.isAirOrLeavesOrReplaceable((LevelSimulatedReader)worldIn, pos)) {
            TreeUtil.setForcedState((LevelWriter)worldIn, (BlockPos)pos, (BlockState)leaf);
        }
    }

    public static void updateLeaves(LevelAccessor level, Set<BlockPos> logPositions) {
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 7; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : Lists.newArrayList(logPositions)) {
            for (Direction direction : Direction.values()) {
                BlockState state;
                mutablePos.m_122159_((Vec3i)pos, direction);
                if (logPositions.contains(mutablePos) || !(state = level.m_8055_((BlockPos)mutablePos)).m_61138_((Property)ColoredWisteriaLeavesBlock.f_54418_)) continue;
                ((Set)list.get(0)).add(mutablePos.m_7949_());
                TreeUtil.setForcedState((LevelWriter)level, (BlockPos)mutablePos, (BlockState)((BlockState)state.m_61124_((Property)ColoredWisteriaLeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))));
            }
        }
        for (int l = 1; l < 7; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos pos : set) {
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState state;
                    mutablePos.m_122159_((Vec3i)pos, direction1);
                    if (set.contains(mutablePos) || set1.contains(mutablePos) || !(state = level.m_8055_((BlockPos)mutablePos)).m_61138_((Property)ColoredWisteriaLeavesBlock.f_54418_) || (k = ((Integer)state.m_61143_((Property)ColoredWisteriaLeavesBlock.f_54418_)).intValue()) <= l + 1) continue;
                    TreeUtil.setForcedState((LevelWriter)level, (BlockPos)mutablePos, (BlockState)((BlockState)state.m_61124_((Property)ColoredWisteriaLeavesBlock.f_54418_, (Comparable)Integer.valueOf(l + 1))));
                    set1.add(mutablePos.m_7949_());
                }
            }
        }
    }
}

