/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.network.message;

import com.teamabnormals.environmental.common.network.ClientNetworkHandler;
import com.teamabnormals.environmental.common.network.message.CAcknowledgeEnvironmentalMessage;
import com.teamabnormals.environmental.common.network.message.EnvironmentalLoginMessage;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SweaterType;
import com.teamabnormals.environmental.core.Environmental;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SSyncSweaterTypeMessage
extends EnvironmentalLoginMessage {
    private final SweaterType[] sweaterTypes;

    public SSyncSweaterTypeMessage() {
        this(SlabfishManager.get(LogicalSide.SERVER).getAllSweaterTypes());
    }

    private SSyncSweaterTypeMessage(SweaterType[] sweaterTypes) {
        this.sweaterTypes = sweaterTypes;
    }

    public static void encode(SSyncSweaterTypeMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.sweaterTypes.length);
        for (int i = 0; i < msg.sweaterTypes.length; ++i) {
            msg.sweaterTypes[i].writeTo(buf);
        }
    }

    public static SSyncSweaterTypeMessage decode(FriendlyByteBuf buf) {
        SweaterType[] slabfishTypes = new SweaterType[buf.m_130242_()];
        for (int i = 0; i < slabfishTypes.length; ++i) {
            slabfishTypes[i] = SweaterType.readFrom(buf);
        }
        return new SSyncSweaterTypeMessage(slabfishTypes);
    }

    public static void handlePlay(SSyncSweaterTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncSweaterType(msg, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleLogin(SSyncSweaterTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncSweaterType(msg, (NetworkEvent.Context)ctx.get()));
        Environmental.LOGIN.reply((Object)new CAcknowledgeEnvironmentalMessage(), ctx.get());
        ctx.get().setPacketHandled(true);
    }

    public SweaterType[] getSweaterTypes() {
        return this.sweaterTypes;
    }
}

