/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class BackpackType
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final LazyLoadedValue<ResourceLocation> textureLocation = new LazyLoadedValue(() -> new ResourceLocation(this.getRegistryName().m_135827_(), "backpack/" + this.getRegistryName().m_135815_()));
    private ResourceLocation registryName;
    private Component displayName;

    public BackpackType(@Nullable Component displayName, @Nullable Ingredient ingredient) {
        this.displayName = displayName;
        this.ingredient = ingredient;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BackpackType readFrom(FriendlyByteBuf buf) {
        ResourceLocation registryName = buf.m_130281_();
        Component displayName = buf.m_130238_();
        Ingredient ingredient = buf.readBoolean() ? Ingredient.m_43940_((FriendlyByteBuf)buf) : null;
        return new BackpackType(displayName, ingredient).setRegistryName(registryName);
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredient != null && this.ingredient.test(stack);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    BackpackType setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        if (this.displayName == null) {
            this.displayName = Component.m_237113_((String)registryName.toString());
        }
        return this;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.m_13971_();
    }

    public void writeTo(FriendlyByteBuf buf) {
        buf.m_130085_(this.registryName);
        buf.m_130083_(this.displayName);
        buf.writeBoolean(this.ingredient != null);
        if (this.ingredient != null) {
            this.ingredient.m_43923_(buf);
        }
    }

    public String toString() {
        return "BackpackType{registryName=" + this.registryName + ", displayName=" + this.displayName.getString() + ", ingredient=" + (this.ingredient == null ? null : Arrays.toString(this.ingredient.m_43908_())) + "}";
    }

    public static class Deserializer
    implements JsonDeserializer<BackpackType> {
        public BackpackType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            TagKey tag;
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("item") && jsonObject.has("tag")) {
                throw new JsonSyntaxException("Either 'item' or 'tag' can be present");
            }
            Component displayName = jsonObject.has("displayName") ? (Component)context.deserialize(jsonObject.get("displayName"), Component.class) : null;
            Item item = jsonObject.has("item") && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(jsonObject.get("item").getAsString())) ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("item").getAsString())) : null;
            TagKey tagKey = tag = jsonObject.has("tag") ? TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(jsonObject.get("tag").getAsString())) : null;
            Ingredient ingredient = item != null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}) : (tag != null ? Ingredient.m_204132_(tag) : null);
            return new BackpackType(displayName, ingredient);
        }
    }
}

