/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class SlabfishBiomeCondition
implements SlabfishCondition {
    private final Biome biome;
    private final TagKey<Biome> tag;

    private SlabfishBiomeCondition(@Nullable Biome biome, @Nullable TagKey<Biome> tag) {
        this.biome = biome;
        this.tag = tag;
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if (json.has("biome") && json.has("tag")) {
            throw new JsonSyntaxException("Either 'biome' or 'tag' can be present.");
        }
        if (!json.has("biome") && !json.has("tag")) {
            throw new JsonSyntaxException("Either 'biome' or 'tag' must be present.");
        }
        return new SlabfishBiomeCondition(json.has("tag") ? null : (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(json.get("biome").getAsString())), json.has("tag") ? TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(json.get("tag").getAsString())) : null);
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return this.biome != null ? context.getBiome().m_203373_(ForgeRegistries.BIOMES.getKey((Object)this.biome)) : this.tag != null && context.getBiome().m_203656_(this.tag);
    }
}

