/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;

public class SlabfishEventCondition
implements SlabfishCondition {
    private final byte events;

    public SlabfishEventCondition(SlabfishConditionContext.Event[] events) {
        byte flag = 0;
        for (SlabfishConditionContext.Event event : events) {
            flag = (byte)(flag | 1 << event.ordinal());
        }
        this.events = flag;
    }

    private static SlabfishConditionContext.Event deserializeEvent(JsonElement element) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new JsonSyntaxException("Slabfish condition event expected to be a string");
        }
        String name = element.getAsString();
        for (SlabfishConditionContext.Event event : SlabfishConditionContext.Event.values()) {
            if (!event.name().equalsIgnoreCase(name)) continue;
            return event;
        }
        throw new JsonSyntaxException("Invalid slabfish condition event type: " + name);
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if (!json.has("events")) {
            throw new JsonSyntaxException("'events' must be present.");
        }
        JsonArray eventsJson = json.getAsJsonArray("events");
        SlabfishConditionContext.Event[] events = new SlabfishConditionContext.Event[eventsJson.size()];
        for (int i = 0; i < eventsJson.size(); ++i) {
            events[i] = SlabfishEventCondition.deserializeEvent(eventsJson.get(i));
        }
        return new SlabfishEventCondition(events);
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return (this.events >> context.getEvent().ordinal() & 1) > 0;
    }
}

