/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class SlabfishInBlockCondition
implements SlabfishCondition {
    private final Block block;
    private final TagKey<Block> tag;

    private SlabfishInBlockCondition(@Nullable Block block, @Nullable TagKey<Block> tag) {
        this.block = block;
        this.tag = tag;
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if (json.has("block") && json.has("tag")) {
            throw new JsonSyntaxException("Either 'block' or 'tag' can be present.");
        }
        if (!json.has("block") && !json.has("tag")) {
            throw new JsonSyntaxException("Either 'block' or 'tag' must be present.");
        }
        return new SlabfishInBlockCondition(json.has("tag") ? null : (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString())), json.has("tag") ? TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(json.get("tag").getAsString())) : null);
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return this.block != null ? context.isInBlock(this.block) : context.isInBlock(this.tag);
    }
}

