/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.other.tags.BlueprintBiomeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomeModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalBiomeModifierProvider {
    private static final RegistryAccess ACCESS = RegistryAccess.m_206197_();
    private static final Registry<Biome> BIOMES = ACCESS.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> PLACED_FEATURES = ACCESS.m_175515_(Registry.f_194567_);
    private static final Registry<EntityType<?>> ENTITY_TYPES = ACCESS.m_175515_(ForgeRegistries.ENTITY_TYPES.getRegistryKey());
    private static final HashMap<ResourceLocation, BiomeModifier> MODIFIERS = new HashMap();

    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        EnvironmentalBiomeModifierProvider.addSpawn("slabfish", EnvironmentalBiomeTags.HAS_SLABFISH, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), 16, 2, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("duck", EnvironmentalBiomeTags.HAS_DUCK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 10, 4, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("duck_rare", (ResourceKey<Biome>)Biomes.f_48208_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 1, 1, 2));
        EnvironmentalBiomeModifierProvider.addSpawnIgnore("deer", EnvironmentalBiomeTags.HAS_DEER, EnvironmentalBiomeTags.WITHOUT_DEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 16, 4, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("reindeer", EnvironmentalBiomeTags.HAS_REINDEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.REINDEER.get(), 16, 4, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("tapir", EnvironmentalBiomeTags.HAS_TAPIR, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.TAPIR.get(), 10, 2, 2));
        EnvironmentalBiomeModifierProvider.addSpawn("tapir_rare", (ResourceKey<Biome>)Biomes.f_186769_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.TAPIR.get(), 4, 2, 2));
        EnvironmentalBiomeModifierProvider.addSpawn("yak", EnvironmentalBiomeTags.HAS_YAK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.YAK.get(), 8, 4, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("deer_meadow", (ResourceKey<Biome>)Biomes.f_186754_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 1, 2, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("pig", (ResourceKey<Biome>)Biomes.f_220595_, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        EnvironmentalBiomeModifierProvider.addFeature("zebra_dazzle", EnvironmentalBiomeTags.HAS_ZEBRA, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.ZEBRA_DAZZLE);
        EnvironmentalBiomeModifierProvider.removeSpawnInvertedIgnore("pig", EnvironmentalBiomeTags.HAS_PIG, (ResourceKey<Biome>)Biomes.f_186755_, EntityType.f_20510_);
        EnvironmentalBiomeModifierProvider.removeSpawnInverted("sheep", EnvironmentalBiomeTags.HAS_SHEEP, EntityType.f_20520_);
        EnvironmentalBiomeModifierProvider.removeSpawnInverted("cow", EnvironmentalBiomeTags.HAS_COW, EntityType.f_20557_);
        EnvironmentalBiomeModifierProvider.removeSpawnInvertedIgnore("chicken", EnvironmentalBiomeTags.HAS_CHICKEN, (ResourceKey<Biome>)Biomes.f_186755_, EntityType.f_20555_);
        EnvironmentalBiomeModifierProvider.addFeature("cattails", EnvironmentalBiomeTags.HAS_CATTAILS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.CATTAILS);
        EnvironmentalBiomeModifierProvider.addFeature("cup_lichen", EnvironmentalBiomeTags.HAS_CUP_LICHEN, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_CUP_LICHEN);
        EnvironmentalBiomeModifierProvider.addFeatureIgnore("dwarf_spruce_taiga", EnvironmentalBiomeTags.HAS_SPARSE_DWARF_SPRUCE, EnvironmentalBiomeTags.IS_PINE_BARRENS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.DWARF_SPRUCE_TAIGA, EnvironmentalFeatures.EnvironmentalPlacedFeatures.DWARF_SPRUCE_TAIGA_DENSE);
        EnvironmentalBiomeModifierProvider.addFeature("bluebell", EnvironmentalBiomeTags.HAS_BLUEBELL, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BLUEBELL, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BLUEBELL_LARGE);
        EnvironmentalBiomeModifierProvider.addFeature("violet", EnvironmentalBiomeTags.HAS_VIOLET, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_VIOLET);
        EnvironmentalBiomeModifierProvider.addFeature("tasselflower", EnvironmentalBiomeTags.HAS_TASSELFLOWER, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_TASSELFLOWER);
        EnvironmentalBiomeModifierProvider.addFeature("bird_of_paradise", EnvironmentalBiomeTags.HAS_BIRD_OF_PARADISE, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BIRD_OF_PARADISE);
        EnvironmentalBiomeModifierProvider.addFeature("hibiscus_bush", EnvironmentalBiomeTags.HAS_HIBISCUS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.HIBISCUS_BUSH);
        EnvironmentalBiomeModifierProvider.addFeature("cartwheel", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_CARTWHEEL);
        EnvironmentalBiomeModifierProvider.addFeature("mycelium_sprouts", (ResourceKey<Biome>)Biomes.f_48215_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_MYCELIUM_SPROUTS);
        EnvironmentalBiomeModifierProvider.addFeature("mud_disk", EnvironmentalBiomeTags.HAS_MUD_DISK, GenerationStep.Decoration.UNDERGROUND_ORES, EnvironmentalFeatures.EnvironmentalPlacedFeatures.ORE_MUD);
        EnvironmentalBiomeModifierProvider.removeFeature("swamp_oak", (ResourceKey<Biome>)Biomes.f_48207_, Set.of(GenerationStep.Decoration.VEGETAL_DECORATION), VegetationPlacements.f_195432_);
        EnvironmentalBiomeModifierProvider.addFeature("swamp_vegetation", (ResourceKey<Biome>)Biomes.f_48207_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.TREES_SWAMP, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_DUCKWEED_SWAMP);
        EnvironmentalBiomeModifierProvider.addFeature("flower_forest_vegetation", (ResourceKey<Biome>)Biomes.f_48179_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_DELPHINIUMS, EnvironmentalFeatures.EnvironmentalPlacedFeatures.TREES_WISTERIA);
        EnvironmentalBiomeModifierProvider.addFeature("savanna_vegetation", (TagKey<Biome>)BiomeTags.f_215816_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_SAVANNA);
        EnvironmentalBiomeModifierProvider.addFeature("plains_vegetation", (TagKey<Biome>)BlueprintBiomeTags.IS_GRASSLAND, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_PLAINS);
        EnvironmentalBiomeModifierProvider.addFeature("jungle_vegetation", (TagKey<Biome>)BiomeTags.f_207610_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_JUNGLE, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_LARGE_FERN_JUNGLE);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"environmental", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, MODIFIERS);
    }

    @SafeVarargs
    private static void addFeature(String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        EnvironmentalBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(EnvironmentalBiomeModifierProvider.biomeSet(biome), EnvironmentalBiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        EnvironmentalBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), EnvironmentalBiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static void removeFeature(String name, ResourceKey<Biome> biome, Set<GenerationStep.Decoration> steps, Holder<PlacedFeature> ... features) {
        EnvironmentalBiomeModifierProvider.addModifier("remove_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier(EnvironmentalBiomeModifierProvider.biomeSet(biome), EnvironmentalBiomeModifierProvider.featureSet(features), steps));
    }

    private static void addSpawn(String name, ResourceKey<Biome> biome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("add_spawn/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(EnvironmentalBiomeModifierProvider.biomeSet(biome), List.of(spawns)));
    }

    private static void addSpawn(String name, TagKey<Biome> tagKey, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("add_spawn/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, tagKey), List.of(spawns)));
    }

    private static void removeSpawnInverted(String name, TagKey<Biome> biomes, EntityType<?> ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("remove_spawn/" + name, new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, biomes), (HolderSet<EntityType<?>>)HolderSet.m_205800_(Stream.of(spawns).map(type -> ENTITY_TYPES.m_214121_((ResourceKey)ENTITY_TYPES.m_7854_(type).get())).collect(Collectors.toList()))));
    }

    private static void removeSpawnInvertedIgnore(String name, TagKey<Biome> biomes, ResourceKey<Biome> ignoredBiome, EntityType<?> ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("remove_spawn/" + name, new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsIgnoreBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, biomes), EnvironmentalBiomeModifierProvider.biomeSet(ignoredBiome), (HolderSet<EntityType<?>>)HolderSet.m_205800_(Stream.of(spawns).map(type -> ENTITY_TYPES.m_214121_((ResourceKey)ENTITY_TYPES.m_7854_(type).get())).collect(Collectors.toList()))));
    }

    private static void addSpawnIgnore(String name, TagKey<Biome> tagKey, TagKey<Biome> ignoredBiomes, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("add_spawn/" + name, new EnvironmentalBiomeModifierTypes.AddSpawnsIgnoreBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, tagKey), (HolderSet<Biome>)new HolderSet.Named(BIOMES, ignoredBiomes), List.of(spawns)));
    }

    private static void addSpawnIgnore(String name, TagKey<Biome> tagKey, ResourceKey<Biome> ignoredBiome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("add_spawn/" + name, new EnvironmentalBiomeModifierTypes.AddSpawnsIgnoreBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, tagKey), EnvironmentalBiomeModifierProvider.biomeSet(ignoredBiome), List.of(spawns)));
    }

    @SafeVarargs
    private static void addFeatureIgnore(String name, TagKey<Biome> biomes, TagKey<Biome> ignoredBiomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        EnvironmentalBiomeModifierProvider.addModifier("add_feature/" + name, new EnvironmentalBiomeModifierTypes.AddFeaturesIgnoreBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, biomes), (HolderSet<Biome>)new HolderSet.Named(BIOMES, ignoredBiomes), EnvironmentalBiomeModifierProvider.featureSet(features), step));
    }

    private static void addModifier(String name, BiomeModifier modifier) {
        MODIFIERS.put(new ResourceLocation("environmental", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<Biome> biomeSet(ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205800_(Stream.of(biomes).map(arg_0 -> BIOMES.m_214121_(arg_0)).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(Holder<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_((ResourceKey)registryObject.m_203543_().get())).collect(Collectors.toList()));
    }
}

