/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.CartwheelBlock;
import com.teamabnormals.environmental.common.levelgen.feature.CartwheelFeature;
import com.teamabnormals.environmental.common.levelgen.feature.CattailsFeature;
import com.teamabnormals.environmental.common.levelgen.feature.CherryTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.CoarseDirtOnStoneFeature;
import com.teamabnormals.environmental.common.levelgen.feature.CupLichenPatchFeature;
import com.teamabnormals.environmental.common.levelgen.feature.DenseCattailsFeature;
import com.teamabnormals.environmental.common.levelgen.feature.DwarfSpruceFeature;
import com.teamabnormals.environmental.common.levelgen.feature.FallenLeavesFeature;
import com.teamabnormals.environmental.common.levelgen.feature.FallenPineTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.FallenTallPineTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.GrainyCoarseDirtFeature;
import com.teamabnormals.environmental.common.levelgen.feature.HibiscusBushFeature;
import com.teamabnormals.environmental.common.levelgen.feature.LargeBluebellPatchFeature;
import com.teamabnormals.environmental.common.levelgen.feature.PineSlopesBoulderFeature;
import com.teamabnormals.environmental.common.levelgen.feature.PineTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.PineTreeOnStoneFeature;
import com.teamabnormals.environmental.common.levelgen.feature.ShortBambooFeature;
import com.teamabnormals.environmental.common.levelgen.feature.SmallCoarseDirtOnStoneFeature;
import com.teamabnormals.environmental.common.levelgen.feature.SmallCupLichenPatchFeature;
import com.teamabnormals.environmental.common.levelgen.feature.StoneCupLichenPatchFeature;
import com.teamabnormals.environmental.common.levelgen.feature.TasselflowerPatchFeature;
import com.teamabnormals.environmental.common.levelgen.feature.WeepingWillowTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.WillowTreePlacerFeature;
import com.teamabnormals.environmental.common.levelgen.feature.WisteriaTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.ZebraDazzleFeature;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.DwarfSpruceConfiguration;
import com.teamabnormals.environmental.common.levelgen.placement.BetterNoiseBasedCountPlacement;
import com.teamabnormals.environmental.common.levelgen.treedecorators.HangingWillowDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.HangingWisteriaDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.PinePodzolDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.PineconeDecorator;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalNoiseParameters;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"environmental");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"environmental");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FALLEN_LEAVES = FEATURES.register("fallen_leaves", () -> new FallenLeavesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CATTAILS = FEATURES.register("cattails", () -> new CattailsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> DENSE_CATTAILS = FEATURES.register("dense_cattails", () -> new DenseCattailsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> HIBISCUS_BUSH = FEATURES.register("hibiscus_bush", () -> new HibiscusBushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> TASSELFLOWER_PATCH = FEATURES.register("tasselflower_patch", () -> new TasselflowerPatchFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> LARGE_BLUEBELL_PATCH = FEATURES.register("large_bluebell_patch", () -> new LargeBluebellPatchFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> GRAINY_COARSE_DIRT = FEATURES.register("grainy_coarse_dirt", () -> new GrainyCoarseDirtFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> COARSE_DIRT_ON_STONE = FEATURES.register("coarse_dirt_on_stone", () -> new CoarseDirtOnStoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SMALL_COARSE_DIRT_ON_STONE = FEATURES.register("small_coarse_dirt_on_stone", () -> new SmallCoarseDirtOnStoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<BlockStateConfiguration>> PINE_SLOPES_BOULDER = FEATURES.register("pine_slopes_boulder", () -> new PineSlopesBoulderFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FALLEN_PINE_TREE = FEATURES.register("fallen_pine_tree", () -> new FallenPineTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FALLEN_TALL_PINE_TREE = FEATURES.register("fallen_tall_pine_tree", () -> new FallenTallPineTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<SimpleBlockConfiguration>> CARTWHEEL = FEATURES.register("cartwheel", () -> new CartwheelFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> SHORT_BAMBOO = FEATURES.register("short_bamboo", () -> new ShortBambooFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final RegistryObject<Feature<DwarfSpruceConfiguration>> DWARF_SPRUCE = FEATURES.register("dwarf_spruce", () -> new DwarfSpruceFeature(DwarfSpruceConfiguration.CODEC));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CUP_LICHEN_PATCH = FEATURES.register("cup_lichen_patch", () -> new CupLichenPatchFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SMALL_CUP_LICHEN_PATCH = FEATURES.register("small_cup_lichen_patch", () -> new SmallCupLichenPatchFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> STONE_CUP_LICHEN_PATCH = FEATURES.register("stone_cup_lichen_patch", () -> new StoneCupLichenPatchFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<TreeConfiguration>> WEEPING_WILLOW_TREE = FEATURES.register("weeping_willow_tree", () -> new WeepingWillowTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> CHERRY_TREE = FEATURES.register("cherry_tree", () -> new CherryTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> WISTERIA_TREE = FEATURES.register("wisteria_tree", () -> new WisteriaTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> PINE_TREE = FEATURES.register("pine_tree", () -> new PineTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> PINE_TREE_ON_STONE = FEATURES.register("pine_tree_on_stone", () -> new PineTreeOnStoneFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> WILLOW_TREE_PLACER = FEATURES.register("willow_tree_placer", () -> new WillowTreePlacerFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ZEBRA_DAZZLE = FEATURES.register("zebra_dazzle", () -> new ZebraDazzleFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<TreeDecoratorType<?>> HANGING_WILLOW_LEAVES = TREE_DECORATORS.register("hanging_willow_leaves", () -> new TreeDecoratorType(HangingWillowDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<?>> HANGING_WISTERIA_LEAVES = TREE_DECORATORS.register("hanging_wisteria_leaves", () -> new TreeDecoratorType(HangingWisteriaDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<?>> PINECONE = TREE_DECORATORS.register("pinecone", () -> new TreeDecoratorType(PineconeDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<?>> PINE_PODZOL = TREE_DECORATORS.register("pine_podzol", () -> new TreeDecoratorType(PinePodzolDecorator.CODEC));

    public static final class EnvironmentalPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"environmental");
        private static final PlacementFilter PINE_ON_STONE_PLACEMENT_FILTER = BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224768_((Vec3i)Direction.DOWN.m_122436_(), (TagKey)BlockTags.f_13061_));
        public static final RegistryObject<PlacedFeature> ORE_MUD = EnvironmentalPlacedFeatures.register("ore_mud", EnvironmentalConfiguredFeatures.ORE_MUD, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76193_})), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> SEAGRASS_MARSH = EnvironmentalPlacedFeatures.register("seagrass_marsh", EnvironmentalConfiguredFeatures.SEAGRASS_MID, AquaticPlacements.m_195233_((int)128));
        public static final RegistryObject<PlacedFeature> PATCH_WATERLILY_MARSH = EnvironmentalPlacedFeatures.register("patch_waterlily", EnvironmentalConfiguredFeatures.PATCH_WATERLILY, VegetationPlacements.m_195474_((int)1));
        public static final RegistryObject<PlacedFeature> PATCH_DUCKWEED = EnvironmentalPlacedFeatures.register("patch_duckweed", EnvironmentalConfiguredFeatures.PATCH_DUCKWEED, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_DUCKWEED_SWAMP = EnvironmentalPlacedFeatures.register("patch_duckweed_swamp", EnvironmentalConfiguredFeatures.PATCH_DUCKWEED, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BLUE_ORCHID = EnvironmentalPlacedFeatures.register("flower_blue_orchid", EnvironmentalConfiguredFeatures.FLOWER_BLUE_ORCHID, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_CORNFLOWER = EnvironmentalPlacedFeatures.register("flower_cornflower", EnvironmentalConfiguredFeatures.FLOWER_CORNFLOWER, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_DIANTHUS = EnvironmentalPlacedFeatures.register("flower_dianthus", EnvironmentalConfiguredFeatures.FLOWER_DIANTHUS, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BLUEBELL = EnvironmentalPlacedFeatures.register("flower_bluebell", EnvironmentalConfiguredFeatures.FLOWER_BLUEBELL, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BLUEBELL_LARGE = EnvironmentalPlacedFeatures.register("flower_bluebell_large", EnvironmentalConfiguredFeatures.FLOWER_BLUEBELL_LARGE, new PlacementModifier[]{RarityFilter.m_191900_((int)256), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_VIOLET = EnvironmentalPlacedFeatures.register("flower_violet", EnvironmentalConfiguredFeatures.FLOWER_VIOLET, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_RED_LOTUS = EnvironmentalPlacedFeatures.register("flower_red_lotus", EnvironmentalConfiguredFeatures.FLOWER_RED_LOTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_WHITE_LOTUS = EnvironmentalPlacedFeatures.register("flower_white_lotus", EnvironmentalConfiguredFeatures.FLOWER_WHITE_LOTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BIRD_OF_PARADISE = EnvironmentalPlacedFeatures.register("flower_bird_of_paradise", EnvironmentalConfiguredFeatures.FLOWER_BIRD_OF_PARADISE, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_TULIPS = EnvironmentalPlacedFeatures.register("patch_tulips", EnvironmentalConfiguredFeatures.PATCH_TULIPS, new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FOREST_FLOWERS = EnvironmentalPlacedFeatures.register("forest_flowers", EnvironmentalConfiguredFeatures.FOREST_FLOWERS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, CountPlacement.m_191630_((IntProvider)ClampedInt.m_146395_((IntProvider)UniformInt.m_146622_((int)-3, (int)1), (int)0, (int)1)), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_TASSELFLOWER = EnvironmentalPlacedFeatures.register("patch_tasselflower", EnvironmentalConfiguredFeatures.PATCH_TASSELFLOWER, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_DELPHINIUMS = EnvironmentalPlacedFeatures.register("patch_delphiniums", EnvironmentalConfiguredFeatures.PATCH_DELPHINIUMS, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, CountPlacement.m_191630_((IntProvider)ClampedInt.m_146395_((IntProvider)UniformInt.m_146622_((int)-3, (int)2), (int)0, (int)2)), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_CARTWHEEL = EnvironmentalPlacedFeatures.register("flower_cartwheel", EnvironmentalConfiguredFeatures.FLOWER_CARTWHEEL, new PlacementModifier[]{RarityFilter.m_191900_((int)12), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> ZEBRA_DAZZLE = EnvironmentalPlacedFeatures.register("zebra_dazzle", EnvironmentalConfiguredFeatures.ZEBRA_DAZZLE, new PlacementModifier[]{RarityFilter.m_191900_((int)128), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> HIBISCUS_BUSH = EnvironmentalPlacedFeatures.register("hibiscus_bush", EnvironmentalConfiguredFeatures.HIBISCUS_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)256), CountPlacement.m_191628_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> WHITE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("white_wisteria_bees_002", EnvironmentalConfiguredFeatures.WHITE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> PINK_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("pink_wisteria_bees_002", EnvironmentalConfiguredFeatures.PINK_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> PURPLE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("purple_wisteria_bees_002", EnvironmentalConfiguredFeatures.PURPLE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> BLUE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("blue_wisteria_bees_002", EnvironmentalConfiguredFeatures.BLUE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> TREES_WISTERIA = EnvironmentalPlacedFeatures.register("trees_wisteria", EnvironmentalConfiguredFeatures.TREES_WISTERIA, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)2)));
        public static final RegistryObject<PlacedFeature> TREES_WILLOW = EnvironmentalPlacedFeatures.register("trees_willow", EnvironmentalConfiguredFeatures.TREES_WILLOW, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> SWAMP_OAK = EnvironmentalPlacedFeatures.register("swamp_oak", EnvironmentalConfiguredFeatures.SWAMP_OAK, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> TREES_MARSH = EnvironmentalPlacedFeatures.register("trees_marsh", EnvironmentalConfiguredFeatures.MARSH_OAK, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_SWAMP = EnvironmentalPlacedFeatures.register("trees_swamp", EnvironmentalConfiguredFeatures.TREES_SWAMP, new PlacementModifier[]{PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)2), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)Blocks.f_50746_.m_49966_(), (Vec3i)BlockPos.f_121853_))});
        public static final RegistryObject<PlacedFeature> HUGE_BROWN_MUSHROOM_MARSH = EnvironmentalPlacedFeatures.register("huge_brown_mushroom_marsh", EnvironmentalConfiguredFeatures.HUGE_BROWN_MUSHROOM, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.025f, (int)1)));
        public static final RegistryObject<PlacedFeature> CHERRY_BEES_0002 = EnvironmentalPlacedFeatures.register("cherry_bees_0002", EnvironmentalConfiguredFeatures.CHERRY_BEES_0002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> CHEERFUL_CHERRY_BEES_0002 = EnvironmentalPlacedFeatures.register("cheerful_cherry_bees_0002", EnvironmentalConfiguredFeatures.CHEERFUL_CHERRY_BEES_0002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> MOODY_CHERRY_BEES_0002 = EnvironmentalPlacedFeatures.register("moody_cherry_bees_0002", EnvironmentalConfiguredFeatures.MOODY_CHERRY_BEES_0002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> CHERRY_BEES_005 = EnvironmentalPlacedFeatures.register("cherry_bees_005", EnvironmentalConfiguredFeatures.CHERRY_BEES_005, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> CHEERFUL_CHERRY_BEES_005 = EnvironmentalPlacedFeatures.register("cheerful_cherry_bees_005", EnvironmentalConfiguredFeatures.CHEERFUL_CHERRY_BEES_005, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> MOODY_CHERRY_BEES_005 = EnvironmentalPlacedFeatures.register("moody_cherry_bees_005", EnvironmentalConfiguredFeatures.MOODY_CHERRY_BEES_005, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> CHERRY_TREES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("cherry_tree_blossom_woods", EnvironmentalConfiguredFeatures.TREES_BLOSSOM_WOODS, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)12, (float)0.1f, (int)1), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> CHERRY_TREES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("cherry_tree_blossom_valleys", EnvironmentalConfiguredFeatures.TREES_BLOSSOM_VALLEYS, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.1f, (int)3), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> PINE_TREES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("pine_trees_blossom_woods", EnvironmentalConfiguredFeatures.PINE_BEES_0002, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.05f, (int)7), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> PINE_TREES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("pine_trees_blossom_valleys", EnvironmentalConfiguredFeatures.PINE_BEES_0002, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.05f, (int)3), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> FALLEN_CHERRY_LEAVES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("fallen_cherry_leaves_blossom_woods", EnvironmentalConfiguredFeatures.FALLEN_CHERRY_LEAVES, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FALLEN_CHERRY_LEAVES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("fallen_cherry_leaves_blossom_valleys", EnvironmentalConfiguredFeatures.FALLEN_CHERRY_LEAVES, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BLOSSOM_WOODS_ROCK = EnvironmentalPlacedFeatures.register("blossom_woods_rock", EnvironmentalConfiguredFeatures.STONE_ROCK, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PINE = EnvironmentalPlacedFeatures.register("pine", EnvironmentalConfiguredFeatures.PINE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> TALL_PINE_WITH_PODZOL = EnvironmentalPlacedFeatures.register("tall_pine_with_podzol", EnvironmentalConfiguredFeatures.TALL_PINE_WITH_PODZOL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> TREES_PINE_BARRENS = EnvironmentalPlacedFeatures.register("trees_pine_barrens", EnvironmentalConfiguredFeatures.TREES_PINE_BARRENS, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)14, (float)0.1f, (int)1), new PlacementModifier[0]));
        public static final RegistryObject<PlacedFeature> TREES_OLD_GROWTH_PINE_BARRENS = EnvironmentalPlacedFeatures.register("trees_old_growth_pine_barrens", EnvironmentalConfiguredFeatures.TREES_OLD_GROWTH_PINE_BARRENS, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)22, (float)0.1f, (int)1), new PlacementModifier[0]));
        public static final RegistryObject<PlacedFeature> TREES_PINE_BARRENS_ON_STONE = EnvironmentalPlacedFeatures.register("trees_pine_barrens_on_stone", EnvironmentalConfiguredFeatures.PINE_ON_STONE, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), new PlacementModifier[]{PINE_ON_STONE_PLACEMENT_FILTER}));
        public static final RegistryObject<PlacedFeature> TREES_PINE_SLOPES = EnvironmentalPlacedFeatures.register("trees_pine_slopes", EnvironmentalConfiguredFeatures.PINE_ON_STONE, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)6, (float)0.1f, (int)1), new PlacementModifier[]{PINE_ON_STONE_PLACEMENT_FILTER}));
        public static final RegistryObject<PlacedFeature> GRAINY_COARSE_DIRT = EnvironmentalPlacedFeatures.register("grainy_coarse_dirt", EnvironmentalConfiguredFeatures.GRAINY_COARSE_DIRT, new PlacementModifier[]{CountPlacement.m_191628_((int)56), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> COARSE_DIRT_ON_STONE = EnvironmentalPlacedFeatures.register("coarse_dirt_on_stone", EnvironmentalConfiguredFeatures.COARSE_DIRT_ON_STONE, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> SMALL_COARSE_DIRT_ON_STONE = EnvironmentalPlacedFeatures.register("small_coarse_dirt_on_stone", EnvironmentalConfiguredFeatures.SMALL_COARSE_DIRT_ON_STONE, new PlacementModifier[]{CountPlacement.m_191628_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FALLEN_PINE_TREE = EnvironmentalPlacedFeatures.register("fallen_pine_tree", EnvironmentalConfiguredFeatures.FALLEN_PINE_TREE, new PlacementModifier[]{RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FALLEN_TALL_PINE_TREE = EnvironmentalPlacedFeatures.register("fallen_tall_pine_tree", EnvironmentalConfiguredFeatures.FALLEN_TALL_PINE_TREE, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DWARF_SPRUCE = EnvironmentalPlacedFeatures.register("dwarf_spruce", EnvironmentalConfiguredFeatures.DWARF_SPRUCE, new PlacementModifier[]{PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DWARF_SPRUCE_DENSE = EnvironmentalPlacedFeatures.register("dwarf_spruce_dense", EnvironmentalConfiguredFeatures.DWARF_SPRUCE_DENSE, new PlacementModifier[]{PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DWARF_SPRUCE_TAIGA = EnvironmentalPlacedFeatures.register("dwarf_spruce_taiga", EnvironmentalConfiguredFeatures.DWARF_SPRUCE_TAIGA, new PlacementModifier[]{PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DWARF_SPRUCE_TAIGA_DENSE = EnvironmentalPlacedFeatures.register("dwarf_spruce_taiga_dense", EnvironmentalConfiguredFeatures.DWARF_SPRUCE_DENSE, new PlacementModifier[]{PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_CUP_LICHEN = EnvironmentalPlacedFeatures.register("patch_cup_lichen", EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_CUP_LICHEN_SMALL = EnvironmentalPlacedFeatures.register("patch_cup_lichen_small", EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN_SMALL, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_CUP_LICHEN_STONE = EnvironmentalPlacedFeatures.register("patch_cup_lichen_stone", EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN_STONE, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_CUP_LICHEN_NOISE = EnvironmentalPlacedFeatures.register("patch_cup_lichen_noise", EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN_NOISE, new PlacementModifier[]{new BetterNoiseBasedCountPlacement((Holder<NormalNoise.NoiseParameters>)((Holder)EnvironmentalNoiseParameters.NOISE_CUP_LICHEN.getHolder().orElseThrow()), 18, -0.6f), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PINE_SLOPES_ROCK = EnvironmentalPlacedFeatures.register("pine_slopes_rock", EnvironmentalConfiguredFeatures.STONE_ROCK, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PINE_SLOPES_BOULDER = EnvironmentalPlacedFeatures.register("pine_slopes_boulder", EnvironmentalConfiguredFeatures.PINE_SLOPES_BOULDER, new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("bamboo_blossom_woods", EnvironmentalConfiguredFeatures.BAMBOO_SHORT_PODZOL, new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)11, (double)5.0, (double)0.2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_LIGHT_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("bamboo_light_blossom_woods", EnvironmentalConfiguredFeatures.BAMBOO_SHORT_PODZOL, new PlacementModifier[]{RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("bamboo_blossom_valleys", EnvironmentalConfiguredFeatures.BAMBOO_SHORT, new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)5, (double)5.0, (double)0.2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_LIGHT_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("bamboo_light_blossom_valleys", EnvironmentalConfiguredFeatures.BAMBOO_SHORT, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_MARSH = EnvironmentalPlacedFeatures.register("patch_grass_marsh", EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.m_195474_((int)5));
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("patch_grass_blossom_woods", EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.m_195474_((int)12));
        public static final RegistryObject<PlacedFeature> PATCH_MYCELIUM_SPROUTS = EnvironmentalPlacedFeatures.register("patch_mycelium_sprouts", EnvironmentalConfiguredFeatures.PATCH_MYCELIUM_SPROUTS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_PINE_BARRENS = EnvironmentalPlacedFeatures.register("patch_grass_pine_barrens", EnvironmentalConfiguredFeatures.PATCH_PINE_BARRENS_GRASS, VegetationPlacements.m_195474_((int)2));
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_SNOWY_PINE_BARRENS = EnvironmentalPlacedFeatures.register("patch_grass_snowy_pine_barrens", EnvironmentalConfiguredFeatures.PATCH_PINE_BARRENS_GRASS, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_OLD_GROWTH_PINE_BARRENS = EnvironmentalPlacedFeatures.register("patch_grass_old_growth_pine_barrens", EnvironmentalConfiguredFeatures.PATCH_PINE_BARRENS_GRASS, VegetationPlacements.m_195474_((int)8));
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_PINE_SLOPES = EnvironmentalPlacedFeatures.register("patch_grass_pine_slopes", EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.m_195474_((int)26));
        public static final RegistryObject<PlacedFeature> PATCH_LARGE_FERN_JUNGLE = EnvironmentalPlacedFeatures.register("patch_large_fern_jungle", EnvironmentalConfiguredFeatures.PATCH_JUNGLE_LARGE_FERN, new PlacementModifier[]{RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_LARGE_FERN_PINE_BARRENS = EnvironmentalPlacedFeatures.register("patch_large_fern_pine_barrens", EnvironmentalConfiguredFeatures.PATCH_JUNGLE_LARGE_FERN, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_PLAINS = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_plains", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_SAVANNA = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_savanna", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_JUNGLE = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_jungle", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_MARSH = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_marsh", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{CountPlacement.m_191628_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CATTAILS = EnvironmentalPlacedFeatures.register("cattails", EnvironmentalConfiguredFeatures.CATTAILS, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CATTAILS_DENSE = EnvironmentalPlacedFeatures.register("cattails_dense", EnvironmentalConfiguredFeatures.CATTAILS_DENSE, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_SUGAR_CANE_BLOSSOM = EnvironmentalPlacedFeatures.register("patch_sugar_cane_blossom", EnvironmentalConfiguredFeatures.PATCH_SUGAR_CANE, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static ImmutableList<PlacementModifier> treePlacement(PlacementModifier modifier, PlacementModifier ... extraModifiers) {
            return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.m_191715_()).add((Object)VegetationPlacements.f_195420_).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).add((Object[])extraModifiers).build();
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
            return EnvironmentalPlacedFeatures.register(name, feature, List.of(placementModifiers));
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Collection)placementModifiers)));
        }
    }

    public static final class EnvironmentalConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"environmental");
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WILLOW = EnvironmentalConfiguredFeatures.register("willow", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.WILLOW));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WEEPING_WILLOW = EnvironmentalConfiguredFeatures.register("weeping_willow", () -> new ConfiguredFeature((Feature)WEEPING_WILLOW_TREE.get(), (FeatureConfiguration)Configs.WEEPING_WILLOW));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> TREES_WILLOW = EnvironmentalConfiguredFeatures.register("trees_willow", () -> new ConfiguredFeature((Feature)WILLOW_TREE_PLACER.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_SWAMP = EnvironmentalConfiguredFeatures.register("trees_swamp", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.SWAMP_OAK.getHolder().get(), 0.1f)), (Holder)EnvironmentalPlacedFeatures.TREES_WILLOW.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> SWAMP_OAK = EnvironmentalConfiguredFeatures.register("swamp_oak", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.SWAMP_OAK));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> MARSH_OAK = EnvironmentalConfiguredFeatures.register("marsh_oak", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195385_, 0.33333334f)), TreePlacements.f_195374_)));
        public static final RegistryObject<ConfiguredFeature<BlockStateConfiguration, ?>> STONE_ROCK = EnvironmentalConfiguredFeatures.register("stone_rock", () -> new ConfiguredFeature(Feature.f_65780_, (FeatureConfiguration)new BlockStateConfiguration(Blocks.f_50069_.m_49966_())));
        public static final RegistryObject<ConfiguredFeature<BlockStateConfiguration, ?>> PINE_SLOPES_BOULDER = EnvironmentalConfiguredFeatures.register("pine_slopes_boulder", () -> new ConfiguredFeature((Feature)PINE_SLOPES_BOULDER.get(), (FeatureConfiguration)new BlockStateConfiguration(Blocks.f_50069_.m_49966_())));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHERRY = EnvironmentalConfiguredFeatures.register("cherry", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHERRY));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHERRY_BEES_0002 = EnvironmentalConfiguredFeatures.register("cherry_bees_0002", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHERRY_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHERRY_BEES_005 = EnvironmentalConfiguredFeatures.register("cherry_bees_005", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHERRY_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHEERFUL_CHERRY = EnvironmentalConfiguredFeatures.register("cheerful_cherry", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHEERFUL_CHERRY));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHEERFUL_CHERRY_BEES_0002 = EnvironmentalConfiguredFeatures.register("cheerful_cherry_bees_0002", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHEERFUL_CHERRY_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHEERFUL_CHERRY_BEES_005 = EnvironmentalConfiguredFeatures.register("cheerful_cherry_bees_005", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHEERFUL_CHERRY_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MOODY_CHERRY = EnvironmentalConfiguredFeatures.register("moody_cherry", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.MOODY_CHERRY));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MOODY_CHERRY_BEES_0002 = EnvironmentalConfiguredFeatures.register("moody_cherry_bees_0002", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.MOODY_CHERRY_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MOODY_CHERRY_BEES_005 = EnvironmentalConfiguredFeatures.register("moody_cherry_bees_005", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.MOODY_CHERRY_BEES_005));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_BLOSSOM_WOODS = EnvironmentalConfiguredFeatures.register("trees_blossom_woods", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195392_, 0.05f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.CHEERFUL_CHERRY_BEES_0002.getHolder().get(), 0.3f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.MOODY_CHERRY_BEES_0002.getHolder().get(), 0.3f)), (Holder)EnvironmentalPlacedFeatures.CHERRY_BEES_0002.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_BLOSSOM_VALLEYS = EnvironmentalConfiguredFeatures.register("trees_blossom_valleys", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195393_, 0.05f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.CHEERFUL_CHERRY_BEES_005.getHolder().get(), 0.3f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.MOODY_CHERRY_BEES_005.getHolder().get(), 0.3f)), (Holder)EnvironmentalPlacedFeatures.CHERRY_BEES_005.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_WISTERIA = EnvironmentalConfiguredFeatures.register("white_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.WHITE_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("white_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.WHITE_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("white_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.WHITE_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> BLUE_WISTERIA = EnvironmentalConfiguredFeatures.register("blue_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.BLUE_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> BLUE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("blue_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.BLUE_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> BLUE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("blue_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.BLUE_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PURPLE_WISTERIA = EnvironmentalConfiguredFeatures.register("purple_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PURPLE_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PURPLE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("purple_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PURPLE_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PURPLE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("purple_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PURPLE_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_WISTERIA = EnvironmentalConfiguredFeatures.register("pink_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PINK_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("pink_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PINK_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("pink_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PINK_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_WISTERIA = EnvironmentalConfiguredFeatures.register("trees_wisteria", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.PINK_WISTERIA_BEES_002.getHolder().get(), 0.25f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.BLUE_WISTERIA_BEES_002.getHolder().get(), 0.25f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.PURPLE_WISTERIA_BEES_002.getHolder().get(), 0.25f)), (Holder)EnvironmentalPlacedFeatures.WHITE_WISTERIA_BEES_002.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINE = EnvironmentalConfiguredFeatures.register("pine", () -> new ConfiguredFeature((Feature)PINE_TREE.get(), (FeatureConfiguration)Configs.PINE));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINE_BEES_0002 = EnvironmentalConfiguredFeatures.register("pine_bees_0002", () -> new ConfiguredFeature((Feature)PINE_TREE.get(), (FeatureConfiguration)Configs.PINE_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINE_ON_STONE = EnvironmentalConfiguredFeatures.register("pine_on_stone", () -> new ConfiguredFeature((Feature)PINE_TREE_ON_STONE.get(), (FeatureConfiguration)Configs.PINE));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> TALL_PINE = EnvironmentalConfiguredFeatures.register("tall_pine", () -> new ConfiguredFeature((Feature)PINE_TREE.get(), (FeatureConfiguration)Configs.TALL_PINE));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> TALL_PINE_WITH_PODZOL = EnvironmentalConfiguredFeatures.register("tall_pine_with_podzol", () -> new ConfiguredFeature((Feature)PINE_TREE.get(), (FeatureConfiguration)Configs.TALL_PINE_WITH_PODZOL));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_PINE_BARRENS = EnvironmentalConfiguredFeatures.register("trees_pine_barrens", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195378_, 0.2f)), (Holder)EnvironmentalPlacedFeatures.PINE.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_OLD_GROWTH_PINE_BARRENS = EnvironmentalConfiguredFeatures.register("trees_old_growth_pine_barrens", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195378_, 0.15f)), (Holder)EnvironmentalPlacedFeatures.TALL_PINE_WITH_PODZOL.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> GRAINY_COARSE_DIRT = EnvironmentalConfiguredFeatures.register("grainy_coarse_dirt", () -> new ConfiguredFeature((Feature)GRAINY_COARSE_DIRT.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.1f)));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> COARSE_DIRT_ON_STONE = EnvironmentalConfiguredFeatures.register("coarse_dirt_on_stone", () -> new ConfiguredFeature((Feature)COARSE_DIRT_ON_STONE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> SMALL_COARSE_DIRT_ON_STONE = EnvironmentalConfiguredFeatures.register("small_coarse_dirt_on_stone", () -> new ConfiguredFeature((Feature)SMALL_COARSE_DIRT_ON_STONE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> FALLEN_PINE_TREE = EnvironmentalConfiguredFeatures.register("fallen_pine_tree", () -> new ConfiguredFeature((Feature)FALLEN_PINE_TREE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> FALLEN_TALL_PINE_TREE = EnvironmentalConfiguredFeatures.register("fallen_tall_pine_tree", () -> new ConfiguredFeature((Feature)FALLEN_TALL_PINE_TREE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<DwarfSpruceConfiguration, ?>> DWARF_SPRUCE = EnvironmentalConfiguredFeatures.register("dwarf_spruce", () -> new ConfiguredFeature((Feature)DWARF_SPRUCE.get(), (FeatureConfiguration)new DwarfSpruceConfiguration(5, 0.6f)));
        public static final RegistryObject<ConfiguredFeature<DwarfSpruceConfiguration, ?>> DWARF_SPRUCE_DENSE = EnvironmentalConfiguredFeatures.register("dwarf_spruce_dense", () -> new ConfiguredFeature((Feature)DWARF_SPRUCE.get(), (FeatureConfiguration)new DwarfSpruceConfiguration(96, -0.8f)));
        public static final RegistryObject<ConfiguredFeature<DwarfSpruceConfiguration, ?>> DWARF_SPRUCE_TAIGA = EnvironmentalConfiguredFeatures.register("dwarf_spruce_taiga", () -> new ConfiguredFeature((Feature)DWARF_SPRUCE.get(), (FeatureConfiguration)new DwarfSpruceConfiguration(3, 0.0)));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_CUP_LICHEN = EnvironmentalConfiguredFeatures.register("patch_cup_lichen", () -> new ConfiguredFeature((Feature)CUP_LICHEN_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_CUP_LICHEN_SMALL = EnvironmentalConfiguredFeatures.register("patch_cup_lichen_small", () -> new ConfiguredFeature((Feature)SMALL_CUP_LICHEN_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_CUP_LICHEN_STONE = EnvironmentalConfiguredFeatures.register("patch_cup_lichen_stone", () -> new ConfiguredFeature((Feature)STONE_CUP_LICHEN_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> PATCH_CUP_LICHEN_NOISE = EnvironmentalConfiguredFeatures.register("patch_cup_lichen_noise", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)((Holder)PATCH_CUP_LICHEN_SMALL.getHolder().get()), (PlacementModifier[])new PlacementModifier[0]), 0.8f)), PlacementUtils.m_206506_((Holder)((Holder)PATCH_CUP_LICHEN.getHolder().get()), (PlacementModifier[])new PlacementModifier[0]))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_BLUE_ORCHID = EnvironmentalConfiguredFeatures.register("flower_blue_orchid", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50113_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_CORNFLOWER = EnvironmentalConfiguredFeatures.register("flower_cornflower", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50121_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_DIANTHUS = EnvironmentalConfiguredFeatures.register("flower_dianthus", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.DIANTHUS.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_BLUEBELL = EnvironmentalConfiguredFeatures.register("flower_bluebell", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(128, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.BLUEBELL.get())))))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> FLOWER_BLUEBELL_LARGE = EnvironmentalConfiguredFeatures.register("flower_bluebell_large", () -> new ConfiguredFeature((Feature)LARGE_BLUEBELL_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_VIOLET = EnvironmentalConfiguredFeatures.register("flower_violet", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(32, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.VIOLET.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_RED_LOTUS = EnvironmentalConfiguredFeatures.register("flower_red_lotus", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(24, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.RED_LOTUS_FLOWER.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_WHITE_LOTUS = EnvironmentalConfiguredFeatures.register("flower_white_lotus", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(24, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get())))))));
        public static final RegistryObject<ConfiguredFeature<SimpleBlockConfiguration, ?>> FLOWER_CARTWHEEL = EnvironmentalConfiguredFeatures.register("flower_cartwheel", () -> new ConfiguredFeature((Feature)CARTWHEEL.get(), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.NORTH)), 1).m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.SOUTH)), 1).m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.EAST)), 1).m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.WEST)), 1)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_BIRD_OF_PARADISE = EnvironmentalConfiguredFeatures.register("flower_bird_of_paradise", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.BIRD_OF_PARADISE.get()))), List.of(), (int)32)));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> PATCH_TULIPS = EnvironmentalConfiguredFeatures.register("patch_tulips", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50118_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50116_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50119_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50117_))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_TASSELFLOWER = EnvironmentalConfiguredFeatures.register("patch_tasselflower", () -> new ConfiguredFeature((Feature)TASSELFLOWER_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> PATCH_DELPHINIUMS = EnvironmentalConfiguredFeatures.register("patch_delphiniums", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> ZEBRA_DAZZLE = EnvironmentalConfiguredFeatures.register("zebra_dazzle", () -> new ConfiguredFeature((Feature)ZEBRA_DAZZLE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> HIBISCUS_BUSH = EnvironmentalConfiguredFeatures.register("hibiscus_bush", () -> new ConfiguredFeature((Feature)HIBISCUS_BUSH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> CATTAILS = EnvironmentalConfiguredFeatures.register("cattails", () -> new ConfiguredFeature((Feature)CATTAILS.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> CATTAILS_DENSE = EnvironmentalConfiguredFeatures.register("cattails_dense", () -> new ConfiguredFeature((Feature)DENSE_CATTAILS.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_DUCKWEED = EnvironmentalConfiguredFeatures.register("patch_duckweed", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(1024, 8, 5, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.DUCKWEED.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_GIANT_TALL_GRASS = EnvironmentalConfiguredFeatures.register("patch_giant_tall_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get())), 64)));
        public static final RegistryObject<ConfiguredFeature<HugeMushroomFeatureConfiguration, ?>> HUGE_BROWN_MUSHROOM = EnvironmentalConfiguredFeatures.register("huge_brown_mushroom", () -> new ConfiguredFeature(Feature.f_65772_, (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)Blocks.f_50180_.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)Blocks.f_50182_.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))), 3)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_MUD = EnvironmentalConfiguredFeatures.register("ore_mud", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(EnvironmentalBlockTags.MUD_REPLACEABLES), Blocks.f_220864_.m_49966_(), 64)));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> BAMBOO_SHORT = EnvironmentalConfiguredFeatures.register("bamboo_short", () -> new ConfiguredFeature((Feature)SHORT_BAMBOO.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.0f)));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> BAMBOO_SHORT_PODZOL = EnvironmentalConfiguredFeatures.register("bamboo_short_podzol", () -> new ConfiguredFeature((Feature)SHORT_BAMBOO.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.2f)));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> FALLEN_CHERRY_LEAVES = EnvironmentalConfiguredFeatures.register("fallen_cherry_leaves", () -> new ConfiguredFeature((Feature)FALLEN_LEAVES.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_MYCELIUM_SPROUTS = EnvironmentalConfiguredFeatures.register("patch_mycelium_sprouts", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get())), 32)));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_PINE_BARRENS_GRASS = EnvironmentalConfiguredFeatures.register("patch_pine_barrens_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50034_.m_49966_(), 3).m_146271_((Object)Blocks.f_50035_.m_49966_(), 2)), 32)));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_JUNGLE_LARGE_FERN = EnvironmentalConfiguredFeatures.register("patch_jungle_large_fern", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50360_)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_WATERLILY = EnvironmentalConfiguredFeatures.register("patch_waterlily", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(10, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50196_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_SUGAR_CANE = EnvironmentalConfiguredFeatures.register("patch_sugar_cane", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(20, 4, 0, PlacementUtils.m_206502_((Feature)Feature.f_190875_, (FeatureConfiguration)BlockColumnConfiguration.m_191224_((IntProvider)BiasedToBottomInt.m_146367_((int)2, (int)4), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50130_)), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.f_190393_, BlockPredicate.m_190399_((BlockState)Blocks.f_50130_.m_49966_(), (Vec3i)BlockPos.f_121853_), BlockPredicate.m_190430_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_224777_((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_})})}))}))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_GRASS = EnvironmentalConfiguredFeatures.register("patch_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50034_), 32)));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> FOREST_FLOWERS = EnvironmentalConfiguredFeatures.register("forest_flowers", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50356_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50357_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50358_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65762_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50071_))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> SEAGRASS_MID = EnvironmentalConfiguredFeatures.register("seagrass_mid", () -> new ConfiguredFeature((Feature)Feature.f_65735_, (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.6f)));

        private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
            return FeatureUtils.m_206470_((int)p_195204_, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
        }

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }

    public static final class Configs {
        private static final BeehiveDecorator BEEHIVE_0002 = new BeehiveDecorator(0.002f);
        private static final BeehiveDecorator BEEHIVE_002 = new BeehiveDecorator(0.02f);
        private static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
        private static final HangingWisteriaDecorator HANGING_WHITE_WISTERIA = new HangingWisteriaDecorator(0.05f);
        private static final HangingWisteriaDecorator HANGING_BLUE_WISTERIA = new HangingWisteriaDecorator(0.25f);
        private static final HangingWisteriaDecorator HANGING_PURPLE_WISTERIA = new HangingWisteriaDecorator(0.5f);
        private static final HangingWisteriaDecorator HANGING_PINK_WISTERIA = new HangingWisteriaDecorator(0.75f);
        private static final PineconeDecorator PINECONE = new PineconeDecorator(0.05f);
        public static final TreeConfiguration SWAMP_OAK = Configs.createStraightBlobTree(Blocks.f_49999_, Blocks.f_50050_, 5, 3, 0, 2).m_68249_((List)ImmutableList.of((Object)new LeaveVineDecorator(0.25f))).m_68251_();
        public static final TreeConfiguration WILLOW = Configs.createStraightBlobTree((Block)EnvironmentalBlocks.WILLOW_LOG.get(), (Block)EnvironmentalBlocks.WILLOW_LEAVES.get(), 5, 3, 0, 3).m_68249_((List)ImmutableList.of((Object)new LeaveVineDecorator(0.25f), (Object)((Object)HangingWillowDecorator.INSTANCE))).m_68251_();
        public static final TreeConfiguration WEEPING_WILLOW = Configs.createCustomTree((Block)EnvironmentalBlocks.WILLOW_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(11, 1, 0), (Block)EnvironmentalBlocks.WILLOW_LEAVES.get()).m_68249_((List)ImmutableList.of((Object)new LeaveVineDecorator(0.35f), (Object)((Object)HangingWillowDecorator.INSTANCE))).m_68251_();
        public static final TreeConfiguration CHERRY = Configs.createCherry().m_68251_();
        public static final TreeConfiguration CHERRY_BEES_0002 = Configs.createCherry().m_68249_(List.of(BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration CHERRY_BEES_005 = Configs.createCherry().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration CHEERFUL_CHERRY = Configs.createCheerfulCherry().m_68251_();
        public static final TreeConfiguration CHEERFUL_CHERRY_BEES_0002 = Configs.createCheerfulCherry().m_68249_(List.of(BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration CHEERFUL_CHERRY_BEES_005 = Configs.createCheerfulCherry().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration MOODY_CHERRY = Configs.createMoodyCherry().m_68251_();
        public static final TreeConfiguration MOODY_CHERRY_BEES_0002 = Configs.createMoodyCherry().m_68249_(List.of(BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration MOODY_CHERRY_BEES_005 = Configs.createMoodyCherry().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration WHITE_WISTERIA = Configs.createWhiteWisteria().m_68251_();
        public static final TreeConfiguration WHITE_WISTERIA_BEES_002 = Configs.createWhiteWisteria().m_68249_(List.of(HANGING_WHITE_WISTERIA, BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration WHITE_WISTERIA_BEES_005 = Configs.createWhiteWisteria().m_68249_(List.of(HANGING_WHITE_WISTERIA, BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration BLUE_WISTERIA = Configs.createBlueWisteria().m_68251_();
        public static final TreeConfiguration BLUE_WISTERIA_BEES_002 = Configs.createBlueWisteria().m_68249_(List.of(HANGING_BLUE_WISTERIA, BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration BLUE_WISTERIA_BEES_005 = Configs.createBlueWisteria().m_68249_(List.of(HANGING_BLUE_WISTERIA, BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration PURPLE_WISTERIA = Configs.createPurpleWisteria().m_68251_();
        public static final TreeConfiguration PURPLE_WISTERIA_BEES_002 = Configs.createPurpleWisteria().m_68249_(List.of(HANGING_PURPLE_WISTERIA, BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration PURPLE_WISTERIA_BEES_005 = Configs.createPurpleWisteria().m_68249_(List.of(HANGING_PURPLE_WISTERIA, BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration PINK_WISTERIA = Configs.createPinkWisteria().m_68251_();
        public static final TreeConfiguration PINK_WISTERIA_BEES_002 = Configs.createPinkWisteria().m_68249_(List.of(HANGING_PINK_WISTERIA, BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration PINK_WISTERIA_BEES_005 = Configs.createPinkWisteria().m_68249_(List.of(HANGING_PINK_WISTERIA, BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration PINE = Configs.createPine().m_68249_(List.of(PINECONE)).m_68251_();
        public static final TreeConfiguration PINE_BEES_0002 = Configs.createPine().m_68249_(List.of(PINECONE, BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration TALL_PINE = Configs.createTallPine().m_68249_(List.of(PINECONE)).m_68251_();
        public static final TreeConfiguration TALL_PINE_WITH_PODZOL = Configs.createTallPine().m_68249_(List.of(PINECONE, PinePodzolDecorator.INSTANCE)).m_68251_();

        private static TreeConfiguration.TreeConfigurationBuilder createCherry() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.CHERRY_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (Block)EnvironmentalBlocks.CHERRY_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCheerfulCherry() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.CHERRY_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(4, 1, 0), (Block)EnvironmentalBlocks.CHEERFUL_CHERRY_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createMoodyCherry() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.CHERRY_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(3, 1, 0), (Block)EnvironmentalBlocks.MOODY_CHERRY_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPine() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PINE_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(11, 3, 1), (Block)EnvironmentalBlocks.PINE_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createTallPine() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PINE_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(16, 3, 1), (Block)EnvironmentalBlocks.PINE_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createWhiteWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get(), HANGING_WHITE_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createBlueWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get(), HANGING_BLUE_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPurpleWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get(), HANGING_PURPLE_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPinkWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get(), HANGING_PINK_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockStateProvider logProvider, TrunkPlacer trunkPlacer, BlockStateProvider leavesProvider) {
            return new TreeConfiguration.TreeConfigurationBuilder(logProvider, trunkPlacer, leavesProvider, (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_();
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(Block log, TrunkPlacer trunkPlacer, Block leaves) {
            return Configs.createCustomTree((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), trunkPlacer, (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockStateProvider logProvider, BlockStateProvider leavesProvider) {
            return Configs.createCustomTree(logProvider, (TrunkPlacer)new StraightTrunkPlacer(0, 0, 0), leavesProvider);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createWisteriaTree(Block leaves, TreeDecorator ... decorators) {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.WISTERIA_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(2, 1, 0), leaves).m_68249_(List.of(decorators));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(Block log, Block leaves) {
            return Configs.createCustomTree((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block p_195147_, Block p_195148_, int p_195149_, int p_195150_, int p_195151_, int p_195152_) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)p_195147_), (TrunkPlacer)new StraightTrunkPlacer(p_195149_, p_195150_, p_195151_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)p_195148_), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)p_195152_), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
        }
    }
}

