/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public abstract class CompatModule {
    protected final String modId;

    protected CompatModule(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public abstract String shortenedId();

    public String toString() {
        return "EveryCompat " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public ResourceLocation modRes(String string) {
        return new ResourceLocation(this.modId, string);
    }

    public List<String> getAlreadySupportedMods() {
        return List.of();
    }

    public void onModInit() {
    }

    public void onModSetup() {
    }

    public void onClientInit() {
    }

    public void onClientSetup() {
    }

    public void registerWoodBlocks(Registrator<Block> registry, Collection<WoodType> woodTypes) {
    }

    public void registerLeavesBlocks(Registrator<Block> registry, Collection<LeavesType> leavesTypes) {
    }

    public void registerItems(Registrator<Item> registry) {
    }

    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
    }

    public void registerEntities(Registrator<EntityType<?>> registry) {
    }

    public final boolean isEntryAlreadyRegistered(String name, BlockType woodType, Registry<?> registry) {
        name = name.substring(name.lastIndexOf("/") + 1);
        String woodFrom = woodType.getNamespace();
        if (this.getAlreadySupportedMods().contains(woodFrom)) {
            return true;
        }
        if (woodFrom.equals(this.modId)) {
            return true;
        }
        String n1 = woodFrom + "/" + name;
        String n2 = woodFrom + "_" + name;
        if (woodType.getId().toString().equals("ecologics:azalea") && this.modId.equals("quark")) {
            return false;
        }
        if (woodType.getId().toString().equals("twilightforest:mangrove")) {
            return name.equals("mangrove_chest");
        }
        if (registry.m_7804_(new ResourceLocation(this.modId, name)) || registry.m_7804_(new ResourceLocation(this.modId, n2))) {
            return true;
        }
        if (this.shortenedId().equals("af")) {
            return false;
        }
        if (this.shortenedId().equals("ap")) {
            return false;
        }
        if (this.shortenedId().equals("vs")) {
            return false;
        }
        if (this.shortenedId().equals("abww") && woodFrom.equals("architects_palette")) {
            return false;
        }
        if (registry.m_7804_(new ResourceLocation(woodFrom, name))) {
            return true;
        }
        for (EveryCompat.CompatMod c : EveryCompat.COMPAT_MODS) {
            String compatModId = c.modId();
            if (!woodFrom.equals(c.woodFrom()) || !c.blocksFrom().contains(this.modId)) continue;
            if (registry.m_7804_(new ResourceLocation(compatModId, name))) {
                return true;
            }
            if (registry.m_7804_(new ResourceLocation(compatModId, n1))) {
                return true;
            }
            if (!registry.m_7804_(new ResourceLocation(compatModId, n2))) continue;
            return true;
        }
        return false;
    }

    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
    }

    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
    }

    public void registerBlockEntityRenderers(ClientPlatformHelper.BlockEntityRendererEvent event) {
    }

    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
    }

    public void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
    }

    public void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
    }

    @Nullable
    protected final <T extends Block> T getModBlock(String id, Class<T> blockClass) {
        return (T)((Block)Registry.f_122824_.m_7745_(this.modRes(id)));
    }

    @Nullable
    protected final Block getModBlock(String id) {
        return (Block)Registry.f_122824_.m_7745_(this.modRes(id));
    }

    @Nullable
    protected final Item getModItem(String id) {
        return (Item)Registry.f_122827_.m_7745_(this.modRes(id));
    }

    @Nullable
    protected final <T extends BlockEntityType<?>> T getModTile(String id, Class<T> blockClass) {
        return (T)((BlockEntityType)Registry.f_122830_.m_7745_(this.modRes(id)));
    }

    @Nullable
    protected final BlockEntityType<?> getModTile(String id) {
        return (BlockEntityType)Registry.f_122830_.m_7745_(this.modRes(id));
    }

    public void addWoodTexture(WoodType wood, DynClientResourcesProvider handler, ResourceManager manager, String path, Supplier<TextureImage> textureSupplier) {
        handler.addTextureIfNotPresent(manager, path, () -> {
            TextureImage t = (TextureImage)textureSupplier.get();
            this.maybeFlowerAzalea(t, manager, wood);
            return t;
        });
    }

    protected void maybeFlowerAzalea(TextureImage image, ResourceManager manager, WoodType woodType) {
        WoodType azalea;
        if (woodType.getId().toString().equals("ecologics:flowering_azalea") && (azalea = WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("ecologics:azalea"))) != null) {
            try (TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)azalea.planks));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, mask});
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("failed to apply azalea overlay: ", (Throwable)e);
            }
        }
    }

    public <T extends BlockType, B extends Block> Function<T, @Nullable B> ifHasChild(Function<T, B> supplier, String ... children) {
        return w -> {
            for (String v : children) {
                if (w.getChild(v) != null) continue;
                return null;
            }
            return (Block)supplier.apply(w);
        };
    }

    public abstract int bloatAmount();

    public void stitchAtlasTextures(ClientPlatformHelper.AtlasTextureEvent event) {
    }
}

