/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EveryCompatAPI;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.AllWoodItem;
import net.mehvahdjukaar.every_compat.modules.another_furniture.AnotherFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.camp_chair.CampChairModule;
import net.mehvahdjukaar.every_compat.modules.chipped.ChippedModule;
import net.mehvahdjukaar.every_compat.modules.decorative_blocks.DecorativeBlocksModule;
import net.mehvahdjukaar.every_compat.modules.exline.BarkCarpetsModule;
import net.mehvahdjukaar.every_compat.modules.friendsandfoes.FriendsAndFoesModule;
import net.mehvahdjukaar.every_compat.modules.furnish.FurnishModule;
import net.mehvahdjukaar.every_compat.modules.handcrafted.HandcraftedModule;
import net.mehvahdjukaar.every_compat.modules.hearth_and_home.HearthAndHomeModule;
import net.mehvahdjukaar.every_compat.modules.twigs.TwigsModule;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EveryCompat {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, CompatModule> ACTIVE_MODULES = new LinkedHashMap<String, CompatModule>();
    public static final List<CompatMod> COMPAT_MODS = new ArrayList<CompatMod>();
    public static final Map<Class<? extends BlockType>, Set<String>> ENTRY_TYPES = new HashMap<Class<? extends BlockType>, Set<String>>();
    public static CreativeModeTab MOD_TAB = null;
    public static final Supplier<AllWoodItem> ALL_WOODS = RegHelper.registerItem((ResourceLocation)EveryCompat.res("all_woods"), AllWoodItem::new);
    private int prevRegSize;
    public static final ChannelHandler CHANNEL = ChannelHandler.createChannel((ResourceLocation)EveryCompat.res("network"));
    private static int lastInd;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        ACTIVE_MODULES.values().forEach(action);
    }

    protected void commonInit() {
        EarlyConfigs.init();
        ServerDynamicResourcesHandler.INSTANCE.register();
        if (PlatformHelper.getEnv().isClient()) {
            ClientDynamicResourcesHandler.INSTANCE.register();
        }
        this.addOtherCompatMod("compatoplenty", "biomesoplenty", List.of("twigs", "farmersdelight", "quark", "woodworks"));
        this.addOtherCompatMod("compat_makeover", "biomemakeover", List.of("habitat", "farmersdelight", "quark", "decorative_blocks"));
        this.addOtherCompatMod("decorative_compat", "biomesoplenty", List.of("decorative_blocks"));
        this.addOtherCompatMod("abnormals_delight", "autumnity", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "upgrade_aquatic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "endergetic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "atmospheric", List.of("farmersdelight"));
        this.addOtherCompatMod("macawsbridgesbop", "biomesoplenty", List.of("mcwbridges"));
        this.addOtherCompatMod("macawbridgesbyg", "byg", List.of("mcwbridges"));
        this.addOtherCompatMod("mcwfencesbop", "biomesoplenty", List.of("mcwfences"));
        this.addOtherCompatMod("mcwfencesbyg", "byg", List.of("mcwfences"));
        this.addOtherCompatMod("macawsroofsbop", "biomesoplenty", List.of("mcwroofs"));
        this.addOtherCompatMod("macawsroofsbyg", "byg", List.of("mcwroofs"));
        this.addOtherCompatMod("storagedrawersunlimited", "biomesoplenty", List.of("storagedrawers"));
        this.addOtherCompatMod("abnormals_delight", "atmospheric", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "autumnity", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "endergetic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "environmental", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "upgrade_aquatic", List.of("farmersdelight"));
        this.addModule("another_furniture", () -> AnotherFurnitureModule::new);
        this.addModule("barkcarpets", () -> BarkCarpetsModule::new);
        this.addModule("campchair", () -> CampChairModule::new);
        this.addModule("chipped", () -> ChippedModule::new);
        this.addModule("decorative_blocks", () -> DecorativeBlocksModule::new);
        this.addModule("friendsandfoes", () -> FriendsAndFoesModule::new);
        this.addModule("furnish", () -> FurnishModule::new);
        this.addModule("hnh", () -> HearthAndHomeModule::new);
        this.addModule("twigs", () -> TwigsModule::new);
        this.addModule("handcrafted", () -> HandcraftedModule::new);
        EveryCompat.forAllModules(m -> LOGGER.info("Loaded {}", (Object)m.toString()));
        BlockSetAPI.addDynamicBlockRegistration(this::registerWoodStuff, WoodType.class);
        BlockSetAPI.addDynamicBlockRegistration(this::registerLeavesStuff, LeavesType.class);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerItems((Registrator<Item>)r), WoodType.class, (Registry)Registry.f_122827_);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerTiles(r), WoodType.class, (Registry)Registry.f_122830_);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerEntities(r), WoodType.class, (Registry)Registry.f_122826_);
    }

    private static void addOptional(String blockId, String textureId, String texturePath) {
        Registry.f_122824_.m_6612_(new ResourceLocation(blockId)).ifPresent(b -> TextureCache.registerSpecialTextureForBlock((ItemLike)b, (String)textureId, (ResourceLocation)new ResourceLocation(texturePath)));
    }

    public static <T extends BlockType> void addEntryType(Class<T> type, String childId) {
        ENTRY_TYPES.computeIfAbsent(type, t -> new HashSet()).add(childId);
    }

    private void addOtherCompatMod(String modId, String woodFrom, List<String> blocksFrom) {
        COMPAT_MODS.add(new CompatMod(modId, woodFrom, blocksFrom));
    }

    protected void addModule(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (PlatformHelper.isModLoaded((String)modId)) {
            CompatModule module = moduleFactory.get().apply(modId);
            EveryCompatAPI.registerModule(module);
        }
    }

    private void addTab() {
        MOD_TAB = PlatformHelper.createModTab((ResourceLocation)EveryCompat.res(MOD_ID), () -> ALL_WOODS.get().m_7968_(), (boolean)true).m_40779_("item_search.png");
    }

    public void commonSetup() {
        if (PlatformHelper.isModLoaded((String)"chipped")) {
            LOGGER.warn("Chipped is installed. The mod on its own adds a ludicrous amount of blocks. With Every Compat this can easily explode. You have been warned");
        }
        int newSize = Registry.f_122824_.m_13562_();
        int am = newSize - this.prevRegSize;
        float p = (float)am / (float)newSize * 100.0f;
        LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)am, (Object)String.format("%.2f", Float.valueOf(p)));
        if (p > 33.0f) {
            CompatModule bloated = ACTIVE_MODULES.values().stream().max(Comparator.comparing(CompatModule::bloatAmount)).get();
            LOGGER.error("Every Compat registered blocks make up more than one third of your registered blocks, taking up memory and load time.");
            LOGGER.error("You might want to uninstall some mods, biggest offender was {} ({} blocks)", (Object)bloated.getModId().toUpperCase(Locale.ROOT), (Object)bloated.bloatAmount());
        }
        EveryCompat.forAllModules(CompatModule::onModSetup);
    }

    public void registerWoodStuff(Registrator<Block> event, Collection<WoodType> woods) {
        WoodConfigs.init();
        if (EarlyConfigs.TAB_ENABLED.get().booleanValue()) {
            this.addTab();
        }
        this.prevRegSize = Registry.f_122824_.m_13562_();
        LOGGER.info("Registering Compat Wood Blocks");
        EveryCompat.forAllModules(m -> m.registerWoodBlocks(event, woods));
    }

    public void registerLeavesStuff(Registrator<Block> event, Collection<LeavesType> leaves) {
        LOGGER.info("Registering Compat Leaves Blocks");
        EveryCompat.forAllModules(m -> m.registerLeavesBlocks(event, leaves));
    }

    protected void registerItems(Registrator<Item> event) {
        EveryCompat.forAllModules(m -> m.registerItems(event));
    }

    protected void registerTiles(Registrator<BlockEntityType<?>> event) {
        EveryCompat.forAllModules(m -> m.registerTiles(event));
    }

    protected void registerEntities(Registrator<EntityType<?>> event) {
        EveryCompat.forAllModules(m -> m.registerEntities(event));
    }

    public static void sendPacket(ServerPlayer s) {
        if (EarlyConfigs.DEBUG_PACKET.get().booleanValue() || PlatformHelper.isDev()) {
            lastInd = 0;
            LOGGER.warn("Starting Blockstate Map validity check:");
            while (lastInd < Block.f_49791_.m_13562_()) {
                CHANNEL.sendToClientPlayer(s, (Message)new S2CBlockStateCheckMessage());
            }
        }
    }

    static {
        CHANNEL.register(NetworkDir.PLAY_TO_CLIENT, S2CBlockStateCheckMessage.class, S2CBlockStateCheckMessage::new);
        lastInd = 0;
    }

    public record CompatMod(String modId, String woodFrom, List<String> blocksFrom) {
    }

    public static class S2CBlockStateCheckMessage
    implements Message {
        public S2CBlockStateCheckMessage(FriendlyByteBuf buf) {
            int start = buf.m_130242_();
            int size = buf.m_130242_();
            boolean mismatched = false;
            for (int i = start; i < start + size; ++i) {
                try {
                    BlockState exp;
                    BlockState b;
                    CompoundTag nbt = buf.m_130260_();
                    if (nbt == null) {
                        boolean bl = true;
                    }
                    if ((b = NbtUtils.m_129241_((CompoundTag)nbt)) != (exp = (BlockState)Block.f_49791_.m_7942_(i))) {
                        if (!mismatched) {
                            LOGGER.error("Found blockstate id mismatch from " + b + "at id " + i + ". Was expecting: " + exp);
                        }
                        mismatched = true;
                        continue;
                    }
                    if (mismatched) {
                        LOGGER.error("to" + b + "at id " + i);
                    }
                    mismatched = false;
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to read blockstate in id map: ", (Throwable)e);
                    break;
                }
            }
            buf.release();
        }

        public S2CBlockStateCheckMessage() {
        }

        public void writeToBuffer(FriendlyByteBuf buf) {
            FriendlyByteBuf dummy = new FriendlyByteBuf(Unpooled.buffer());
            int start = lastInd;
            int i = lastInd;
            while (i < Block.f_49791_.m_13562_()) {
                ++lastInd;
                CompoundTag nbt = NbtUtils.m_129202_((BlockState)Block.m_49803_((int)i));
                dummy.m_130079_(nbt);
                if ((double)dummy.writerIndex() > 943718.4) break;
                ++i;
            }
            buf.m_130130_(start);
            buf.m_130130_(lastInd - start);
            buf.writeBytes((ByteBuf)dummy);
            dummy.release();
        }

        public void handle(ChannelHandler.Context context) {
        }
    }
}

