/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.handcrafted.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import earth.terrarium.handcrafted.client.block.chair.couch.CouchModel;
import earth.terrarium.handcrafted.common.block.chair.couch.CouchBlockEntity;
import earth.terrarium.handcrafted.common.block.chair.couch.ExpandableCouchBlock;
import earth.terrarium.handcrafted.common.block.property.CouchShape;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OptimizedCouchRenderer
implements BlockEntityRenderer<CouchBlockEntity> {
    public static final Map<Item, Material> OBJECT_TO_TEXTURE = new Object2ObjectOpenHashMap();
    public static OptimizedCouchRenderer INSTANCE = null;
    private final CouchModel single;
    private final CouchModel corner;
    private final CouchModel invertedCorner;
    private final CouchModel left;
    private final CouchModel middle;
    private final CouchModel right;

    public OptimizedCouchRenderer(BlockEntityRendererProvider.Context ctx) {
        EntityModelSet modelSet = ctx.m_173585_();
        this.single = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_SINGLE));
        this.corner = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_CORNER));
        this.invertedCorner = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_INVERTED_CORNER));
        this.left = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_LEFT));
        this.middle = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_MIDDLE));
        this.right = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_RIGHT));
        INSTANCE = this;
    }

    public void render(CouchBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item block = entity.m_58900_().m_60734_().m_5456_();
        Item cushion = entity.getStack().m_41720_();
        CouchShape couchShape = (CouchShape)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.COUCH_SHAPE);
        CouchModel model = switch (couchShape) {
            default -> throw new IncompatibleClassChangeError();
            case CouchShape.SINGLE -> this.single;
            case CouchShape.LEFT -> this.left;
            case CouchShape.MIDDLE -> this.middle;
            case CouchShape.RIGHT -> this.right;
            case CouchShape.INNER_LEFT, CouchShape.INNER_RIGHT -> this.corner;
            case CouchShape.OUTER_LEFT, CouchShape.OUTER_RIGHT -> this.invertedCorner;
        };
        this.doRender(model, (Direction)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.FACING), couchShape, poseStack, bufferSource, packedLight, packedOverlay, block, cushion);
    }

    public void doRender(CouchModel model, Direction direction, CouchShape couchShape, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Item block, Item cushion) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(switch (direction) {
            case Direction.EAST -> {
                switch (couchShape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(270.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(180.0f);
            }
            case Direction.SOUTH -> {
                switch (couchShape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(180.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(90.0f);
            }
            case Direction.WEST -> {
                switch (couchShape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(90.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(0.0f);
            }
            default -> {
                switch (couchShape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(0.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(270.0f);
            }
        });
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        Material blockTexture = OBJECT_TO_TEXTURE.get(block);
        model.m_7695_(poseStack, blockTexture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (cushion != Items.f_41852_) {
            Material cushionTexture = OBJECT_TO_TEXTURE.get(cushion);
            model.m_7695_(poseStack, cushionTexture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }
}

