/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.base.datatypes;

import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ItemPredicate
extends Predicate<ItemStack> {
    public static ItemPredicate of(Item item) {
        return new ItemWrapper(item);
    }

    public static ItemPredicate of(ItemEntry<?> entry) {
        return new ItemEntryWrapper(entry);
    }

    public static ItemPredicate of(TagKey<Item> tag) {
        return new TagWrapper(tag);
    }

    public static final class ItemWrapper
    implements ItemPredicate {
        private final Item item;

        public ItemWrapper(Item item) {
            this.item = item;
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.m_150930_(this.item);
        }
    }

    public static final class ItemEntryWrapper
    implements ItemPredicate {
        private final ItemEntry<?> item;

        public ItemEntryWrapper(ItemEntry<?> item) {
            this.item = item;
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.m_150930_((Item)this.item.get());
        }
    }

    public static final class TagWrapper
    implements ItemPredicate {
        private final TagKey<Item> tag;

        public TagWrapper(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }
    }
}

