/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.registry;

import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.rabbitminers.extendedgears.ExtendedCogwheels;
import com.rabbitminers.extendedgears.base.data.data_fixer_api.DataFixesInternals;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ExtendedCogwheelsDataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;
    public static List<String> validCogwheels = Arrays.asList("create:cogwheel", "create:large_cogwheel", "extendedgears:half_shaft_cogwheel", "extendedgears:large_half_shaft_cogwheel", "extendedgears:shaftless_cogwheel", "extendedgears:large_shaftless_cogwheel");

    public static void init() {
        ExtendedCogwheels.LOGGER.info("Registering data fixers");
        DataFixesInternals api = DataFixesInternals.get();
        DataFixerBuilder builder = new DataFixerBuilder(1);
        ExtendedCogwheelsDataFixers.addFixers(builder);
        api.registerFixer(1, builder.buildOptimized((Executor)Util.m_183988_()));
    }

    private static void addFixers(DataFixerBuilder builder) {
        builder.addSchema(0, DataFixesInternals.BASE_SCHEMA);
        Schema schemaV1 = builder.addSchema(1, SAME_NAMESPACED);
    }

    public static String cogwheelFixer(String string) {
        if (!string.endsWith("_cogwheel") || validCogwheels.contains(string)) {
            return string;
        }
        String size = string.contains("large_") ? "large_" : "";
        String prefix = "extendedgears:" + size;
        if (string.contains("shaftless")) {
            return prefix + "shaftless_cogwheel";
        }
        if (string.contains("half_shaft")) {
            return prefix + "half_shaft_cogwheel";
        }
        return "create:" + size + "cogwheel";
    }
}

