/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import com.mojang.brigadier.CommandDispatcher;
import de.keksuccino.fancymenu.api.background.MenuBackgroundTypeRegistry;
import de.keksuccino.fancymenu.commands.client.ClientExecutor;
import de.keksuccino.fancymenu.commands.client.CloseGuiScreenCommand;
import de.keksuccino.fancymenu.commands.client.OpenGuiScreenCommand;
import de.keksuccino.fancymenu.commands.client.VariableCommand;
import de.keksuccino.fancymenu.commands.server.ServerCloseGuiScreenCommand;
import de.keksuccino.fancymenu.commands.server.ServerOpenGuiScreenCommand;
import de.keksuccino.fancymenu.commands.server.ServerVariableCommand;
import de.keksuccino.fancymenu.keybinding.Keybinding;
import de.keksuccino.fancymenu.mainwindow.WindowHandler;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonScriptEngine;
import de.keksuccino.fancymenu.menu.button.VanillaButtonDescriptionHandler;
import de.keksuccino.fancymenu.menu.button.buttonactions.ButtonActions;
import de.keksuccino.fancymenu.menu.button.identification.ButtonIdentificator;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.customlocals.CustomLocalsHandler;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.SetupSharingEngine;
import de.keksuccino.fancymenu.menu.fancy.item.items.CustomizationItems;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.DeepCustomizationLayers;
import de.keksuccino.fancymenu.menu.fancy.music.GameMusicHandler;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.requirements.LoadingRequirements;
import de.keksuccino.fancymenu.menu.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.menu.placeholder.v1.placeholders.Placeholders;
import de.keksuccino.fancymenu.menu.servers.ServerCache;
import de.keksuccino.fancymenu.menu.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.fancymenu.menu.world.LastWorldHandler;
import de.keksuccino.fancymenu.networking.Packets;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.exceptions.InvalidValueException;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fancymenu")
public class FancyMenu {
    public static final String VERSION = "2.14.13";
    public static final String MOD_LOADER = "forge";
    public static final Logger LOGGER = LogManager.getLogger((String)"fancymenu/FancyMenu");
    public static Config config;
    public static final File MOD_DIR;
    public static final File INSTANCE_DATA_DIR;
    public static final File INSTANCE_TEMP_DATA_DIR;
    private static File animationsPath;
    private static File customizationPath;
    private static File customGuiPath;
    private static File buttonscriptPath;
    private static File panoramaPath;
    private static File slideshowPath;

    public FancyMenu() {
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                if (!MOD_DIR.isDirectory()) {
                    MOD_DIR.mkdirs();
                }
                if (!INSTANCE_DATA_DIR.isDirectory()) {
                    INSTANCE_DATA_DIR.mkdirs();
                }
                animationsPath.mkdirs();
                customizationPath.mkdirs();
                customGuiPath.mkdirs();
                buttonscriptPath.mkdirs();
                panoramaPath.mkdirs();
                slideshowPath.mkdirs();
                FancyMenu.initConfig();
                ClientExecutor.init();
                DeepCustomizationLayers.registerAll();
                ButtonActions.registerAll();
                LoadingRequirements.registerAll();
                Placeholders.registerAll();
                de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.Placeholders.registerAll();
                CustomizationItems.registerAll();
                VariableHandler.init();
                ButtonIdentificator.init();
                AnimationHandler.init();
                AnimationHandler.loadCustomAnimations();
                PanoramaHandler.init();
                SlideshowHandler.init();
                CustomGuiLoader.loadCustomGuis();
                GameIntroHandler.init();
                MenuCustomization.init();
                if (((Boolean)config.getOrDefault("enablehotkeys", (Object)true)).booleanValue()) {
                    Keybinding.init();
                }
                ButtonScriptEngine.init();
                LastWorldHandler.init();
                VanillaButtonDescriptionHandler.init();
                WindowHandler.handleForceFullscreen();
                MenuBackgroundTypeRegistry.init();
                Konkrete.addPostLoadingEvent((String)"fancymenu", this::onClientSetup);
                if (FancyMenu.isOptifineCompatibilityMode()) {
                    LOGGER.info("[FANCYMENU] Optifine compatibility mode enabled!");
                }
                LOGGER.info("[FANCYMENU] Loading v2.14.13 in client-side mode!");
                if (((Boolean)config.getOrDefault("allow_level_registry_interactions", (Object)false)).booleanValue()) {
                    LOGGER.info("[FANCYMENU] Level registry interactions allowed!");
                }
            } else {
                LOGGER.info("[FANCYMENU] Loading v2.14.13 in server-side mode!");
            }
            Packets.registerAll();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterClientCommandsEvent e) {
        OpenGuiScreenCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        CloseGuiScreenCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        VariableCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public void onRegisterServerCommands(RegisterCommandsEvent e) {
        ServerOpenGuiScreenCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        ServerCloseGuiScreenCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        ServerVariableCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private void onClientSetup() {
        try {
            FancyMenu.initLocals();
            SetupSharingEngine.init();
            CustomLocalsHandler.loadLocalizations();
            GameMusicHandler.init();
            GuiConstructor.init();
            ServerCache.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void initLocals() {
        String baseresdir = "fmlocals/";
        File f = new File(MOD_DIR.getPath() + "/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "en_us.local"), (String)"en_us", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "de_de.local"), (String)"de_de", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "pl_pl.local"), (String)"pl_pl", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "pt_br.local"), (String)"pt_br", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "zh_cn.local"), (String)"zh_cn", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "uk_ua.local"), (String)"uk_ua", (String)f.getPath());
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("keksuccino", baseresdir + "ru_ru.local"), (String)"ru_ru", (String)f.getPath());
        Locals.getLocalsFromDir((String)f.getPath());
    }

    public static void initConfig() {
        if (config == null) {
            FancyMenu.updateConfig();
        }
    }

    public static void updateConfig() {
        try {
            config = new Config(MOD_DIR.getPath() + "/config.txt");
            config.registerValue("enablehotkeys", Boolean.valueOf(true), "general", "A minecraft restart is required after changing this value.");
            config.registerValue("playmenumusic", Boolean.valueOf(true), "general");
            config.registerValue("playbackgroundsounds", Boolean.valueOf(true), "general", "If menu background sounds added by FancyMenu should be played or not.");
            config.registerValue("playbackgroundsoundsinworld", Boolean.valueOf(false), "general", "If menu background sounds added by FancyMenu should be played when a world is loaded.");
            config.registerValue("defaultguiscale", Integer.valueOf(-1), "general", "Sets the default GUI scale on first launch. Useful for modpacks. Cache data is saved in '/mods/fancymenu/'.");
            config.registerValue("showdebugwarnings", Boolean.valueOf(true), "general");
            config.registerValue("forcefullscreen", Boolean.valueOf(false), "general");
            config.registerValue("variables_to_reset_on_launch", "", "general");
            config.registerValue("showcustomizationbuttons", Boolean.valueOf(true), "customization");
            config.registerValue("advancedmode", Boolean.valueOf(false), "customization");
            config.registerValue("gameintroanimation", "", "loading");
            config.registerValue("showanimationloadingstatus", Boolean.valueOf(true), "loading");
            config.registerValue("allowgameintroskip", Boolean.valueOf(true), "loading");
            config.registerValue("customgameintroskiptext", "", "loading");
            config.registerValue("preloadanimations", Boolean.valueOf(false), "loading");
            config.registerValue("customwindowicon", Boolean.valueOf(false), "minecraftwindow", "A minecraft restart is required after changing this value.");
            config.registerValue("customwindowtitle", "", "minecraftwindow", "A minecraft restart is required after changing this value.");
            config.registerValue("showloadingscreenanimation", Boolean.valueOf(true), "world_loading_screen");
            config.registerValue("showloadingscreenpercent", Boolean.valueOf(true), "world_loading_screen");
            config.registerValue("show_server_icons", Boolean.valueOf(true), "multiplayer_screen");
            config.registerValue("show_world_icons", Boolean.valueOf(true), "singleplayer_screen");
            config.registerValue("showvanillamovewarning", Boolean.valueOf(true), "layouteditor", "If the warning when trying to move an vanilla button without an orientation should be displayed or not.");
            config.registerValue("editordeleteconfirmation", Boolean.valueOf(true), "layouteditor");
            config.registerValue("showgrid", Boolean.valueOf(false), "layouteditor");
            config.registerValue("gridsize", Integer.valueOf(10), "layouteditor");
            config.registerValue("uiscale", Float.valueOf(1.0f), "ui");
            config.registerValue("show_unicode_warning", Boolean.valueOf(true), "ui");
            config.registerValue("allow_level_registry_interactions", Boolean.valueOf(true), "compatibility");
            config.syncConfig();
            config.clearUnusedValues();
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }

    public static File getAnimationPath() {
        if (!animationsPath.exists()) {
            animationsPath.mkdirs();
        }
        return animationsPath;
    }

    public static File getCustomizationPath() {
        if (!customizationPath.exists()) {
            customizationPath.mkdirs();
        }
        return customizationPath;
    }

    public static File getCustomGuiPath() {
        if (!customGuiPath.exists()) {
            customGuiPath.mkdirs();
        }
        return customGuiPath;
    }

    public static File getButtonScriptPath() {
        if (!buttonscriptPath.exists()) {
            buttonscriptPath.mkdirs();
        }
        return buttonscriptPath;
    }

    public static File getPanoramaPath() {
        if (!panoramaPath.exists()) {
            panoramaPath.mkdirs();
        }
        return panoramaPath;
    }

    public static File getSlideshowPath() {
        if (!slideshowPath.exists()) {
            slideshowPath.mkdirs();
        }
        return slideshowPath;
    }

    @Deprecated
    public static boolean isOptifineLoaded() {
        return FancyMenu.isOptifineCompatibilityMode();
    }

    public static boolean isOptifineCompatibilityMode() {
        return Konkrete.isOptifineLoaded;
    }

    public static boolean isDrippyLoadingScreenLoaded() {
        try {
            Class.forName("de.keksuccino.drippyloadingscreen.DrippyLoadingScreen", false, FancyMenu.class.getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isKonkreteLoaded() {
        try {
            Class.forName("de.keksuccino.konkrete.Konkrete", false, FancyMenu.class.getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getMinecraftVersion() {
        return MCPVersion.getMCVersion();
    }

    public static boolean isAudioExtensionLoaded() {
        try {
            Class.forName("de.keksuccino.fmaudio.FmAudio", false, FancyMenu.class.getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static File getGameDirectory() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.m_91087_().f_91069_;
        }
        return new File("");
    }

    static {
        MOD_DIR = new File(FancyMenu.getGameDirectory(), "/config/fancymenu");
        INSTANCE_DATA_DIR = new File(FancyMenu.getGameDirectory(), "/fancymenu_data");
        INSTANCE_TEMP_DATA_DIR = new File(INSTANCE_DATA_DIR, "/temp");
        animationsPath = new File(MOD_DIR, "/animations");
        customizationPath = new File(MOD_DIR, "/customization");
        customGuiPath = new File(MOD_DIR, "/customguis");
        buttonscriptPath = new File(MOD_DIR, "/buttonscripts");
        panoramaPath = new File(MOD_DIR, "/panoramas");
        slideshowPath = new File(MOD_DIR, "/slideshows");
    }
}

