/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button.buttonactions;

import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.List;

public class LegacyButtonActions {
    public static List<String> getLegacyIdentifiers() {
        ArrayList<String> actionIdentifiers = new ArrayList<String>();
        actionIdentifiers.add("openlink");
        actionIdentifiers.add("sendmessage");
        actionIdentifiers.add("quitgame");
        actionIdentifiers.add("joinserver");
        actionIdentifiers.add("loadworld");
        actionIdentifiers.add("opencustomgui");
        actionIdentifiers.add("opengui");
        actionIdentifiers.add("openfile");
        actionIdentifiers.add("movefile");
        actionIdentifiers.add("copyfile");
        actionIdentifiers.add("deletefile");
        actionIdentifiers.add("renamefile");
        actionIdentifiers.add("downloadfile");
        actionIdentifiers.add("unpackzip");
        actionIdentifiers.add("reloadmenu");
        actionIdentifiers.add("runscript");
        actionIdentifiers.add("runcmd");
        actionIdentifiers.add("closegui");
        actionIdentifiers.add("copytoclipboard");
        actionIdentifiers.add("mimicbutton");
        actionIdentifiers.add("join_last_world");
        return actionIdentifiers;
    }

    protected static List<ButtonActionContainer> buildLegacyActionContainers() {
        ArrayList<ButtonActionContainer> actions = new ArrayList<ButtonActionContainer>();
        List<String> actionIdentifiers = LegacyButtonActions.getLegacyIdentifiers();
        for (String s : actionIdentifiers) {
            String actionDescKey = "helper.creator.custombutton.config.actiontype." + s + ".desc";
            String valueDescKey = "helper.creator.custombutton.config.actiontype." + s + ".desc.value";
            String valueExampleKey = "helper.creator.custombutton.config.actiontype." + s + ".desc.value.example";
            actions.add(LegacyButtonActions.buildContainer(s, actionDescKey, valueDescKey, valueExampleKey));
        }
        return actions;
    }

    private static ButtonActionContainer buildContainer(final String identifier, final String descLocalizationKey, final String valueDescLocalizationKey, final String valueExampleKey) {
        return new ButtonActionContainer(identifier){

            @Override
            public String getAction() {
                return identifier;
            }

            @Override
            public boolean hasValue() {
                return !valueDescLocalizationKey.equals(Locals.localize((String)valueDescLocalizationKey, (String[])new String[0]));
            }

            @Override
            public void execute(String value) {
            }

            @Override
            public String getActionDescription() {
                if (descLocalizationKey != null) {
                    return Locals.localize((String)descLocalizationKey, (String[])new String[0]);
                }
                return null;
            }

            @Override
            public String getValueDescription() {
                if (valueDescLocalizationKey != null) {
                    return Locals.localize((String)valueDescLocalizationKey, (String[])new String[0]);
                }
                return null;
            }

            @Override
            public String getValueExample() {
                return Locals.localize((String)valueExampleKey, (String[])new String[0]);
            }
        };
    }
}

