/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class HighlightPlaceholdersFormattingRule
extends TextEditorFormattingRule {
    protected Style[] colorsByLevelOfNesting = new Style[]{Style.f_131099_.m_178520_(new Color(235, 127, 127).getRGB()), Style.f_131099_.m_178520_(new Color(235, 201, 127).getRGB()), Style.f_131099_.m_178520_(new Color(190, 235, 127).getRGB()), Style.f_131099_.m_178520_(new Color(127, 235, 230).getRGB()), Style.f_131099_.m_178520_(new Color(127, 158, 235).getRGB()), Style.f_131099_.m_178520_(new Color(150, 127, 235).getRGB()), Style.f_131099_.m_178520_(new Color(212, 127, 235).getRGB()), Style.f_131099_.m_178520_(new Color(245, 54, 54).getRGB()), Style.f_131099_.m_178520_(new Color(245, 146, 54).getRGB()), Style.f_131099_.m_178520_(new Color(245, 229, 54).getRGB()), Style.f_131099_.m_178520_(new Color(105, 245, 54).getRGB()), Style.f_131099_.m_178520_(new Color(54, 137, 245).getRGB())};
    protected Map<TextEditorLine, List<PlaceholderIndexPair>> placeholderIndexes = new HashMap<TextEditorLine, List<PlaceholderIndexPair>>();

    @Override
    public void resetRule(TextEditorScreen editor) {
        this.placeholderIndexes.clear();
    }

    @Override
    @Nullable
    public Style getStyle(char atCharacterInLine, int atCharacterIndexInLine, int cursorPosInLine, TextEditorLine inLine, int atCharacterIndexTotal, TextEditorScreen editor) {
        int depth;
        int endIndex;
        String s = String.valueOf(atCharacterInLine);
        if (s.equals("{") && inLine.m_94155_().substring(atCharacterIndexInLine).startsWith("{\"placeholder\":\"") && (endIndex = HighlightPlaceholdersFormattingRule.findPlaceholderEndIndex(inLine.m_94155_(), atCharacterIndexInLine)) > -1) {
            if (!this.placeholderIndexes.containsKey((Object)inLine)) {
                this.placeholderIndexes.put(inLine, new ArrayList());
            }
            this.placeholderIndexes.get((Object)inLine).add(new PlaceholderIndexPair(atCharacterIndexInLine, endIndex));
        }
        if ((depth = this.getDepth(atCharacterIndexInLine, inLine)) > -1) {
            if (depth > this.colorsByLevelOfNesting.length - 1) {
                depth = this.colorsByLevelOfNesting.length - 1;
            }
            return this.colorsByLevelOfNesting[depth];
        }
        return null;
    }

    private int getDepth(int charIndex, TextEditorLine line) {
        if (this.placeholderIndexes.containsKey((Object)line)) {
            int depth = -1;
            for (PlaceholderIndexPair p : this.placeholderIndexes.get((Object)line)) {
                if (charIndex < p.start || charIndex > p.end) continue;
                ++depth;
            }
            return depth;
        }
        return -1;
    }

    private static int findPlaceholderEndIndex(String in, int startIndex) {
        if (in.substring(startIndex).startsWith("{") && (startIndex == 0 || !in.substring(startIndex - 1).startsWith("\\"))) {
            int currentIndex = startIndex + 1;
            int depth = 0;
            for (char c : in.substring(startIndex + 1).toCharArray()) {
                if (String.valueOf(c).equals("{") && !in.substring(currentIndex - 1).startsWith("\\")) {
                    ++depth;
                } else if (String.valueOf(c).equals("}") && !in.substring(currentIndex - 1).startsWith("\\")) {
                    if (depth <= 0) {
                        return currentIndex;
                    }
                    --depth;
                }
                ++currentIndex;
            }
        }
        return -1;
    }

    public static class PlaceholderIndexPair {
        int start;
        int end;

        public PlaceholderIndexPair(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

