/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.minecraftoptions.MinecraftOption;
import de.keksuccino.fancymenu.util.minecraftoptions.MinecraftOptions;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditMinecraftOptionAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public EditMinecraftOptionAction() {
        super("edit_minecraft_option");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null && value.contains(":")) {
            String name = value.split(":", 2)[0];
            String setTo = value.split(":", 2)[1];
            MinecraftOption instance = MinecraftOptions.getOption(name);
            if (instance == null) {
                LOGGER.error("[FANCYMENU] EditMinecraftOptionAction was unable to find Minecraft config option: " + name);
                return;
            }
            try {
                instance.set(setTo);
                Minecraft.m_91087_().f_91066_.m_92169_();
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] EditMinecraftOptionAction failed to set Minecraft config option value '" + setTo + "' to option '" + name + "'.", (Throwable)ex);
            }
        }
    }

    @NotNull
    protected static List<String> getSupportedOptionNames() {
        ArrayList<String> names = new ArrayList<String>();
        MinecraftOptions.getOptions().values().forEach(optionInstance -> names.add(optionInstance.getName()));
        if (names.isEmpty()) {
            names.add("[ERROR: UNABLE TO GET OPTION NAMES!]");
        }
        return names;
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Components.translatable("fancymenu.actions.edit_minecraft_option", new Object[0]);
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.edit_minecraft_option.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Components.empty();
    }

    @Override
    public String getValueExample() {
        return "option_name:set_to_value";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        EditMinecraftOptionActionValueScreen s = new EditMinecraftOptionActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    public static class EditMinecraftOptionActionValueScreen
    extends StringBuilderScreen {
        @NotNull
        protected String name = "";
        @NotNull
        protected String setTo = "";
        protected EditBoxSuggestions optionNameSuggestions;
        @Nullable
        protected CellScreen.LabelCell currentOptionValueLabelCell = null;

        protected EditMinecraftOptionActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Components.translatable("fancymenu.editor.actions.generic_edit_value", new Object[0]), callback);
            if (value.contains(":")) {
                this.name = value.split(":", 2)[0];
                this.setTo = value.split(":", 2)[1];
            }
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((Component)Components.translatable("fancymenu.actions.edit_minecraft_option.edit.option_name", new Object[0]));
            CellScreen.TextInputCell nameCell = this.addTextInputCell(null, true, true).setText(this.name);
            this.optionNameSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, nameCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, EditMinecraftOptionAction.getSupportedOptionNames());
            UIBase.applyDefaultWidgetSkinTo(this.optionNameSuggestions);
            nameCell.editBox.m_94151_(s -> {
                this.optionNameSuggestions.m_93881_();
                this.name = s;
                if (this.currentOptionValueLabelCell != null) {
                    this.currentOptionValueLabelCell.setText(this.buildCurrentOptionValueComponent());
                }
            });
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Components.translatable("fancymenu.actions.edit_minecraft_option.edit.set_to_value", new Object[0]));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.setTo = s;
            }).setText(this.setTo);
            this.addCellGroupEndSpacerCell();
            this.currentOptionValueLabelCell = this.addLabelCell(this.buildCurrentOptionValueComponent());
            this.addSpacerCell(20);
        }

        @NotNull
        protected Component buildCurrentOptionValueComponent() {
            String current;
            MinecraftOption instance = MinecraftOptions.getOption(this.name);
            String string = current = instance != null ? instance.get() : "-----";
            if (current == null) {
                current = "-----";
            }
            MutableComponent curComp = Components.literal(current).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
            return Components.translatable("fancymenu.actions.edit_minecraft_option.edit.current_value", curComp).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        }

        @Override
        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partial) {
            super.m_6305_(pose, mouseX, mouseY, partial);
            this.optionNameSuggestions.m_93900_(pose, mouseX, mouseY);
        }

        @Override
        public boolean m_7933_(int $$0, int $$1, int $$2) {
            if (this.optionNameSuggestions.m_93888_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_7933_($$0, $$1, $$2);
        }

        public boolean m_6050_(double $$0, double $$1, double $$2) {
            if (this.optionNameSuggestions.m_93882_($$2)) {
                return true;
            }
            return super.m_6050_($$0, $$1, $$2);
        }

        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (this.optionNameSuggestions.m_93884_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.name + ":" + this.setTo;
        }
    }
}

