/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RenderingUtils
extends GuiComponent {
    public static final RenderingUtils INSTANCE = new RenderingUtils();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    private static final List<ScissorLayer> SCISSOR_STACK = new ArrayList<ScissorLayer>();

    public static void renderMissing(@NotNull PoseStack pose, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        RenderingUtils.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + partW), (int)(y + partH), (int)MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        RenderingUtils.m_93172_((PoseStack)pose, (int)(x + partW), (int)y, (int)(x + width), (int)(y + partH), (int)MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        RenderingUtils.m_93172_((PoseStack)pose, (int)x, (int)(y + partH), (int)(x + partW), (int)(y + height), (int)MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        RenderingUtils.m_93172_((PoseStack)pose, (int)(x + partW), (int)(y + partH), (int)(x + width), (int)(y + height), (int)MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void blitRepeat(@NotNull PoseStack pose, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight) {
        RenderingUtils.blitRepeat(pose, x, y, areaRenderWidth, areaRenderHeight, texWidth, texHeight, 0, 0, texWidth, texHeight, texWidth, texHeight);
    }

    public static void blitRepeat(@NotNull PoseStack pose, int x, int y, int areaRenderWidth, int areaRenderHeight, int texRenderWidth, int texRenderHeight, int texOffsetX, int texOffsetY, int texPartWidth, int texPartHeight, int texWidth, int texHeight) {
        int repeatsVertical;
        Objects.requireNonNull(pose);
        if (areaRenderWidth <= 0 || areaRenderHeight <= 0 || texRenderWidth <= 0 || texRenderHeight <= 0 || texPartWidth <= 0 || texPartHeight <= 0) {
            return;
        }
        int repeatsHorizontal = Math.max(1, areaRenderWidth / texPartWidth);
        if (texPartWidth * repeatsHorizontal < areaRenderWidth) {
            ++repeatsHorizontal;
        }
        if (texPartHeight * (repeatsVertical = Math.max(1, areaRenderHeight / texPartHeight)) < areaRenderHeight) {
            ++repeatsVertical;
        }
        RenderingUtils.m_239260_(x, y, x + areaRenderWidth, y + areaRenderHeight);
        for (int horizontal = 0; horizontal < repeatsHorizontal; ++horizontal) {
            for (int vertical = 0; vertical < repeatsVertical; ++vertical) {
                int renderX = x + texPartWidth * horizontal;
                int renderY = y + texPartHeight * vertical;
                RenderingUtils.m_93160_((PoseStack)pose, (int)renderX, (int)renderY, (int)texRenderWidth, (int)texRenderHeight, (float)texOffsetX, (float)texOffsetY, (int)texPartWidth, (int)texPartHeight, (int)texWidth, (int)texHeight);
            }
        }
        RenderingUtils.m_240060_();
    }

    public static void blitNineSliced(@NotNull PoseStack pose, int x, int y, int renderWidth, int renderHeight, int borderLeft, int borderTop, int borderRight, int borderBottom, int texPartWidth, int texPartHeight, int texOffsetX, int texOffsetY, int texWidth, int texHeight) {
        Objects.requireNonNull(pose);
        if (renderWidth <= 0 || renderHeight <= 0 || texPartWidth <= 0 || texPartHeight <= 0 || texWidth <= 0 || texHeight <= 0) {
            return;
        }
        if (renderWidth == texWidth && renderHeight == texHeight && texOffsetX == 0 && texOffsetY == 0) {
            RenderingUtils.m_93133_((PoseStack)pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)renderWidth, (int)renderHeight, (int)renderWidth, (int)renderHeight);
            return;
        }
        RenderingUtils.m_239260_(x, y, x + renderWidth, y + renderHeight);
        if (borderLeft > 0 && borderTop > 0) {
            RenderingUtils.m_93160_((PoseStack)pose, (int)x, (int)y, (int)borderLeft, (int)borderTop, (float)texOffsetX, (float)texOffsetY, (int)borderLeft, (int)borderTop, (int)texWidth, (int)texHeight);
        }
        if (borderRight > 0 && borderTop > 0) {
            RenderingUtils.m_93160_((PoseStack)pose, (int)(x + renderWidth - borderRight), (int)y, (int)borderRight, (int)borderTop, (float)(texOffsetX + texPartWidth - borderRight), (float)texOffsetY, (int)borderRight, (int)borderTop, (int)texWidth, (int)texHeight);
        }
        if (borderLeft > 0 && borderBottom > 0) {
            RenderingUtils.m_93160_((PoseStack)pose, (int)x, (int)(y + renderHeight - borderBottom), (int)borderLeft, (int)borderBottom, (float)texOffsetX, (float)(texOffsetY + texPartHeight - borderBottom), (int)borderLeft, (int)borderBottom, (int)texWidth, (int)texHeight);
        }
        if (borderRight > 0 && borderBottom > 0) {
            RenderingUtils.m_93160_((PoseStack)pose, (int)(x + renderWidth - borderRight), (int)(y + renderHeight - borderBottom), (int)borderRight, (int)borderBottom, (float)(texOffsetX + texPartWidth - borderRight), (float)(texOffsetY + texPartHeight - borderBottom), (int)borderRight, (int)borderBottom, (int)texWidth, (int)texHeight);
        }
        RenderingUtils.m_240060_();
        if (borderTop > 0) {
            RenderingUtils.blitRepeat(pose, x + borderLeft, y, renderWidth - borderLeft - borderRight, borderTop, texPartWidth - borderLeft - borderRight, borderTop, texOffsetX + borderLeft, texOffsetY, texPartWidth - borderLeft - borderRight, borderTop, texWidth, texHeight);
        }
        if (borderBottom > 0) {
            RenderingUtils.blitRepeat(pose, x + borderLeft, y + renderHeight - borderBottom, renderWidth - borderLeft - borderRight, borderBottom, texPartWidth - borderLeft - borderRight, borderBottom, texOffsetX + borderLeft, texOffsetY + texPartHeight - borderBottom, texPartWidth - borderLeft - borderRight, borderBottom, texWidth, texHeight);
        }
        if (borderLeft > 0) {
            RenderingUtils.blitRepeat(pose, x, y + borderTop, borderLeft, renderHeight - borderTop - borderBottom, borderLeft, texPartHeight - borderTop - borderBottom, texOffsetX, texOffsetY + borderTop, borderLeft, texPartHeight - borderTop - borderBottom, texWidth, texHeight);
        }
        if (borderRight > 0) {
            RenderingUtils.blitRepeat(pose, x + renderWidth - borderRight, y + borderTop, borderRight, renderHeight - borderTop - borderBottom, borderRight, texPartHeight - borderTop - borderBottom, texOffsetX + texPartWidth - borderRight, texOffsetY + borderTop, borderRight, texPartHeight - borderTop - borderBottom, texWidth, texHeight);
        }
        RenderingUtils.blitRepeat(pose, x + borderLeft, y + borderTop, renderWidth - borderLeft - borderRight, renderHeight - borderTop - borderBottom, texPartWidth - borderLeft - borderRight, texPartHeight - borderTop - borderBottom, texOffsetX + borderLeft, texOffsetY + borderTop, texPartWidth - borderLeft - borderRight, texPartHeight - borderTop - borderBottom, texWidth, texHeight);
    }

    public static float getPartialTick() {
        return Minecraft.m_91087_().m_91104_() ? ((IMixinMinecraft)Minecraft.m_91087_()).getPausePartialTickFancyMenu() : Minecraft.m_91087_().m_91296_();
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        Window m = Minecraft.m_91087_().m_91268_();
        m.m_85378_((double)m.m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), ((Boolean)Minecraft.m_91087_().f_91066_.m_231819_().m_231551_()).booleanValue()));
    }

    public static void resetShaderColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setShaderColor(DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        RenderingUtils.setShaderColor(color, a);
    }

    public static void setShaderColor(DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
    }

    public static void bindTexture(@NotNull ResourceLocation texture, boolean depthTest) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69478_();
        if (depthTest) {
            RenderSystem.m_69482_();
        }
    }

    public static void bindTexture(@NotNull ResourceLocation texture) {
        RenderingUtils.bindTexture(texture, false);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull PoseStack pose, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(pose, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull PoseStack pose, float minX, float minY, float maxX, float maxY, float z, int color) {
        Matrix4f matrix4f = pose.m_85850_().m_85861_();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix4f, minX, minY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_85982_(matrix4f, minX, maxY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_85982_(matrix4f, maxX, maxY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_85982_(matrix4f, maxX, minY, z).m_85950_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
    }

    public static void blitF(@NotNull PoseStack pose, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(pose, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(PoseStack $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(PoseStack $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit($$0.m_85850_().m_85861_(), $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(Matrix4f $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder $$10 = Tesselator.m_85913_().m_85915_();
        $$10.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        $$10.m_85982_($$0, $$1, $$3, $$5).m_7421_($$6, $$8).m_5752_();
        $$10.m_85982_($$0, $$1, $$4, $$5).m_7421_($$6, $$9).m_5752_();
        $$10.m_85982_($$0, $$2, $$4, $$5).m_7421_($$7, $$9).m_5752_();
        $$10.m_85982_($$0, $$2, $$3, $$5).m_7421_($$7, $$8).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)$$10.m_231175_());
    }

    public static void blitNineSliced_Vanilla(PoseStack pose, int x, int y, int width, int height, int sliceSize, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        RenderingUtils.blitNineSliced_Vanilla(pose, x, y, width, height, sliceSize, sliceSize, sliceSize, sliceSize, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void blitNineSliced_Vanilla(PoseStack pose, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        RenderingUtils.blitNineSliced_Vanilla(pose, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY);
    }

    public static void blitNineSliced_Vanilla(PoseStack pose, int x, int y, int width, int height, int leftBorder, int topBorder, int rightBorder, int bottomBorder, int uWidth, int vHeight, int textureX, int textureY) {
        if (width <= 0 || height <= 0 || uWidth <= 0 || vHeight <= 0) {
            return;
        }
        leftBorder = Math.min(leftBorder, width / 2);
        rightBorder = Math.min(rightBorder, width / 2);
        topBorder = Math.min(topBorder, height / 2);
        bottomBorder = Math.min(bottomBorder, height / 2);
        if (width == uWidth && height == vHeight) {
            INSTANCE.m_93228_(pose, x, y, textureX, textureY, width, height);
        } else if (height == vHeight) {
            INSTANCE.m_93228_(pose, x, y, textureX, textureY, leftBorder, height);
            RenderingUtils.blitRepeating_Vanilla(pose, x + leftBorder, y, width - rightBorder - leftBorder, height, textureX + leftBorder, textureY, uWidth - rightBorder - leftBorder, vHeight);
            INSTANCE.m_93228_(pose, x + width - rightBorder, y, textureX + uWidth - rightBorder, textureY, rightBorder, height);
        } else if (width == uWidth) {
            INSTANCE.m_93228_(pose, x, y, textureX, textureY, width, topBorder);
            RenderingUtils.blitRepeating_Vanilla(pose, x, y + topBorder, width, height - bottomBorder - topBorder, textureX, textureY + topBorder, uWidth, vHeight - bottomBorder - topBorder);
            INSTANCE.m_93228_(pose, x, y + height - bottomBorder, textureX, textureY + vHeight - bottomBorder, width, bottomBorder);
        } else {
            INSTANCE.m_93228_(pose, x, y, textureX, textureY, leftBorder, topBorder);
            RenderingUtils.blitRepeating_Vanilla(pose, x + leftBorder, y, width - rightBorder - leftBorder, topBorder, textureX + leftBorder, textureY, uWidth - rightBorder - leftBorder, topBorder);
            INSTANCE.m_93228_(pose, x + width - rightBorder, y, textureX + uWidth - rightBorder, textureY, rightBorder, topBorder);
            INSTANCE.m_93228_(pose, x, y + height - bottomBorder, textureX, textureY + vHeight - bottomBorder, leftBorder, bottomBorder);
            RenderingUtils.blitRepeating_Vanilla(pose, x + leftBorder, y + height - bottomBorder, width - rightBorder - leftBorder, bottomBorder, textureX + leftBorder, textureY + vHeight - bottomBorder, uWidth - rightBorder - leftBorder, bottomBorder);
            INSTANCE.m_93228_(pose, x + width - rightBorder, y + height - bottomBorder, textureX + uWidth - rightBorder, textureY + vHeight - bottomBorder, rightBorder, bottomBorder);
            RenderingUtils.blitRepeating_Vanilla(pose, x, y + topBorder, leftBorder, height - bottomBorder - topBorder, textureX, textureY + topBorder, leftBorder, vHeight - bottomBorder - topBorder);
            RenderingUtils.blitRepeating_Vanilla(pose, x + leftBorder, y + topBorder, width - rightBorder - leftBorder, height - bottomBorder - topBorder, textureX + leftBorder, textureY + topBorder, uWidth - rightBorder - leftBorder, vHeight - bottomBorder - topBorder);
            RenderingUtils.blitRepeating_Vanilla(pose, x + width - rightBorder, y + topBorder, leftBorder, height - bottomBorder - topBorder, textureX + uWidth - rightBorder, textureY + topBorder, rightBorder, vHeight - bottomBorder - topBorder);
        }
    }

    public static void blitRepeating_Vanilla(PoseStack pose, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight) {
        if (width <= 0 || height <= 0 || sourceWidth <= 0 || sourceHeight <= 0) {
            return;
        }
        int i1 = x;
        IntIterator iterator = RenderingUtils.slices_Vanilla(width, sourceWidth);
        while (iterator.hasNext()) {
            int i2 = iterator.nextInt();
            int $$12 = (sourceWidth - i2) / 2;
            int $$13 = y;
            IntIterator $$14 = RenderingUtils.slices_Vanilla(height, sourceHeight);
            while ($$14.hasNext()) {
                int $$15 = $$14.nextInt();
                int $$16 = (sourceHeight - $$15) / 2;
                INSTANCE.m_93228_(pose, i1, $$13, uOffset + $$12, vOffset + $$16, i2, $$15);
                $$13 += $$15;
            }
            i1 += i2;
        }
    }

    private static IntIterator slices_Vanilla(int target, int total) {
        int i = Mth.m_184652_((int)target, (int)total);
        return new Divisor(target, i);
    }

    public static void m_239260_(int xStart, int yStart, int xEnd, int yEnd) {
        RenderingUtils.applyScissor(new ScreenRectangle(xStart, yStart, xEnd - xStart, yEnd - yStart), true);
    }

    public static void m_240060_() {
        RenderingUtils.applyScissor(null, true);
    }

    private static void applyScissor(@Nullable ScreenRectangle rectangle, boolean pushStack) {
        if (rectangle != null) {
            if (pushStack) {
                if (!SCISSOR_STACK.isEmpty()) {
                    rectangle = Objects.requireNonNullElse(rectangle.intersection(SCISSOR_STACK.get(SCISSOR_STACK.size() - 1).rectangle()), ScreenRectangle.empty());
                }
                SCISSOR_STACK.add(new ScissorLayer(rectangle));
            }
            Window window = Minecraft.m_91087_().m_91268_();
            int windowHeight = window.m_85442_();
            double windowScale = window.m_85449_();
            double $$4 = (double)rectangle.left() * windowScale;
            double $$5 = (double)windowHeight - (double)rectangle.bottom() * windowScale;
            double $$6 = (double)rectangle.width() * windowScale;
            double $$7 = (double)rectangle.height() * windowScale;
            RenderSystem.m_69488_((int)((int)$$4), (int)((int)$$5), (int)Math.max(0, (int)$$6), (int)Math.max(0, (int)$$7));
        } else {
            if (!SCISSOR_STACK.isEmpty()) {
                SCISSOR_STACK.remove(SCISSOR_STACK.size() - 1);
            }
            if (!SCISSOR_STACK.isEmpty()) {
                RenderingUtils.applyScissor(SCISSOR_STACK.get(SCISSOR_STACK.size() - 1).rectangle(), false);
            } else {
                RenderSystem.m_69471_();
            }
        }
    }

    public static class Divisor
    implements IntIterator {
        private final int denominator;
        private final int quotient;
        private final int mod;
        private int returnedParts;
        private int remainder;

        public Divisor(int $$0, int $$1) {
            this.denominator = $$1;
            if ($$1 > 0) {
                this.quotient = $$0 / $$1;
                this.mod = $$0 % $$1;
            } else {
                this.quotient = 0;
                this.mod = 0;
            }
        }

        public boolean hasNext() {
            return this.returnedParts < this.denominator;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int $$0 = this.quotient;
            this.remainder += this.mod;
            if (this.remainder >= this.denominator) {
                this.remainder -= this.denominator;
                ++$$0;
            }
            ++this.returnedParts;
            return $$0;
        }
    }

    public record ScreenRectangle(ScreenPosition position, int width, int height) {
        private static final ScreenRectangle EMPTY = new ScreenRectangle(0, 0, 0, 0);

        public ScreenRectangle(int x, int y, int width, int height) {
            this(new ScreenPosition(x, y), width, height);
        }

        public static ScreenRectangle empty() {
            return EMPTY;
        }

        @Nullable
        public ScreenRectangle intersection(ScreenRectangle rectangle) {
            int $$1 = Math.max(this.left(), rectangle.left());
            int $$2 = Math.max(this.top(), rectangle.top());
            int $$3 = Math.min(this.right(), rectangle.right());
            int $$4 = Math.min(this.bottom(), rectangle.bottom());
            return $$1 < $$3 && $$2 < $$4 ? new ScreenRectangle($$1, $$2, $$3 - $$1, $$4 - $$2) : null;
        }

        public int top() {
            return this.position.y();
        }

        public int bottom() {
            return this.position.y() + this.height;
        }

        public int left() {
            return this.position.x();
        }

        public int right() {
            return this.position.x() + this.width;
        }
    }

    private record ScissorLayer(@NotNull ScreenRectangle rectangle) {
    }

    public record ScreenPosition(int x, int y) {
    }
}

