/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationScreen
extends Screen {
    protected List<Component> textLines;
    protected DrawableColor headlineColor;
    protected boolean headlineBold = false;
    protected Consumer<Boolean> callback;
    protected ExtendedButton okayButton;

    @NotNull
    public static NotificationScreen error(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return NotificationScreen.ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static NotificationScreen error(@NotNull Consumer<Boolean> callback, String ... textLines) {
        return NotificationScreen.ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static NotificationScreen warning(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return NotificationScreen.ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static NotificationScreen warning(@NotNull Consumer<Boolean> callback, String ... textLines) {
        return NotificationScreen.ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static NotificationScreen notificationWithHeadline(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return NotificationScreen.ofComponents(callback, textLines).setHeadlineBold(true);
    }

    @NotNull
    public static NotificationScreen notificationWithHeadline(@NotNull Consumer<Boolean> callback, String ... textLines) {
        return NotificationScreen.ofStrings(callback, textLines).setHeadlineBold(true);
    }

    @NotNull
    public static NotificationScreen ofStrings(@NotNull Consumer<Boolean> callback, String ... textLines) {
        NotificationScreen s = new NotificationScreen(callback, new ArrayList<Component>());
        for (String line : textLines) {
            s.textLines.add((Component)Components.literal(line));
        }
        return s;
    }

    @NotNull
    public static NotificationScreen ofStrings(@NotNull Consumer<Boolean> callback, @NotNull List<String> textLines) {
        return NotificationScreen.ofStrings(callback, textLines.toArray(new String[0]));
    }

    @NotNull
    public static NotificationScreen ofComponents(@NotNull Consumer<Boolean> callback, Component ... textLines) {
        return new NotificationScreen(callback, Arrays.asList(textLines));
    }

    @NotNull
    public static NotificationScreen ofComponents(@NotNull Consumer<Boolean> callback, @NotNull List<Component> textLines) {
        return new NotificationScreen(callback, textLines);
    }

    protected NotificationScreen(@NotNull Consumer<Boolean> callback, @NotNull List<Component> textLines) {
        super((Component)(!textLines.isEmpty() ? textLines.get(0) : Components.empty()));
        this.callback = callback;
        this.textLines = textLines;
    }

    protected void m_7856_() {
        this.okayButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.guicomponents.ok", new Object[0]), button -> this.callback.accept(true));
        this.m_7787_((GuiEventListener)this.okayButton);
        UIBase.applyDefaultWidgetSkinTo(this.okayButton);
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        NotificationScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        int y = this.f_96544_ / 2 - this.textLines.size() * 14 / 2;
        int lineCounter = 0;
        for (Component c : this.textLines) {
            MutableComponent line = c.m_6881_();
            if (lineCounter == 0) {
                if (this.headlineColor != null) {
                    line.m_6270_(line.m_7383_().m_178520_(this.headlineColor.getColorInt()));
                }
                if (this.headlineBold) {
                    line.m_6270_(line.m_7383_().m_131136_(Boolean.valueOf(true)));
                }
            }
            int textWidth = this.f_96547_.m_92852_((FormattedText)line);
            this.f_96547_.m_92889_(pose, (Component)line, (float)(this.f_96543_ / 2 - textWidth / 2), (float)y, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
            y += 14;
            ++lineCounter;
        }
        this.okayButton.f_93620_ = this.f_96543_ / 2 - this.okayButton.m_5711_() / 2;
        this.okayButton.f_93621_ = this.f_96544_ - 40;
        this.okayButton.m_6305_(pose, mouseX, mouseY, partial);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    @Nullable
    public DrawableColor getHeadlineColor() {
        return this.headlineColor;
    }

    public NotificationScreen setHeadlineColor(@Nullable DrawableColor headlineColor) {
        this.headlineColor = headlineColor;
        return this;
    }

    public boolean isHeadlineBold() {
        return this.headlineBold;
    }

    public NotificationScreen setHeadlineBold(boolean headlineBold) {
        this.headlineBold = headlineBold;
        return this;
    }

    public boolean m_7933_(int button, int p_96553_, int p_96554_) {
        if (button == 257) {
            this.callback.accept(true);
            return true;
        }
        return super.m_7933_(button, p_96553_, p_96554_);
    }

    public void m_7379_() {
        this.callback.accept(true);
    }
}

