/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.FileFilter;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.FilenameComparator;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.file.type.types.ImageFileType;
import de.keksuccino.fancymenu.util.file.type.types.TextFileType;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.component.ComponentWidget;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFileBrowserScreen
extends Screen {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final ResourceLocation GO_UP_ICON_TEXTURE = new ResourceLocation("fancymenu", "textures/go_up_icon.png");
    protected static final ResourceLocation FILE_ICON_TEXTURE = new ResourceLocation("fancymenu", "textures/file_icon.png");
    protected static final ResourceLocation FOLDER_ICON_TEXTURE = new ResourceLocation("fancymenu", "textures/folder_icon.png");
    protected static final Component FILE_TYPE_PREFIX_TEXT = Components.translatable("fancymenu.file_browser.file_type", new Object[0]);
    @Nullable
    protected static File lastDirectory;
    @Nullable
    protected File rootDirectory;
    @NotNull
    protected File currentDir;
    @Nullable
    protected FileFilter fileFilter;
    @Nullable
    protected FileTypeGroup<?> fileTypes;
    @NotNull
    protected Consumer<File> callback;
    protected int visibleDirectoryLevelsAboveRoot = 0;
    protected boolean showSubDirectories = true;
    protected boolean blockResourceUnfriendlyFileNames = true;
    protected boolean showBlockedResourceUnfriendlyFiles = true;
    protected ScrollArea fileListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea fileTypeScrollArea = new ScrollArea(0, 0, 0, 20);
    protected ScrollArea previewTextScrollArea = new ScrollArea(0, 0, 0, 0);
    @Nullable
    protected ResourceSupplier<ITexture> previewTextureSupplier;
    @Nullable
    protected ResourceSupplier<IText> previewTextSupplier;
    @Nullable
    protected IText currentPreviewText;
    protected ExtendedButton confirmButton;
    protected ExtendedButton cancelButton;
    protected ExtendedButton openInExplorerButton;
    protected ComponentWidget currentDirectoryComponent;
    protected int fileScrollListHeightOffset = 0;
    protected int fileTypeScrollListYOffset = 0;
    @Nullable
    protected MutableComponent currentFileTypesComponent;

    public AbstractFileBrowserScreen(@NotNull Component title, @Nullable File rootDirectory, @NotNull File startDirectory, @NotNull Consumer<File> callback) {
        super(title);
        this.rootDirectory = rootDirectory;
        if (!this.isInRootOrSubOfRoot(startDirectory)) {
            startDirectory = this.rootDirectory;
        }
        if (lastDirectory != null && this.isInRootOrSubOfRoot(lastDirectory)) {
            startDirectory = lastDirectory;
        }
        this.currentDir = startDirectory;
        lastDirectory = startDirectory;
        this.callback = callback;
        this.setTextPreview(null);
        this.updateFilesList();
    }

    protected void m_7856_() {
        this.confirmButton = this.buildConfirmButton();
        this.m_7787_((GuiEventListener)this.confirmButton);
        UIBase.applyDefaultWidgetSkinTo(this.confirmButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.guicomponents.cancel", new Object[0]), button -> this.callback.accept(null));
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.openInExplorerButton = new ExtendedButton(0, 0, 150, 20, (Component)Components.translatable("fancymenu.ui.filechooser.open_in_explorer", new Object[0]), button -> {
            File selected = this.getSelectedFile();
            if (selected != null && selected.isDirectory()) {
                FileUtils.openFile(selected);
            } else if (this.currentDir != null) {
                FileUtils.openFile(this.currentDir);
            }
            MainThreadTaskExecutor.executeInMainThread(() -> ((IMixinAbstractWidget)button).setFocusedFancyMenu(false), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        });
        this.m_7787_((GuiEventListener)this.openInExplorerButton);
        UIBase.applyDefaultWidgetSkinTo(this.openInExplorerButton);
        this.updateCurrentDirectoryComponent();
        this.updateFileTypeScrollArea();
    }

    @NotNull
    protected abstract ExtendedButton buildConfirmButton();

    public void m_7379_() {
        this.callback.accept(null);
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        if (this.currentFileTypesComponent != null) {
            this.fileTypeScrollArea.horizontalScrollBar.active = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.currentFileTypesComponent) > this.fileTypeScrollArea.getInnerWidth() - 10;
        }
        RenderSystem.m_69478_();
        AbstractFileBrowserScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        this.f_96547_.m_92889_(pose, (Component)titleComp, 20.0f, 20.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.f_96547_.m_92889_(pose, (Component)Components.translatable("fancymenu.ui.filechooser.files", new Object[0]), 20.0f, 50.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        Objects.requireNonNull(this.f_96547_);
        int currentDirFieldYEnd = this.renderCurrentDirectoryField(pose, mouseX, mouseY, partial, 20, 65, this.f_96543_ - 260 - 20, 9 + 6);
        this.renderFileScrollArea(pose, mouseX, mouseY, partial, currentDirFieldYEnd);
        this.renderFileTypeScrollArea(pose, mouseX, mouseY, partial);
        MutableComponent previewLabel = Components.translatable("fancymenu.ui.filechooser.preview", new Object[0]);
        int previewLabelWidth = this.f_96547_.m_92852_((FormattedText)previewLabel);
        this.f_96547_.m_92889_(pose, (Component)previewLabel, (float)(this.f_96543_ - 20 - previewLabelWidth), 50.0f, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.renderConfirmButton(pose, mouseX, mouseY, partial);
        this.renderCancelButton(pose, mouseX, mouseY, partial);
        this.renderOpenInExplorerButton(pose, mouseX, mouseY, partial);
        this.renderPreview(pose, mouseX, mouseY, partial);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    protected void renderOpenInExplorerButton(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.openInExplorerButton.f_93620_ = this.f_96543_ - 20 - this.openInExplorerButton.m_5711_();
        this.openInExplorerButton.f_93621_ = this.cancelButton.f_93621_ - 15 - 20;
        this.openInExplorerButton.m_6305_(pose, mouseX, mouseY, partial);
    }

    protected void renderConfirmButton(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.confirmButton.f_93620_ = this.f_96543_ - 20 - this.confirmButton.m_5711_();
        this.confirmButton.f_93621_ = this.f_96544_ - 20 - 20;
        this.confirmButton.m_6305_(pose, mouseX, mouseY, partial);
    }

    protected void renderCancelButton(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.cancelButton.f_93620_ = this.f_96543_ - 20 - this.cancelButton.m_5711_();
        this.cancelButton.f_93621_ = this.confirmButton.f_93621_ - 5 - 20;
        this.cancelButton.m_6305_(pose, mouseX, mouseY, partial);
    }

    protected void renderFileTypeScrollArea(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.fileTypeScrollArea.verticalScrollBar.active = false;
        this.fileTypeScrollArea.setWidth(this.getBelowFileScrollAreaElementWidth());
        this.fileTypeScrollArea.setX(this.fileListScrollArea.getXWithBorder() + this.fileListScrollArea.getWidthWithBorder() - this.fileTypeScrollArea.getWidthWithBorder());
        this.fileTypeScrollArea.setY(this.fileListScrollArea.getYWithBorder() + this.fileListScrollArea.getHeightWithBorder() + 5 + this.fileTypeScrollListYOffset);
        this.fileTypeScrollArea.render(pose, mouseX, mouseY, partial);
        float f = this.fileTypeScrollArea.getXWithBorder() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)FILE_TYPE_PREFIX_TEXT) - 5;
        int n = this.fileTypeScrollArea.getYWithBorder() + this.fileTypeScrollArea.getHeightWithBorder() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.f_96547_.m_92889_(pose, FILE_TYPE_PREFIX_TEXT, f, (float)(n - 9 / 2), UIBase.getUIColorTheme().element_label_color_normal.getColorInt());
    }

    protected void renderFileScrollArea(PoseStack pose, int mouseX, int mouseY, float partial, int currentDirFieldYEnd) {
        this.fileListScrollArea.setWidth(this.f_96543_ - 260 - 20, true);
        Objects.requireNonNull(this.f_96547_);
        this.fileListScrollArea.setHeight(this.f_96544_ - 85 - (9 + 6) - 2 - 25 + this.fileScrollListHeightOffset, true);
        this.fileListScrollArea.setX(20, true);
        this.fileListScrollArea.setY(currentDirFieldYEnd + 2, true);
        this.fileListScrollArea.render(pose, mouseX, mouseY, partial);
    }

    protected void renderPreview(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.tickTextPreview();
        if (this.previewTextureSupplier != null) {
            ResourceLocation loc;
            ITexture t = this.previewTextureSupplier.get();
            ResourceLocation resourceLocation = loc = t != null ? t.getResourceLocation() : null;
            if (loc != null) {
                AspectRatio ratio = t.getAspectRatio();
                int[] size = ratio.getAspectRatioSizeByMaximumSize(200, this.cancelButton.f_93621_ - 50 - 65);
                int w = size[0];
                int h = size[1];
                int x = this.f_96543_ - 20 - w;
                int y = 65;
                UIBase.resetShaderColor();
                AbstractFileBrowserScreen.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)UIBase.getUIColorTheme().area_background_color.getColorInt());
                RenderingUtils.resetShaderColor();
                RenderSystem.m_69478_();
                RenderUtils.bindTexture((ResourceLocation)loc);
                AbstractFileBrowserScreen.m_93133_((PoseStack)pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
                UIBase.resetShaderColor();
                UIBase.renderBorder(pose, x, y, x + w, y + h, 1, UIBase.getUIColorTheme().element_border_color_normal.getColor(), true, true, true, true);
            }
        } else {
            this.previewTextScrollArea.setWidth(200, true);
            this.previewTextScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
            this.previewTextScrollArea.setX(this.f_96543_ - 20 - this.previewTextScrollArea.getWidthWithBorder(), true);
            this.previewTextScrollArea.setY(65, true);
            this.previewTextScrollArea.render(pose, mouseX, mouseY, partial);
        }
        UIBase.resetShaderColor();
    }

    protected int renderCurrentDirectoryField(PoseStack pose, int mouseX, int mouseY, float partial, int x, int y, int width, int height) {
        int xEnd = x + width;
        int yEnd = y + height;
        AbstractFileBrowserScreen.m_93172_((PoseStack)pose, (int)(x + 1), (int)(y + 1), (int)(xEnd - 1), (int)(yEnd - 1), (int)UIBase.getUIColorTheme().area_background_color.getColorInt());
        UIBase.renderBorder(pose, x, y, xEnd, yEnd, 1, UIBase.getUIColorTheme().element_border_color_normal.getColor(), true, true, true, true);
        this.currentDirectoryComponent.f_93620_ = x + 4;
        this.currentDirectoryComponent.f_93621_ = y + height / 2 - this.currentDirectoryComponent.m_93694_() / 2;
        this.currentDirectoryComponent.m_6305_(pose, mouseX, mouseY, partial);
        return yEnd;
    }

    protected int getBelowFileScrollAreaElementWidth() {
        return this.fileListScrollArea.getWidthWithBorder() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)FILE_TYPE_PREFIX_TEXT) - 5;
    }

    protected void updateCurrentDirectoryComponent() {
        try {
            ComponentWidget firstChild;
            if (this.currentDirectoryComponent != null) {
                this.m_169411_((GuiEventListener)this.currentDirectoryComponent);
            }
            this.currentDirectoryComponent = ComponentWidget.literal("/", 0, 0);
            if (this.visibleDirectoryLevelsAboveRoot > 0) {
                ArrayList aboveRootFiles = new ArrayList();
                File f = this.rootDirectory.getAbsoluteFile().getParentFile();
                if (f != null) {
                    int i = this.visibleDirectoryLevelsAboveRoot;
                    do {
                        f = f.getAbsoluteFile();
                        aboveRootFiles.add(f);
                    } while ((f = f.getParentFile()) != null && --i > 0);
                    Collections.reverse(aboveRootFiles);
                    Iterator iterator = aboveRootFiles.iterator();
                    while (iterator.hasNext()) {
                        File f2;
                        File fFinal = f2 = (File)iterator.next();
                        this.currentDirectoryComponent.append(ComponentWidget.empty(0, 0).setTextSupplier(consumes -> {
                            if (consumes.m_198029_()) {
                                return Components.literal(fFinal.getName()).m_6270_(Style.f_131099_.m_178522_(Boolean.valueOf(true)).m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()));
                            }
                            return Components.literal(fFinal.getName());
                        }));
                        this.currentDirectoryComponent.append(ComponentWidget.literal("/", 0, 0));
                    }
                }
            }
            for (File f : this.splitCurrentIntoSeparateDirectories()) {
                ComponentWidget w = ComponentWidget.empty(0, 0).setTextSupplier(consumes -> {
                    if (consumes.m_198029_()) {
                        return Components.literal(f.getName()).m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)));
                    }
                    return Components.literal(f.getName());
                }).setOnClick(componentWidget -> this.setDirectory(f, true));
                this.currentDirectoryComponent.append(w);
                this.currentDirectoryComponent.append(ComponentWidget.literal("/", 0, 0));
            }
            while (this.currentDirectoryComponent.m_5711_() > this.f_96543_ - 260 - 20 - 8 && !this.currentDirectoryComponent.getChildren().isEmpty()) {
                this.currentDirectoryComponent.getChildren().remove(0);
            }
            if (!this.currentDirectoryComponent.getChildren().isEmpty() && (firstChild = this.currentDirectoryComponent.getChildren().get(0)).getText().getString().equals("/")) {
                this.currentDirectoryComponent.getChildren().remove(0);
            }
            this.currentDirectoryComponent.setShadow(false);
            this.currentDirectoryComponent.setBaseColorSupplier(consumes -> UIBase.getUIColorTheme().description_area_text_color);
            this.m_7787_((GuiEventListener)this.currentDirectoryComponent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    protected List<File> splitCurrentIntoSeparateDirectories() {
        ArrayList<File> dirs;
        block3: {
            dirs = new ArrayList<File>();
            dirs.add(this.currentDir);
            try {
                if (this.currentIsRootDirectory()) break block3;
                File f = this.currentDir;
                while ((f = f.getParentFile()) != null) {
                    dirs.add(f);
                    if (!this.isRootDirectory(f)) continue;
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Collections.reverse(dirs);
        return dirs;
    }

    @Nullable
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public AbstractFileBrowserScreen setFileFilter(@Nullable FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.updateFilesList();
        return this;
    }

    public boolean shouldShowFile(@NotNull File file) {
        if (this.fileFilter != null && !this.fileFilter.checkFile(file)) {
            return false;
        }
        if (this.fileTypes != null) {
            for (FileType type : this.fileTypes.getFileTypes()) {
                if (!type.isFileTypeLocal(file)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public AbstractFileBrowserScreen setDirectory(@NotNull File newDirectory, boolean playSound) {
        Objects.requireNonNull(newDirectory);
        if (!this.isInRootOrSubOfRoot(newDirectory)) {
            return this;
        }
        if (playSound) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        this.updatePreview(null);
        this.currentDir = newDirectory;
        lastDirectory = newDirectory;
        this.updateFilesList();
        MainThreadTaskExecutor.executeInMainThread(this::updateCurrentDirectoryComponent, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
        return this;
    }

    public int getVisibleDirectoryLevelsAboveRoot() {
        return this.visibleDirectoryLevelsAboveRoot;
    }

    public AbstractFileBrowserScreen setVisibleDirectoryLevelsAboveRoot(int visibleDirectoryLevelsAboveRoot) {
        this.visibleDirectoryLevelsAboveRoot = visibleDirectoryLevelsAboveRoot;
        return this;
    }

    public boolean showSubDirectories() {
        return this.showSubDirectories;
    }

    public AbstractFileBrowserScreen setShowSubDirectories(boolean showSubDirectories) {
        this.showSubDirectories = showSubDirectories;
        this.updateFilesList();
        return this;
    }

    public boolean blockResourceUnfriendlyFileNames() {
        return this.blockResourceUnfriendlyFileNames;
    }

    public AbstractFileBrowserScreen setBlockResourceUnfriendlyFileNames(boolean blockResourceUnfriendlyFileNames) {
        this.blockResourceUnfriendlyFileNames = blockResourceUnfriendlyFileNames;
        this.updateFilesList();
        return this;
    }

    public boolean showBlockedResourceUnfriendlyFileNames() {
        return this.showBlockedResourceUnfriendlyFiles;
    }

    public AbstractFileBrowserScreen setShowBlockedResourceUnfriendlyFiles(boolean showBlockedResourceUnfriendlyFiles) {
        this.showBlockedResourceUnfriendlyFiles = showBlockedResourceUnfriendlyFiles;
        return this;
    }

    @Nullable
    protected AbstractFileScrollAreaEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.fileListScrollArea.getEntries()) {
            AbstractFileScrollAreaEntry f;
            if (!(e instanceof AbstractFileScrollAreaEntry) || !(f = (AbstractFileScrollAreaEntry)e).isSelected()) continue;
            return f;
        }
        return null;
    }

    @Nullable
    protected File getSelectedFile() {
        AbstractFileScrollAreaEntry selected = this.getSelectedEntry();
        if (selected != null && !selected.resourceUnfriendlyFileName) {
            return new File(selected.file.getPath().replace("\\", "/"));
        }
        return null;
    }

    public void setFileTypes(@Nullable FileTypeGroup<?> typeGroup) {
        this.fileTypes = typeGroup;
        this.updateFilesList();
        this.updateFileTypeScrollArea();
    }

    @Nullable
    public FileTypeGroup<?> getFileTypes() {
        return this.fileTypes;
    }

    public void updateFileTypeScrollArea() {
        this.fileTypeScrollArea.clearEntries();
        this.currentFileTypesComponent = Components.translatable("fancymenu.file_browser.file_type.types.all", new Object[0]).m_130946_(" (*)");
        if (this.fileTypes != null) {
            Object types = "";
            for (FileType type : this.fileTypes.getFileTypes()) {
                for (String s : type.getExtensions()) {
                    if (!((String)types).isEmpty()) {
                        types = (String)types + ";";
                    }
                    types = (String)types + "*." + s.toUpperCase();
                }
            }
            Component fileTypeDisplayName = this.fileTypes.getDisplayName();
            if (fileTypeDisplayName == null) {
                fileTypeDisplayName = Components.empty();
            }
            this.currentFileTypesComponent = Components.empty().m_7220_(fileTypeDisplayName).m_7220_((Component)Components.literal(" (")).m_7220_((Component)Components.literal((String)types)).m_7220_((Component)Components.literal(")"));
        }
        this.currentFileTypesComponent = this.currentFileTypesComponent.m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
        TextScrollAreaEntry entry = new TextScrollAreaEntry(this.fileTypeScrollArea, (Component)this.currentFileTypesComponent, textScrollAreaEntry -> {});
        entry.setPlayClickSound(false);
        entry.setSelectable(false);
        entry.setBackgroundColorHover(entry.getBackgroundColorIdle());
        entry.setHeight(this.fileTypeScrollArea.getInnerHeight());
        this.fileTypeScrollArea.addEntry(entry);
    }

    public void updatePreview(@Nullable File file) {
        if (file != null && file.isFile()) {
            this.setTextPreview(file);
            this.previewTextureSupplier = FileTypes.getLocalType(file) instanceof ImageFileType ? ResourceSupplier.image(file.getPath()) : null;
        } else {
            this.setTextPreview(null);
            this.previewTextureSupplier = null;
        }
    }

    protected void setTextPreview(@Nullable File file) {
        if (file == null) {
            this.previewTextSupplier = null;
        } else {
            for (TextFileType type : FileTypes.getAllTextFileTypes()) {
                if (!type.isFileTypeLocal(file)) continue;
                this.previewTextSupplier = ResourceSupplier.text(GameDirectoryUtils.getAbsoluteGameDirectoryPath(file.getPath()));
                return;
            }
            this.previewTextSupplier = null;
        }
    }

    protected void tickTextPreview() {
        if (this.previewTextScrollArea == null) {
            return;
        }
        if (this.previewTextSupplier != null) {
            IText text = this.previewTextSupplier.get();
            if (!Objects.equals(this.currentPreviewText, text)) {
                if (text == null) {
                    this.setNoTextPreview();
                } else {
                    this.previewTextScrollArea.clearEntries();
                    List<String> lines = text.getTextLines();
                    if (lines != null) {
                        int line = 0;
                        for (String s : lines) {
                            ScrollAreaEntry e;
                            if (++line < 70) {
                                e = new TextScrollAreaEntry(this.previewTextScrollArea, (Component)Components.literal(s).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                                e.setSelectable(false);
                                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                                e.setPlayClickSound(false);
                                this.previewTextScrollArea.addEntry(e);
                                continue;
                            }
                            e = new TextScrollAreaEntry(this.previewTextScrollArea, (Component)Components.literal("......").m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                            e.setSelectable(false);
                            e.setBackgroundColorHover(e.getBackgroundColorIdle());
                            e.setPlayClickSound(false);
                            this.previewTextScrollArea.addEntry(e);
                            TextScrollAreaEntry e2 = new TextScrollAreaEntry(this.previewTextScrollArea, (Component)Components.literal("  ").m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                            e2.setSelectable(false);
                            e2.setBackgroundColorHover(e2.getBackgroundColorIdle());
                            e2.setPlayClickSound(false);
                            this.previewTextScrollArea.addEntry(e2);
                            break;
                        }
                        int totalWidth = this.previewTextScrollArea.getTotalEntryWidth();
                        for (ScrollAreaEntry e : this.previewTextScrollArea.getEntries()) {
                            e.setWidth(totalWidth);
                        }
                    } else {
                        return;
                    }
                }
                this.currentPreviewText = text;
            }
        } else {
            if (this.currentPreviewText != null) {
                this.setNoTextPreview();
            }
            this.currentPreviewText = null;
        }
    }

    protected void setNoTextPreview() {
        if (this.previewTextScrollArea == null) {
            return;
        }
        this.previewTextScrollArea.clearEntries();
        TextScrollAreaEntry e = new TextScrollAreaEntry(this.previewTextScrollArea, (Component)Components.translatable("fancymenu.ui.filechooser.no_preview", new Object[0]).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
        e.setSelectable(false);
        e.setBackgroundColorHover(e.getBackgroundColorIdle());
        e.setPlayClickSound(false);
        this.previewTextScrollArea.addEntry(e);
    }

    protected void updateFilesList() {
        File[] filesList;
        this.fileListScrollArea.clearEntries();
        if (!this.currentIsRootDirectory()) {
            ParentDirScrollAreaEntry e = new ParentDirScrollAreaEntry(this.fileListScrollArea);
            this.fileListScrollArea.addEntry(e);
        }
        if ((filesList = this.currentDir.listFiles()) != null) {
            AbstractFileScrollAreaEntry e;
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<File> folders = new ArrayList<File>();
            for (File f : filesList) {
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                folders.add(f);
            }
            FilenameComparator comp = new FilenameComparator();
            Collections.sort(folders, (o1, o2) -> comp.compare(o1.getName(), o2.getName()));
            Collections.sort(files, (o1, o2) -> comp.compare(o1.getName(), o2.getName()));
            if (this.showSubDirectories) {
                for (File f : folders) {
                    e = this.buildFileEntry(f);
                    if (this.blockResourceUnfriendlyFileNames) {
                        boolean bl = e.resourceUnfriendlyFileName = !FileFilter.RESOURCE_NAME_FILTER.checkFile(f);
                    }
                    if (e.resourceUnfriendlyFileName) {
                        e.setSelectable(false);
                    }
                    this.fileListScrollArea.addEntry(e);
                }
            }
            for (File f : files) {
                if (!this.shouldShowFile(f)) continue;
                e = this.buildFileEntry(f);
                if (this.blockResourceUnfriendlyFileNames) {
                    boolean bl = e.resourceUnfriendlyFileName = !FileFilter.RESOURCE_NAME_FILTER.checkFile(f);
                }
                if (e.resourceUnfriendlyFileName) {
                    e.setSelectable(false);
                }
                if (e.resourceUnfriendlyFileName && !this.showBlockedResourceUnfriendlyFiles) continue;
                this.fileListScrollArea.addEntry(e);
            }
        }
    }

    protected abstract AbstractFileScrollAreaEntry buildFileEntry(@NotNull File var1);

    protected boolean currentIsRootDirectory() {
        return this.isRootDirectory(this.currentDir);
    }

    protected boolean isRootDirectory(File dir) {
        if (this.rootDirectory == null) {
            return false;
        }
        return this.rootDirectory.getAbsolutePath().equals(dir.getAbsolutePath());
    }

    @Nullable
    protected File getParentDirectoryOfCurrent() {
        return this.currentDir.getParentFile();
    }

    protected boolean isInRootOrSubOfRoot(File file) {
        if (this.rootDirectory == null) {
            return true;
        }
        return file.getAbsolutePath().startsWith(this.rootDirectory.getAbsolutePath());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!(button != 0 || this.fileListScrollArea.isMouseInsideArea() || this.fileListScrollArea.isMouseInteractingWithGrabbers() || this.previewTextScrollArea.isMouseInsideArea() || this.previewTextScrollArea.isMouseInteractingWithGrabbers() || this.isWidgetHovered())) {
            for (ScrollAreaEntry e : this.fileListScrollArea.getEntries()) {
                e.setSelected(false);
            }
            this.updatePreview(null);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean isWidgetHovered() {
        for (GuiEventListener l : this.m_6702_()) {
            AbstractWidget w;
            if (!(l instanceof AbstractWidget) || !((IMixinAbstractWidget)(w = (AbstractWidget)l)).getIsHoveredFancyMenu()) continue;
            return true;
        }
        return false;
    }

    public abstract class AbstractFileScrollAreaEntry
    extends ScrollAreaEntry {
        private static final int BORDER = 3;
        public File file;
        public Font font;
        protected boolean resourceUnfriendlyFileName;
        protected final MutableComponent fileNameComponent;
        protected long lastClick;

        public AbstractFileScrollAreaEntry(@NotNull ScrollArea parent, File file) {
            super(parent, 100, 30);
            this.font = Minecraft.m_91087_().f_91062_;
            this.resourceUnfriendlyFileName = false;
            this.lastClick = -1L;
            this.file = file;
            this.fileNameComponent = Components.literal(this.file.getName());
            this.setWidth(this.font.m_92852_((FormattedText)this.fileNameComponent) + 6 + 20 + 3);
            this.setHeight(26);
            this.playClickSound = false;
        }

        @Override
        public void render(PoseStack pose, int mouseX, int mouseY, float partial) {
            super.render(pose, mouseX, mouseY, partial);
            if (this.file.exists()) {
                RenderSystem.m_69478_();
                UIBase.getUIColorTheme().setUITextureShaderColor(1.0f);
                RenderUtils.bindTexture((ResourceLocation)(this.file.isFile() ? FILE_ICON_TEXTURE : FOLDER_ICON_TEXTURE));
                AbstractFileScrollAreaEntry.m_93133_((PoseStack)pose, (int)(this.x + 3), (int)(this.y + 3), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
                UIBase.resetShaderColor();
                int textColor = this.resourceUnfriendlyFileName ? UIBase.getUIColorTheme().error_text_color.getColorInt() : UIBase.getUIColorTheme().description_area_text_color.getColorInt();
                float f = this.x + 3 + 20 + 3;
                float f2 = (float)this.y + (float)this.height / 2.0f;
                Objects.requireNonNull(this.font);
                this.font.m_92889_(pose, (Component)this.fileNameComponent, f, f2 - 9.0f / 2.0f, textColor);
                if (this.isHovered() && this.parent.isMouseInsideArea() && this.resourceUnfriendlyFileName) {
                    TooltipHandler.INSTANCE.addTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.ui.filechooser.resource_name_check.not_passed.tooltip", new String[0])).setDefaultStyle(), () -> true, false, true);
                }
            }
        }

        @Override
        public abstract void onClick(ScrollAreaEntry var1);
    }

    public class ParentDirScrollAreaEntry
    extends ScrollAreaEntry {
        private static final int BORDER = 3;
        public Font font;
        protected final MutableComponent labelComponent;
        protected long lastClick;

        public ParentDirScrollAreaEntry(ScrollArea parent) {
            super(parent, 100, 30);
            this.font = Minecraft.m_91087_().f_91062_;
            this.lastClick = -1L;
            this.labelComponent = Components.translatable("fancymenu.ui.filechooser.go_up", new Object[0]).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()).m_131136_(Boolean.valueOf(true)));
            this.setWidth(this.font.m_92852_((FormattedText)this.labelComponent) + 6 + 20 + 3);
            this.setHeight(26);
            this.playClickSound = false;
        }

        @Override
        public void render(PoseStack pose, int mouseX, int mouseY, float partial) {
            super.render(pose, mouseX, mouseY, partial);
            RenderSystem.m_69478_();
            UIBase.getUIColorTheme().setUITextureShaderColor(1.0f);
            RenderUtils.bindTexture((ResourceLocation)GO_UP_ICON_TEXTURE);
            ParentDirScrollAreaEntry.m_93133_((PoseStack)pose, (int)(this.x + 3), (int)(this.y + 3), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
            UIBase.resetShaderColor();
            float f = this.x + 3 + 20 + 3;
            float f2 = (float)this.y + (float)this.height / 2.0f;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pose, (Component)this.labelComponent, f, f2 - 9.0f / 2.0f, -1);
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
            File parent;
            long now = System.currentTimeMillis();
            if (now - this.lastClick < 400L && !AbstractFileBrowserScreen.this.currentIsRootDirectory() && (parent = AbstractFileBrowserScreen.this.getParentDirectoryOfCurrent()) != null && parent.isDirectory()) {
                AbstractFileBrowserScreen.this.setDirectory(parent, true);
            }
            AbstractFileBrowserScreen.this.updatePreview(null);
            this.lastClick = now;
        }
    }
}

