/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftbchunks.net.RequestMapDataPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.UpdateForceLoadExpiryPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;

public class ChunkScreen
extends BaseScreen {
    private static final ImageIcon FORCE_LOAD_ICON = new ImageIcon(new ResourceLocation("ftbchunks", "textures/force_loaded.png"));
    public MapDimension dimension = MapDimension.getCurrent();
    public List<ChunkButton> chunkButtons;
    public Set<XZ> selectedChunks;
    private ChunkUpdateInfo updateInfo;

    public ChunkScreen() {
        FTBChunksClient.alwaysRenderChunksOnMap = true;
        if (this.dimension == null) {
            FTBChunks.LOGGER.warn("Closed chunk screen map screen to prevent map dimension manager crash");
            this.closeGui();
        }
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    public static void notifyChunkUpdates(int totalChunks, int changedChunks, Map<String, Integer> problems) {
        ScreenWrapper sw;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ScreenWrapper && (screen = (sw = (ScreenWrapper)screen).getGui()) instanceof ChunkScreen) {
            ChunkScreen cs = (ChunkScreen)screen;
            cs.updateInfo = new ChunkUpdateInfo(totalChunks, changedChunks, problems, Minecraft.m_91087_().f_91073_.m_46467_());
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        FTBChunksClient.alwaysRenderChunksOnMap = false;
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
        super.onClosed();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ChunkPos chunkPos = player.m_146902_();
        int startX = chunkPos.f_45578_ - 7;
        int startZ = chunkPos.f_45579_ - 7;
        this.chunkButtons = new ArrayList<ChunkButton>();
        this.selectedChunks = new LinkedHashSet<XZ>();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, XZ.of((int)(startX + x), (int)(startZ + z)));
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        new RequestMapDataPacket(chunkPos.f_45578_ - 7, chunkPos.f_45579_ - 7, chunkPos.f_45578_ + 7, chunkPos.f_45579_ + 7).sendToServer();
        this.add(new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbchunks.gui.large_map"), Icons.MAP, (simpleButton, mouseButton) -> new LargeMapScreen().openGui()).setPosAndSize(1, 1, 16, 16));
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            new RequestChunkChangePacket(ChunkScreen.isShiftKeyDown() ? (button.isLeft() ? 2 : 3) : (button.isLeft() ? 0 : 1), this.selectedChunks).sendToServer();
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public boolean keyPressed(Key key) {
        if (FTBChunksWorldConfig.playerHasMapStage((Player)Minecraft.m_91087_().f_91074_) && (key.is(77) || key.is(67))) {
            new LargeMapScreen().openGui();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        RenderSystem.m_69832_((float)Math.max(2.5f, (float)Minecraft.m_91087_().m_91268_().m_85441_() / 1920.0f * 2.5f));
        RenderSystem.m_69493_();
        RenderSystem.m_157184_((int)FTBChunksClient.minimapTextureId);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9728);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9728);
        RenderSystem.m_157453_((int)0, (int)FTBChunksClient.minimapTextureId);
        GuiHelper.drawTexturedRect((PoseStack)matrixStack, (int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258)) {
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69472_();
            buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            Matrix4f m = matrixStack.m_85850_().m_85861_();
            for (int gy = 1; gy < 15; ++gy) {
                buffer.m_85982_(m, (float)sx, (float)(sy + gy * 16), 0.0f).m_6122_(r, g, b, a).m_5752_();
                buffer.m_85982_(m, (float)(sx + 240), (float)(sy + gy * 16), 0.0f).m_6122_(r, g, b, a).m_5752_();
            }
            for (int gx = 1; gx < 15; ++gx) {
                buffer.m_85982_(m, (float)(sx + gx * 16), (float)sy, 0.0f).m_6122_(r, g, b, a).m_5752_();
                buffer.m_85982_(m, (float)(sx + gx * 16), (float)(sy + 240), 0.0f).m_6122_(r, g, b, a).m_5752_();
            }
            tessellator.m_85914_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69832_((float)1.0f);
        double hx = (double)(sx + 112) + MathUtils.mod((double)player.m_20185_(), (double)16.0);
        double hy = (double)(sy + 112) + MathUtils.mod((double)player.m_20189_(), (double)16.0);
        FaceIcon.getFace((GameProfile)player.m_36316_()).draw(matrixStack, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8);
        SendGeneralDataPacket d = FTBChunksClient.generalData;
        if (d != null) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(4);
            list.add(Component.m_237115_((String)"ftbchunks.gui.claimed"));
            list.add(Component.m_237113_((String)(d.claimed + " / " + d.maxClaimChunks)).m_130940_(d.claimed > d.maxClaimChunks ? ChatFormatting.RED : (d.claimed == d.maxClaimChunks ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
            list.add(Component.m_237115_((String)"ftbchunks.gui.force_loaded"));
            list.add(Component.m_237113_((String)(d.loaded + " / " + d.maxForceLoadChunks)).m_130940_(d.loaded > d.maxForceLoadChunks ? ChatFormatting.RED : (d.loaded == d.maxForceLoadChunks ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
            int fh = theme.getFontHeight() + 1;
            for (int i = 0; i < list.size(); ++i) {
                theme.drawString(matrixStack, list.get(i), 3.0f, (float)(this.getScreen().m_85446_() - fh * (list.size() - i) - 1), Color4I.WHITE, 2);
            }
        }
        if (this.updateInfo != null && this.updateInfo.shouldDisplay()) {
            theme.drawString(matrixStack, (Object)this.updateInfo.summary(), sx + 2, sy + 2, 2);
            MutableInt line = new MutableInt(1);
            this.updateInfo.problems.forEach((msgKey, count) -> theme.drawString(matrixStack, (Object)Component.m_237115_((String)msgKey).m_130946_(": " + count), sx + 2, sy + 5 + theme.getFontHeight() * line.getAndIncrement(), 2));
        }
    }

    private record ChunkUpdateInfo(int totalChunks, int changedChunks, Map<String, Integer> problems, long timestamp) {
        public boolean shouldDisplay() {
            long timeout = 60L + 20L * (long)this.problems.size();
            return Minecraft.m_91087_().f_91073_.m_46467_() - this.timestamp < timeout;
        }

        public Component summary() {
            ChatFormatting color = this.changedChunks == 0 ? ChatFormatting.RED : (this.changedChunks < this.totalChunks ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
            return Component.m_237110_((String)"ftbchunks.claim_result", (Object[])new Object[]{this.changedChunks, this.totalChunks}).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, color});
        }
    }

    private class ChunkButton
    extends Button {
        private final XZ chunkPos;
        private final MapChunk chunk;
        private long lastAdjust;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, (Component)Component.m_237119_(), (Icon)Color4I.EMPTY);
            this.lastAdjust = 0L;
            this.setSize(16, 16);
            this.chunkPos = xz;
            this.chunk = ChunkScreen.this.dimension.getRegion(XZ.regionFromChunk((int)this.chunkPos.x, (int)this.chunkPos.z)).getDataBlocking().getChunk(this.chunkPos);
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.chunk.forceLoadedDate != null && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258)) {
                Color4I teamColor = (Color4I)this.chunk.team.properties.get((TeamProperty)Team.COLOR);
                float[] hsb = Color4I.RGBtoHSB((int)teamColor.redi(), (int)teamColor.greeni(), (int)teamColor.bluei(), null);
                hsb[0] = (hsb[0] + 0.5f) % 1.0f;
                FORCE_LOAD_ICON.withColor(Color4I.hsb((float)hsb[0], (float)hsb[1], (float)hsb[2])).draw(matrixStack, x, y, 16, 16);
            }
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(matrixStack, x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.chunk != null && this.chunk.getTeam() != null) {
                list.add((Component)this.chunk.getTeam().getName().m_6881_().m_130940_(ChatFormatting.WHITE));
                Date date = new Date();
                if (Screen.m_96639_()) {
                    list.add((Component)Component.m_237113_((String)this.chunk.claimedDate.toLocaleString()).m_130940_(ChatFormatting.GRAY));
                } else {
                    list.add((Component)Component.m_237113_((String)(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.claimedDate.getTime()) / 1000L)) + " ago")).m_130940_(ChatFormatting.GRAY));
                }
                if (this.chunk.forceLoadedDate != null) {
                    list.add((Component)Component.m_237115_((String)"ftbchunks.gui.force_loaded").m_130940_(ChatFormatting.YELLOW));
                    String loadStr = Screen.m_96639_() ? "  " + this.chunk.forceLoadedDate.toLocaleString() : "  " + TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.forceLoadedDate.getTime()) / 1000L)) + " ago";
                    list.add((Component)Component.m_237113_((String)loadStr).m_130940_(ChatFormatting.GRAY));
                    if (this.chunk.expiryDate != null) {
                        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.force_load_expires").m_130940_(ChatFormatting.GOLD));
                        String expireStr = Screen.m_96639_() ? "  " + this.chunk.expiryDate.toLocaleString() : "  " + TimeUtils.prettyTimeString((long)((this.chunk.expiryDate.getTime() - date.getTime()) / 1000L)) + " from now";
                        list.add((Component)Component.m_237113_((String)expireStr).m_130940_(ChatFormatting.GRAY));
                    }
                    if (!Screen.m_96639_()) {
                        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.hold_alt_for_dates").m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    if (this.chunk.team.isMember(Minecraft.m_91087_().f_91074_.m_20148_())) {
                        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.mouse_wheel_expiry").m_130940_(ChatFormatting.DARK_GRAY));
                    }
                }
            }
        }

        public boolean mouseScrolled(double scroll) {
            if (this.isMouseOver && this.chunk.forceLoadedDate != null && this.chunk.team.isMember(Minecraft.m_91087_().f_91074_.m_20148_())) {
                int dir = (int)Math.signum(scroll);
                long now = System.currentTimeMillis();
                if (this.chunk.expiryDate == null) {
                    this.chunk.expiryDate = new Date(now);
                }
                long offset = (this.chunk.expiryDate.getTime() - now) / 1000L;
                if (dir == 1) {
                    offset = offset < 86400L ? (offset += 3600L) : (offset < 604800L ? (offset += 86400L) : (offset += 604800L));
                } else if (dir == -1) {
                    offset = offset <= 86400L ? Math.max(0L, offset - 3600L) : (offset <= 604800L ? Math.max(86400L, offset - 86400L) : Math.max(604800L, offset - 604800L));
                }
                this.chunk.expiryDate = offset == 0L ? null : new Date(now + offset * 1000L);
                this.lastAdjust = now;
                return true;
            }
            return super.mouseScrolled(scroll);
        }

        public void tick() {
            super.tick();
            if (this.lastAdjust > 0L && System.currentTimeMillis() - this.lastAdjust > 1000L) {
                new UpdateForceLoadExpiryPacket(this.chunkPos.dim((Level)Minecraft.m_91087_().f_91073_), this.chunk.expiryDate).sendToServer();
                this.lastAdjust = 0L;
            }
        }
    }
}

