/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.item;

import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.RewardNotificationsScreen;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LootCrateItem
extends Item {
    public LootCrateItem() {
        super(new Item.Properties().m_41491_(FTBQuests.ITEM_GROUP));
    }

    @Nullable
    public static LootCrate getCrate(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41720_() instanceof LootCrateItem) {
            return LootCrate.LOOT_CRATES.get(stack.m_41783_().m_128461_("type"));
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        int size;
        ItemStack stack = player.m_21120_(hand);
        LootCrate crate = LootCrateItem.getCrate(stack);
        if (crate == null) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        int n = size = player.m_6047_() ? stack.m_41613_() : 1;
        if (!world.f_46443_) {
            for (WeightedReward reward : crate.table.generateWeightedRandomRewards(player.m_217043_(), crate.table.lootSize * size, true)) {
                reward.reward.claim((ServerPlayer)player, true);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.8f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
        } else {
            new RewardNotificationsScreen().openGui();
            for (int i = 0; i < 5; ++i) {
                Vec3 vec3d = new Vec3(((double)world.f_46441_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d = vec3d.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
                vec3d = vec3d.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
                double d0 = (double)(-world.f_46441_.m_188501_()) * 0.6 - 0.3;
                Vec3 vec3d1 = new Vec3(((double)world.f_46441_.m_188501_() - 0.5) * 0.3, d0, 0.6);
                vec3d1 = vec3d1.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
                vec3d1 = vec3d1.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
                vec3d1 = vec3d1.m_82520_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
                world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec3d1.f_82479_, vec3d1.f_82480_, vec3d1.f_82481_, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
            }
        }
        stack.m_41774_(size);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean m_5812_(ItemStack stack) {
        LootCrate crate = LootCrateItem.getCrate(stack);
        return crate != null && crate.glow;
    }

    public Component m_7626_(ItemStack stack) {
        LootCrate crate = LootCrateItem.getCrate(stack);
        return crate != null && !crate.itemName.isEmpty() ? Component.m_237115_((String)crate.itemName) : super.m_7626_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            for (LootCrate lootCrate : LootCrate.LOOT_CRATES.values()) {
                items.add((Object)lootCrate.createStack());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.ftbquests.lootcrate.tooltip_1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.ftbquests.lootcrate.tooltip_2").m_130940_(ChatFormatting.GRAY));
        if (world == null || !ClientQuestFile.exists()) {
            return;
        }
        LootCrate crate = LootCrateItem.getCrate(stack);
        if (crate != null) {
            if (crate.itemName.isEmpty()) {
                tooltip.add((Component)Component.m_237119_());
                tooltip.add((Component)crate.table.getMutableTitle().m_130940_(ChatFormatting.GRAY));
            }
        } else if (stack.m_41782_() && stack.m_41783_().m_128441_("type")) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237113_((String)stack.m_41783_().m_128461_("type")).m_130940_(ChatFormatting.GRAY));
        }
    }
}

