/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.init;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.GoblinTraderEntity;
import com.mrcrayfish.goblintraders.entity.VeinGoblinTraderEntity;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="goblintraders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"goblintraders");
    public static final RegistryObject<EntityType<GoblinTraderEntity>> GOBLIN_TRADER = ModEntities.build("goblin_trader", GoblinTraderEntity::new, 0.5f, 1.0f);
    public static final RegistryObject<EntityType<VeinGoblinTraderEntity>> VEIN_GOBLIN_TRADER = ModEntities.build("vein_goblin_trader", VeinGoblinTraderEntity::new, 0.5f, 1.0f);

    private static <T extends Entity> RegistryObject<EntityType<T>> build(String id, Function<Level, T> function, float width, float height) {
        return REGISTER.register(id, () -> EntityType.Builder.m_20704_((entityType, world) -> (Entity)function.apply(world), (MobCategory)MobCategory.CREATURE).m_20699_(width, height).setCustomClientFactory((spawnEntity, world) -> (Entity)function.apply((Level)world)).m_20712_(id));
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)GOBLIN_TRADER.get(), AbstractGoblinEntity.createAttributes().m_22265_());
        event.put((EntityType)VEIN_GOBLIN_TRADER.get(), AbstractGoblinEntity.createAttributes().m_22265_());
    }
}

