/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas.mixin;

import com.craisinlord.idas.IDAS;
import com.craisinlord.idas.IDASTags;
import com.craisinlord.idas.state.IStateCacheProvider;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LabyrinthBossKilledMixin
extends Entity {
    public LabyrinthBossKilledMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void idas_labyrinthBossDie(DamageSource damageSource, CallbackInfo info) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.isBoss((Object)this)) {
            return;
        }
        StructureStart structureStart = serverLevel.m_215010_().m_220491_(this.m_20183_(), IDASTags.APPLIES_MINING_FATIGUE);
        if (structureStart.m_73603_()) {
            BlockPos structureStartPos = structureStart.m_163625_().m_45615_();
            ((IStateCacheProvider)this.f_19853_).getStateCache().setCleared(structureStartPos, true);
            List players = serverLevel.m_6907_();
            players.forEach(player -> {
                if (this.f_19853_.m_46749_(player.m_20183_()) && serverLevel.m_215010_().m_220491_(player.m_20183_(), IDASTags.APPLIES_MINING_FATIGUE).m_73603_()) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(SoundEvents.f_11738_, SoundSource.HOSTILE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, 1.0f, serverLevel.m_7328_()));
                    player.m_21195_(MobEffects.f_19599_);
                }
            });
            IDAS.LOGGER.info("CLEARED Labyrinth AT {}", (Object)structureStartPos);
        }
    }

    private boolean isBoss(Object object) {
        if (!(object instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)object;
        if (Objects.equals(mob.m_20078_(), "iceandfire:gorgon")) {
            return true;
        }
        if (mob instanceof Husk) {
            for (ItemStack armorItem : mob.m_6168_()) {
                CompoundTag texture1;
                ListTag textures;
                CompoundTag properties;
                CompoundTag skullOwner;
                CompoundTag compoundTag;
                if (!armorItem.m_150930_(Items.f_42680_) || !armorItem.m_41782_() || !(compoundTag = armorItem.m_41783_()).m_128425_("SkullOwner", 10) || !(skullOwner = compoundTag.m_128469_("SkullOwner")).m_128425_("Properties", 10) || !(properties = skullOwner.m_128469_("Properties")).m_128425_("textures", 9) || (textures = properties.m_128437_("textures", 10)).size() != 1 || !(texture1 = (CompoundTag)textures.get(0)).m_128461_("Value").equals("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTAyNDkwMGIzZDU0ZDEzMDkxOTRkMmMyZjRjNjJhOTVmMTI3ZGY1OWI4MmM2NDE1NDdlNmU4ZmVlNTk3ZTZjIn19fQ==")) continue;
                return true;
            }
        }
        return false;
    }
}

