/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import immersive_aircraft.Main;
import immersive_aircraft.WeaponRendererRegistry;
import immersive_aircraft.client.render.entity.renderer.TrailRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.BBModelRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.client.render.entity.weaponRenderer.WeaponRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.resources.BBModelLoader;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class AircraftEntityRenderer<T extends AircraftEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("invalid");

    public AircraftEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected abstract ModelPartRenderHandler<T> getModel(AircraftEntity var1);

    protected abstract ResourceLocation getModelId();

    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        PoseStack.Pose peek = matrixStack.m_85850_();
        matrixStack.m_85836_();
        float h = (float)((VehicleEntity)((Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)((VehicleEntity)((Object)entity)).getDamageWobbleSide()));
        }
        Vector3f effect = entity.m_20096_() ? Vector3f.f_176763_ : ((AircraftEntity)((Object)entity)).getWindEffect();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-yaw));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(entity.m_5686_(tickDelta) + effect.m_122269_()));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(((VehicleEntity)((Object)entity)).getRoll(tickDelta) + effect.m_122239_()));
        Vector3f pivot = this.getPivot((AircraftEntity)((Object)entity));
        matrixStack.m_85837_((double)pivot.m_122239_(), (double)pivot.m_122260_(), (double)pivot.m_122269_());
        float time = ((float)(entity.m_9236_().m_46467_() % 24000L) + tickDelta) / 20.0f;
        BBAnimationVariables.set("time", time);
        ((AircraftEntity)((Object)entity)).setAnimationVariables(tickDelta);
        BBModel bbModel = BBModelLoader.MODELS.get(this.getModelId());
        if (bbModel != null) {
            float health = ((VehicleEntity)((Object)entity)).getHealth();
            float r = health * 0.6f + 0.4f;
            float g = health * 0.4f + 0.6f;
            float b = health * 0.4f + 0.6f;
            BBModelRenderer.renderModel(bbModel, matrixStack, vertexConsumerProvider, light, time, entity, this.getModel((AircraftEntity)((Object)entity)), r, g, b, 1.0f);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (List<Weapon> weapons : ((InventoryVehicleEntity)((Object)entity)).getWeapons().values()) {
            for (Weapon weapon : weapons) {
                WeaponRenderer<Weapon> renderer;
                if (weapon.getMount().blocking() && Main.firstPersonGetter.isFirstPerson() && player != null && entity.m_20363_((Entity)player) || (renderer = WeaponRendererRegistry.get(weapon)) == null) continue;
                renderer.render(entity, weapon, matrixStack, vertexConsumerProvider, light, tickDelta);
            }
        }
        ((AircraftEntity)((Object)entity)).getTrails().forEach(t -> TrailRenderer.render(t, vertexConsumerProvider, peek));
        matrixStack.m_85849_();
        super.m_7392_(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public void renderOptionalObject(String name, BBModel model, MultiBufferSource vertexConsumerProvider, T entity, PoseStack matrixStack, int light, float time) {
        this.renderOptionalObject(name, model, vertexConsumerProvider, entity, matrixStack, light, time, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderOptionalObject(String name, BBModel model, MultiBufferSource vertexConsumerProvider, T entity, PoseStack matrixStack, int light, float time, float red, float green, float blue, float alpha) {
        BBObject object = model.objectsByName.get(name);
        if (object != null) {
            BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, null, red, green, blue, alpha);
        }
    }

    public boolean shouldRender(T entity, Frustum frustum, double x, double y, double z) {
        if (!entity.m_6000_(x, y, z)) {
            return false;
        }
        AABB box = ((VehicleEntity)((Object)entity)).m_6921_().m_82400_(1.0);
        return frustum.m_113029_(box);
    }

    public ResourceLocation getTextureLocation(@NotNull T aircraft) {
        return TEXTURE;
    }

    public void renderBanners(BBModel model, BBObject ignoredObject, MultiBufferSource vertexConsumerProvider, T entity, PoseStack matrixStack, int light, float time, ModelPartRenderHandler<T> modelPartRenderer) {
        List<ItemStack> slots = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (ItemStack slot : slots) {
            BBObject bannerObject;
            if (slot.m_41619_() || !(slot.m_41720_() instanceof BannerItem)) continue;
            List<Pair<Holder<BannerPattern>, DyeColor>> patterns = Utils.parseBannerItem(slot);
            if (!((bannerObject = model.objectsByName.get("banner_" + i++)) instanceof BBFaceContainer)) continue;
            BBFaceContainer bannerContainer = (BBFaceContainer)((Object)bannerObject);
            BBModelRenderer.renderBanner(bannerContainer, matrixStack, vertexConsumerProvider, light, true, patterns);
        }
    }

    public void renderSails(BBObject object, MultiBufferSource vertexConsumerProvider, T entity, PoseStack matrixStack, int light, float time) {
        DyeColor color;
        ItemStack stack = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            color = item2.m_41089_();
        } else {
            color = DyeColor.WHITE;
        }
        float r = color.m_41068_()[0];
        float g = color.m_41068_()[1];
        float b = color.m_41068_()[2];
        if (object instanceof BBMesh) {
            BBMesh mesh = (BBMesh)object;
            BBModelRenderer.renderSailObject(mesh, matrixStack, vertexConsumerProvider, light, time, r, g, b, 1.0f);
        }
    }
}

