/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Vector3f;
import immersive_aircraft.config.Config;
import immersive_aircraft.data.AircraftDataLoader;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.PositionDescriptor;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.weapons.Telescope;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AircraftEntity
extends InventoryVehicleEntity {
    private final AircraftProperties properties;
    protected double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();

    public AircraftEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
        this.properties = new AircraftProperties(AircraftDataLoader.get(this.identifier).getProperties(), this);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected List<List<PositionDescriptor>> getPassengerPositions() {
        return AircraftDataLoader.get(this.identifier).getPassengerPositions();
    }

    @Override
    public void m_8119_() {
        this.prevRoll = this.roll;
        if (this.f_19861_) {
            this.setZRot(this.roll * 0.9f);
        } else {
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(AircraftStat.ROLL_FACTOR));
        }
        if (Double.isNaN(this.m_20184_().f_82479_) || Double.isNaN(this.m_20184_().f_82480_) || Double.isNaN(this.m_20184_().f_82481_)) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    protected void convertPower(Vec3 direction) {
        Vec3 velocity = this.m_20184_();
        double drag = Math.abs(direction.m_82526_(velocity.m_82541_()));
        this.m_20256_(velocity.m_82541_().m_165921_(direction, (double)this.getProperties().get(AircraftStat.LIFT)).m_82490_(velocity.m_82553_() * (drag * (double)this.getProperties().get(AircraftStat.FRICTION) + (1.0 - (double)this.getProperties().get(AircraftStat.FRICTION)))));
    }

    protected float falloffGroundVelocityDecay(float original) {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getProperties().get(AircraftStat.ACCELERATION) * 0.5f);
        return (original * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    @Override
    protected void updateVelocity() {
        float decay = 1.0f - this.getProperties().get(AircraftStat.FRICTION);
        float gravity = this.getGravity();
        if (this.f_19798_) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.f_19861_) {
            decay = this.m_20160_() ? this.falloffGroundVelocityDecay(this.getProperties().get(AircraftStat.GROUND_FRICTION)) : 0.75f;
        }
        Vec3 direction = this.getForwardDirection();
        double diff = this.lastY - this.m_20186_();
        if (this.lastY != 0.0 && this.getProperties().get(AircraftStat.GLIDE_FACTOR) > 0.0f && diff != 0.0) {
            this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_(diff * (double)this.getProperties().get(AircraftStat.GLIDE_FACTOR) * (1.0 - Math.abs(direction.m_7098_())))));
        }
        this.lastY = this.m_20186_();
        this.convertPower(direction);
        Vec3 velocity = this.m_20184_();
        float hd = this.getProperties().get(AircraftStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(AircraftStat.VERTICAL_DECAY);
        this.m_20334_(velocity.f_82479_ * (double)decay * (double)hd, velocity.f_82480_ * (double)decay * (double)vd + (double)gravity, velocity.f_82481_ * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(AircraftStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
        if (!this.f_19861_) {
            Vector3f effect = this.getWindEffect();
            this.m_146926_(this.m_146909_() + effect.m_122239_());
            this.m_146922_(this.m_146908_() + effect.m_122269_());
            float offsetStrength = 0.005f;
            this.m_20256_(this.m_20184_().m_82520_((double)(effect.m_122239_() * offsetStrength), 0.0, (double)(effect.m_122269_() * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    @Override
    public float getDurability() {
        return this.getProperties().get(AircraftStat.DURABILITY);
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().get(AircraftStat.WIND);
        float thundering = this.f_19853_.m_46722_(0.0f);
        float raining = this.f_19853_.m_46661_(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.m_20184_().m_82553_() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.f_19797_ / 20.0 / (double)this.getProperties().get(AircraftStat.MASS)) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.f_19797_ / 21.0 / (double)this.getProperties().get(AircraftStat.MASS)) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }

    public boolean isScoping() {
        Collection<List<Weapon>> values = this.getWeapons().values();
        for (List<Weapon> weapons : values) {
            for (Weapon weapon : weapons) {
                Telescope telescope;
                if (!(weapon instanceof Telescope) || !(telescope = (Telescope)weapon).isScoping().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public void setAnimationVariables(float tickDelta) {
        BBAnimationVariables.set("pressing_interpolated_x", this.pressingInterpolatedX.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_y", this.pressingInterpolatedY.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_z", this.pressingInterpolatedZ.getSmooth(tickDelta));
    }
}

