/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.WeaponRegistry;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.data.AircraftDataLoader;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.SparseSimpleInventory;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import immersive_aircraft.mixin.ServerPlayerEntityMixin;
import immersive_aircraft.network.s2c.OpenGuiRequest;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryVehicleEntity
extends VehicleEntity
implements ContainerListener,
MenuProvider {
    private SparseSimpleInventory inventory;
    protected Map<Integer, List<Weapon>> weapons = new HashMap<Integer, List<Weapon>>();
    private static final List<WeaponMount> EMPTY_WEAPONS = List.of(WeaponMount.EMPTY);
    private static final Map<WeaponMount.Type, List<WeaponMount>> EMPTY_WEAPONS_MAP = Map.of();

    public VehicleInventoryDescription getInventoryDescription() {
        return AircraftDataLoader.get(this.identifier).getInventoryDescription();
    }

    public List<WeaponMount> getWeaponMounts(int slot) {
        ItemStack stack = this.m_141942_(slot).m_142196_();
        Item item = stack.m_41720_();
        if (item instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            return AircraftDataLoader.get(this.identifier).getWeaponMounts().getOrDefault(slot, EMPTY_WEAPONS_MAP).getOrDefault((Object)weaponItem.getMountType(), EMPTY_WEAPONS);
        }
        return EMPTY_WEAPONS;
    }

    public List<ItemStack> getSlots(VehicleInventoryDescription.SlotType slotType) {
        List<VehicleInventoryDescription.Slot> slots = this.getInventoryDescription().getSlots(slotType);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(slots.size());
        for (VehicleInventoryDescription.Slot slot : slots) {
            list.add(this.getInventory().m_8020_(slot.index()));
        }
        return list;
    }

    public float getTotalUpgrade(AircraftStat stat) {
        float value = 1.0f;
        List<ItemStack> upgrades = this.getSlots(VehicleInventoryDescription.SlotType.UPGRADE);
        for (int step = 0; step < 2; ++step) {
            for (ItemStack stack : upgrades) {
                AircraftUpgrade upgrade = AircraftUpgradeRegistry.INSTANCE.getUpgrade(stack.m_41720_());
                if (upgrade == null) continue;
                float u = upgrade.get(stat);
                if (u > 0.0f && step == 1) {
                    value += u;
                    continue;
                }
                if (!(u < 0.0f) || step != 0) continue;
                value *= u + 1.0f;
            }
        }
        return Math.max(0.0f, value);
    }

    public InventoryVehicleEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
        this.initInventory();
    }

    protected void initInventory() {
        this.inventory = new SparseSimpleInventory(this.getInventoryDescription().getInventorySize());
        this.inventory.m_19164_(this);
    }

    public SparseSimpleInventory getInventory() {
        int inventorySize = this.getInventoryDescription().getInventorySize();
        if (inventorySize != this.inventory.m_6643_()) {
            this.initInventory();
        }
        return this.inventory;
    }

    public void m_5757_(Container sender) {
    }

    @Override
    protected void dropInventory() {
        if (this.getInventory() != null) {
            for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
                ItemStack itemStack = this.getInventory().m_8020_(i);
                if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
                this.m_19983_(itemStack);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new VehicleScreenHandler(i, playerInventory, this);
    }

    public void openInventory(ServerPlayer player) {
        player.m_9217_();
        AbstractContainerMenu screenHandler = this.m_7208_(player.f_8940_, player.m_150109_(), (Player)player);
        if (screenHandler != null) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(this, screenHandler.f_38840_), player);
            player.f_36096_ = screenHandler;
            ServerPlayerEntityMixin playerAccessor = (ServerPlayerEntityMixin)player;
            screenHandler.m_150416_(playerAccessor.getContainerSynchronizer());
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.f_19853_.f_46443_ && player.m_36341_() && !this.m_20365_((Entity)player)) {
            Entity primaryPassenger = this.m_146895_();
            if (primaryPassenger != null) {
                primaryPassenger.m_8127_();
            } else {
                this.openInventory((ServerPlayer)player);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }

    public void m_20258_(CompoundTag nbt) {
        super.m_20258_(nbt);
        ListTag nbtList = nbt.m_128437_("Inventory", 10);
        this.getInventory().readNbt(nbtList);
    }

    public CompoundTag m_20240_(CompoundTag nbt) {
        super.m_20240_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.getInventory().writeNbt(new ListTag()));
        return nbt;
    }

    @Override
    public void boost() {
        super.boost();
        this.getSlots(VehicleInventoryDescription.SlotType.BOOSTER).forEach(s -> s.m_41774_(1));
    }

    @Override
    protected void applyBoost() {
        super.applyBoost();
        Vec3 direction = this.getForwardDirection();
        float thrust = 0.05f * (float)this.getBoost() / 100.0f;
        this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_((double)thrust)));
        if (this.f_19797_ % 2 == 0) {
            Vec3 p = this.m_20182_();
            Vec3 velocity = this.m_20184_().m_82546_(direction);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123815_, p.m_7096_(), p.m_7098_(), p.m_7094_(), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public boolean canBoost() {
        return this.getSlots(VehicleInventoryDescription.SlotType.BOOSTER).stream().anyMatch(v -> !v.m_41619_()) && this.getBoost() <= 0;
    }

    @Override
    public void m_8119_() {
        this.getInventory().tick(this);
        for (VehicleInventoryDescription.Slot slot : this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.WEAPON)) {
            WeaponRegistry.WeaponConstructor constructor;
            ItemStack weaponItemStack = this.m_141942_(slot.index()).m_142196_();
            List<Weapon> weapon = this.weapons.get(slot.index());
            if (weaponItemStack.m_41619_() && weapon != null) {
                this.weapons.remove(slot.index());
                continue;
            }
            if (weaponItemStack.m_41619_() || weapon != null && weapon.get(0).getStack() == weaponItemStack || (constructor = WeaponRegistry.get(weaponItemStack)) == null) continue;
            List<WeaponMount> weaponMounts = this.getWeaponMounts(slot.index());
            ArrayList<Weapon> weapons = new ArrayList<Weapon>(weaponMounts.size());
            for (WeaponMount weaponMount : weaponMounts) {
                weapons.add(constructor.create(this, weaponItemStack, weaponMount, slot.index()));
            }
            this.weapons.put(slot.index(), weapons);
        }
        for (List list : this.weapons.values()) {
            for (Weapon w : list) {
                w.tick();
            }
        }
        super.m_8119_();
    }

    public SlotAccess m_141942_(int slot) {
        return SlotAccess.m_147292_((Container)this.getInventory(), (int)slot);
    }

    public Map<Integer, List<Weapon>> getWeapons() {
        return this.weapons;
    }
}

