/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import com.google.gson.JsonObject;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import immersive_aircraft.util.Utils;
import net.minecraft.network.FriendlyByteBuf;

public record PositionDescriptor(float x, float y, float z, float yaw, float pitch, float roll) {
    static PositionDescriptor fromJson(JsonObject json) {
        float x = Utils.getFloatElement(json, "x");
        float y = Utils.getFloatElement(json, "y");
        float z = Utils.getFloatElement(json, "z");
        float yaw = Utils.getFloatElement(json, "yaw") / 180.0f * (float)Math.PI;
        float pitch = Utils.getFloatElement(json, "pitch") / 180.0f * (float)Math.PI;
        float roll = Utils.getFloatElement(json, "roll") / 180.0f * (float)Math.PI;
        return new PositionDescriptor(x, y, z, yaw, pitch, roll);
    }

    public static PositionDescriptor decode(FriendlyByteBuf byteBuf) {
        float x = byteBuf.readFloat();
        float y = byteBuf.readFloat();
        float z = byteBuf.readFloat();
        float yaw = byteBuf.readFloat();
        float pitch = byteBuf.readFloat();
        float roll = byteBuf.readFloat();
        return new PositionDescriptor(x, y, z, yaw, pitch, roll);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.roll);
    }

    public Matrix4f matrix() {
        Matrix4f matrix = Matrix4f.m_27653_((float)this.x, (float)this.y, (float)this.z);
        Quaternion quaternion = Utils.fromZYX(this.yaw, this.pitch, this.roll);
        matrix.m_27644_(new Matrix4f(quaternion));
        return matrix;
    }
}

