/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.network.c2s.RequestInventory;
import immersive_aircraft.network.s2c.InventoryUpdateMessage;
import immersive_aircraft.screen.VehicleScreenHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class SparseSimpleInventory
extends SimpleContainer {
    private final NonNullList<ItemStack> tracked;
    private boolean inventoryRequested = false;

    public SparseSimpleInventory(int size) {
        super(size);
        this.tracked = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public ListTag writeNbt(ListTag nbtList) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)i);
            this.m_8020_(i).m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        return nbtList;
    }

    public void readNbt(ListTag nbtList) {
        this.m_6211_();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int slot = nbtCompound.m_128445_("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)nbtCompound);
            if (itemStack.m_41619_()) continue;
            this.m_6836_(slot, itemStack);
        }
    }

    public void tick(InventoryVehicleEntity entity) {
        if (entity.m_9236_().f_46443_) {
            if (!this.inventoryRequested) {
                NetworkHandler.sendToServer(new RequestInventory(entity.m_19879_()));
                this.inventoryRequested = true;
            }
        } else {
            ItemStack trackedStack;
            int lastSyncIndex = entity.getInventoryDescription().getLastSyncIndex();
            if (lastSyncIndex == 0) {
                return;
            }
            int index = entity.f_19797_ % lastSyncIndex;
            ItemStack stack = this.m_8020_(index);
            if (!stack.equals(trackedStack = (ItemStack)this.tracked.get(index))) {
                this.tracked.set(index, (Object)stack);
                entity.m_9236_().m_6907_().forEach(p -> {
                    VehicleScreenHandler vehicleScreenHandler;
                    AbstractContainerMenu patt2528$temp = p.f_36096_;
                    if (!(patt2528$temp instanceof VehicleScreenHandler) || (vehicleScreenHandler = (VehicleScreenHandler)patt2528$temp).getVehicle() != entity) {
                        NetworkHandler.sendToPlayer(new InventoryUpdateMessage(entity.m_19879_(), index, stack), (ServerPlayer)p);
                    }
                });
            }
        }
    }
}

