/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.forge.cobalt.registration;

import immersive_aircraft.cobalt.registration.Registration;
import immersive_aircraft.forge.ForgeBusEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class RegistrationImpl
extends Registration.Impl {
    private final Map<String, RegistryRepo> repos = new HashMap<String, RegistryRepo>();
    private final DataLoaderRegister dataLoaderRegister = new DataLoaderRegister();
    private final DataLoaderRegister resourceLoaderRegister = new DataLoaderRegister();

    public RegistrationImpl() {
        ForgeBusEvents.DATA_REGISTRY = this.dataLoaderRegister;
        ForgeBusEvents.RESOURCE_REGISTRY = this.resourceLoaderRegister;
    }

    private RegistryRepo getRepo(String namespace) {
        return this.repos.computeIfAbsent(namespace, RegistryRepo::new);
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(EntityType<T> type, EntityRendererProvider<T> constructor) {
        EntityRenderers.m_174036_(type, constructor);
    }

    @Override
    public void registerDataLoader(ResourceLocation id, PreparableReloadListener loader) {
        this.dataLoaderRegister.dataLoaders.add(loader);
    }

    @Override
    public void registerResourceLoader(ResourceLocation id, PreparableReloadListener loader) {
        this.resourceLoaderRegister.dataLoaders.add(loader);
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, ResourceLocation id, Supplier<T> obj) {
        DeferredRegister reg = this.getRepo(id.m_135827_()).get(registry);
        return reg.register(id.m_135815_(), obj);
    }

    @Override
    public CreativeModeTab itemGroup(ResourceLocation id, final Supplier<ItemStack> icon) {
        return new CreativeModeTab(CreativeModeTab.getGroupCountSafe(), String.format("%s.%s", id.m_135827_(), id.m_135815_())){

            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }
        };
    }

    public static class DataLoaderRegister {
        private final List<PreparableReloadListener> dataLoaders = new ArrayList<PreparableReloadListener>();

        public List<PreparableReloadListener> getLoaders() {
            return this.dataLoaders;
        }
    }

    static class RegistryRepo {
        private final Set<ResourceLocation> skipped = new HashSet<ResourceLocation>();
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();
        private final String namespace;

        public RegistryRepo(String namespace) {
            this.namespace = namespace;
        }

        public <T> DeferredRegister get(Registry<? super T> registry) {
            ResourceLocation id = registry.m_123023_().m_135782_();
            if (!this.registries.containsKey(id) && !this.skipped.contains(id)) {
                ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(id);
                if (reg == null) {
                    this.skipped.add(id);
                    return null;
                }
                DeferredRegister def = DeferredRegister.create((IForgeRegistry)((IForgeRegistry)Objects.requireNonNull(reg, "Registry=" + id)), (String)this.namespace);
                def.register(FMLJavaModLoadingContext.get().getModEventBus());
                this.registries.put(id, def);
            }
            return this.registries.get(id);
        }
    }
}

