/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.mobspawners;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.misc.mobspawners.MobSpawnerObj;
import com.craisinlord.integrated_api.mixin.features.DungeonFeatureAccessor;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class MobSpawnerManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private Map<ResourceLocation, List<MobSpawnerObj>> spawnerMap = ImmutableMap.of();

    public MobSpawnerManager() {
        super(GSON, "integrated_structure_spawners");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                List spawnerMobEntries = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("mobs"), new TypeToken<List<MobSpawnerObj>>(){}.getType());
                for (int i = spawnerMobEntries.size() - 1; i >= 0; --i) {
                    MobSpawnerObj entry = (MobSpawnerObj)spawnerMobEntries.get(i);
                    entry.setEntityType();
                    if (entry.weight == 0.0f || entry.entityType == null) {
                        spawnerMobEntries.remove(i);
                        continue;
                    }
                    if (!(entry.weight < 0.0f)) continue;
                    throw new Exception("Error: Found " + entry.name + " entry has a weight less than 0. Please remove the entry if you don't want a mob to be picked");
                }
                builder.put(fileIdentifier, (Object)spawnerMobEntries);
            }
            catch (Exception e) {
                IntegratedAPI.LOGGER.error("Integrated API Error: Couldn't parse spawner mob list {}", fileIdentifier, (Object)e);
            }
        });
        this.spawnerMap = builder.build();
    }

    public EntityType<?> getSpawnerMob(ResourceLocation spawnerJsonEntry, RandomSource random) {
        List<MobSpawnerObj> spawnerMobEntries = this.spawnerMap.get(spawnerJsonEntry);
        if (spawnerMobEntries == null) {
            IntegratedAPI.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + spawnerJsonEntry + ".json is correct or that no other mod is interfering with how vanilla reads data folders. Let TelepathicGrunt know about this too!\n***************************************");
            return (EntityType)Util.m_214670_((Object[])DungeonFeatureAccessor.getMOBS(), (RandomSource)random);
        }
        float totalWeight = 0.0f;
        for (MobSpawnerObj mobSpawnerObj : spawnerMobEntries) {
            totalWeight += mobSpawnerObj.weight;
        }
        if (totalWeight == 0.0f) {
            return null;
        }
        float randomWeight = random.m_188501_() * totalWeight;
        int index = 0;
        try {
            while (true) {
                if ((randomWeight -= spawnerMobEntries.get((int)index).weight) <= 0.0f) {
                    return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(spawnerMobEntries.get((int)index).name));
                }
                ++index;
            }
        }
        catch (Exception e) {
            IntegratedAPI.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + spawnerJsonEntry + ".json is correct\n***************************************");
            return EntityType.f_20510_;
        }
    }
}

