/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.modinit.IntegratedAPIStructures;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.craisinlord.integrated_api.world.structures.pieces.PieceLimitedJigsawManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.fml.ModList;

public class ModAdaptiveStructure
extends JigsawStructure {
    public static final Codec<ModAdaptiveStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModAdaptiveStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)Codec.BOOL.fieldOf("rotation_fixed").orElse((Object)false).forGetter(structure -> structure.rotationFixed), (App)Codec.STRING.fieldOf("change_pool_mods").forGetter(structure -> structure.changePoolMod), (App)StructureTemplatePool.f_210555_.fieldOf("new_pool").forGetter(structure -> structure.newPool)).apply((Applicative)instance, ModAdaptiveStructure::new));
    public final String changePoolMod;
    public final Holder<StructureTemplatePool> newPool;

    public ModAdaptiveStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, boolean useBoundingBoxHack, boolean rotationFixed, String changePoolMod, Holder<StructureTemplatePool> newPool) {
        super(config, startPool, size, minYAllowed, maxYAllowed, Optional.empty(), startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, maxDistanceFromCenter, Optional.empty(), useBoundingBoxHack, rotationFixed);
        this.changePoolMod = changePoolMod;
        this.newPool = newPool;
    }

    private ArrayList<String> convertModList(String modlist) {
        int startChar = 0;
        ArrayList<String> convertedModList = new ArrayList<String>();
        for (int i = 0; i < modlist.length(); ++i) {
            if (modlist.charAt(i) != ',') continue;
            convertedModList.add(modlist.substring(startChar, i));
            startChar = i + 1;
        }
        convertedModList.add(modlist.substring(startChar));
        return convertedModList;
    }

    public boolean allModsPresent(ArrayList<String> convertedModList) {
        for (String mod : convertedModList) {
            if (ModAdaptiveStructure.isLoaded(mod)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ArrayList<String> changePoolMods;
        int offsetY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), offsetY, context.f_226628_().m_45605_());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        Holder<StructureTemplatePool> finalPool = this.startPool;
        if (!this.changePoolMod.isEmpty() && this.allModsPresent(changePoolMods = this.convertModList(this.changePoolMod))) {
            finalPool = this.newPool;
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.allowedYRangeFromStart.isPresent()) {
            topClipOff = blockpos.m_123342_() + (Integer)this.allowedYRangeFromStart.get();
            bottomClipOff = blockpos.m_123342_() - (Integer)this.allowedYRangeFromStart.get();
        }
        if (this.maxYAllowed.isPresent()) {
            topClipOff = Math.min(topClipOff, (Integer)this.maxYAllowed.get());
        }
        if (this.minYAllowed.isPresent()) {
            bottomClipOff = Math.max(bottomClipOff, (Integer)this.minYAllowed.get());
        }
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, finalPool, this.size, context.f_226621_().m_175515_(Registry.f_235725_).m_7981_((Object)this), blockpos, this.useBoundingBoxHack, this.projectStartToHeightmap, topClipOff, bottomClipOff, null, this.maxDistanceFromCenter, this.rotationFixed, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((StructurePiecesBuilder)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<PoolElementStructurePiece>)pieces));
    }

    public static boolean isLoaded(String name) {
        return ModList.get().isLoaded(name);
    }

    @Override
    public StructureType<?> m_213658_() {
        return (StructureType)IntegratedAPIStructures.MOD_ADAPTIVE_STRUCTURE.get();
    }
}

