/*
 * Decompiled with CFR 0.152.
 */
package com.sudolev.interiors.content.block.chair;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.sudolev.interiors.Utils;
import com.sudolev.interiors.content.block.chair.ChairBlock;
import com.sudolev.interiors.content.entity.BigSeatEntity;
import com.sudolev.interiors.content.registry.CIBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BigChairBlock
extends ChairBlock {
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)5.0, (double)12.0));

    public BigChairBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
    }

    @Override
    public VoxelShape shape() {
        return SHAPE;
    }

    public static void sitDown(@NotNull Level world, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (world.f_46443_) {
            return;
        }
        BigSeatEntity seat = new BigSeatEntity(world, pos);
        seat.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.34f, (float)pos.m_123343_() + 0.5f);
        world.m_7967_((Entity)seat);
        entity.m_7998_((Entity)seat, true);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.m_21837_(true);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem == AllItems.WRENCH.asStack(1) || heldItem.m_150930_((Item)AllItems.WRENCH.get())) {
            return InteractionResult.PASS;
        }
        DyeColor color = Utils.colorFromItem(heldItem);
        if (color != null && color != this.color) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties((BlockState)state, (BlockState)CIBlocks.CHAIRS.get(color).getDefaultState());
            world.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        List seats = world.m_45976_(BigSeatEntity.class, new AABB(pos));
        if (!seats.isEmpty()) {
            BigSeatEntity entity = (BigSeatEntity)((Object)seats.get(0));
            List passengers = entity.m_20197_();
            if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                entity.m_20153_();
                player.m_20329_((Entity)entity);
            }
            return InteractionResult.SUCCESS;
        }
        if (!world.f_46443_) {
            BigChairBlock.sitDown(world, pos, (Entity)BigChairBlock.getLeashed((Level)world, (Player)player).or((Object)player));
        }
        return InteractionResult.SUCCESS;
    }
}

