/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.LearnedSpellData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.gui.overlays.SpellSelection;
import io.redspace.ironsspellbooks.network.ClientboundSyncEntityData;
import io.redspace.ironsspellbooks.network.ClientboundSyncPlayerData;
import io.redspace.ironsspellbooks.player.SpinAttackType;
import io.redspace.ironsspellbooks.setup.Messages;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class SyncedSpellData {
    public static final long ANGEL_WINGS = 1L;
    public static final long EVASION = 2L;
    public static final long HEARTSTOP = 4L;
    public static final long ABYSSAL_SHROUD = 8L;
    public static final long ASCENSION = 16L;
    public static final long TRUE_INVIS = 32L;
    public static final long CHARGED = 64L;
    public static final long PLANAR_SIGHT = 128L;
    public static final long HEAL_TARGET = 1L;
    private final int serverPlayerId;
    @Nullable
    private LivingEntity livingEntity = null;
    private boolean isCasting;
    private String castingSpellId;
    private int castingSpellLevel;
    private long syncedEffectFlags;
    private long localEffectFlags;
    private float heartStopAccumulatedDamage;
    private int evasionHitsRemaining;
    private SpinAttackType spinAttackType;
    private final LearnedSpellData learnedSpellData;
    private SpellSelection spellSelection;
    private String castingEquipmentSlot;
    public static final EntityDataSerializer<SyncedSpellData> SYNCED_SPELL_DATA = new EntityDataSerializer.ForValueType<SyncedSpellData>(){

        public void write(FriendlyByteBuf buffer, SyncedSpellData data) {
            buffer.writeInt(data.serverPlayerId);
            buffer.writeBoolean(data.isCasting);
            buffer.m_130070_(data.castingSpellId);
            buffer.writeInt(data.castingSpellLevel);
            buffer.writeLong(data.syncedEffectFlags);
            buffer.writeFloat(data.heartStopAccumulatedDamage);
            buffer.writeInt(data.evasionHitsRemaining);
            buffer.m_130068_((Enum)data.spinAttackType);
            buffer.m_130070_(data.castingEquipmentSlot);
            data.learnedSpellData.writeToBuffer(buffer);
            data.spellSelection.writeToBuffer(buffer);
        }

        public SyncedSpellData read(FriendlyByteBuf buffer) {
            SyncedSpellData data = new SyncedSpellData(buffer.readInt());
            data.isCasting = buffer.readBoolean();
            data.castingSpellId = buffer.m_130277_();
            data.castingSpellLevel = buffer.readInt();
            data.syncedEffectFlags = buffer.readLong();
            data.heartStopAccumulatedDamage = buffer.readFloat();
            data.evasionHitsRemaining = buffer.readInt();
            data.spinAttackType = (SpinAttackType)buffer.m_130066_(SpinAttackType.class);
            data.castingEquipmentSlot = buffer.m_130277_();
            data.learnedSpellData.readFromBuffer(buffer);
            data.spellSelection.readFromBuffer(buffer);
            return data;
        }
    };

    public SyncedSpellData(int serverPlayerId) {
        this.serverPlayerId = serverPlayerId;
        this.isCasting = false;
        this.castingSpellId = "";
        this.castingEquipmentSlot = "";
        this.castingSpellLevel = 0;
        this.syncedEffectFlags = 0L;
        this.localEffectFlags = 0L;
        this.heartStopAccumulatedDamage = 0.0f;
        this.evasionHitsRemaining = 0;
        this.spinAttackType = SpinAttackType.RIPTIDE;
        this.learnedSpellData = new LearnedSpellData();
        this.spellSelection = new SpellSelection();
    }

    public SyncedSpellData(LivingEntity livingEntity) {
        this(livingEntity == null ? -1 : livingEntity.m_19879_());
        this.livingEntity = livingEntity;
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128379_("isCasting", this.isCasting);
        compound.m_128359_("castingSpellId", this.castingSpellId);
        compound.m_128359_("castingEquipmentSlot", this.castingEquipmentSlot);
        compound.m_128405_("castingSpellLevel", this.castingSpellLevel);
        compound.m_128356_("effectFlags", this.syncedEffectFlags);
        compound.m_128350_("heartStopAccumulatedDamage", this.heartStopAccumulatedDamage);
        compound.m_128350_("evasionHitsRemaining", (float)this.evasionHitsRemaining);
        this.learnedSpellData.saveToNBT(compound);
        compound.m_128365_("spellSelection", (Tag)this.spellSelection.serializeNBT());
    }

    public void loadNBTData(CompoundTag compound) {
        this.isCasting = compound.m_128471_("isCasting");
        this.castingSpellId = compound.m_128461_("castingSpellId");
        this.castingEquipmentSlot = compound.m_128461_("castingEquipmentSlot");
        this.castingSpellLevel = compound.m_128451_("castingSpellLevel");
        this.syncedEffectFlags = compound.m_128454_("effectFlags");
        this.heartStopAccumulatedDamage = compound.m_128457_("heartStopAccumulatedDamage");
        this.evasionHitsRemaining = compound.m_128451_("evasionHitsRemaining");
        this.learnedSpellData.loadFromNBT(compound);
        this.spellSelection.deserializeNBT(compound.m_128469_("spellSelection"));
    }

    public int getServerPlayerId() {
        return this.serverPlayerId;
    }

    public boolean hasEffect(long effectFlags) {
        return (this.syncedEffectFlags & effectFlags) == effectFlags;
    }

    public String getCastingEquipmentSlot() {
        return this.castingEquipmentSlot;
    }

    public boolean hasLocalEffect(long effectFlags) {
        return (this.localEffectFlags & effectFlags) == effectFlags;
    }

    public void addLocalEffect(long effectFlags) {
        this.localEffectFlags |= effectFlags;
    }

    public void removeLocalEffect(long effectFlags) {
        this.localEffectFlags &= effectFlags ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public float getHeartstopAccumulatedDamage() {
        return this.heartStopAccumulatedDamage;
    }

    public boolean hasDodgeEffect() {
        return this.hasEffect(2L) || this.hasEffect(8L);
    }

    public void setHeartstopAccumulatedDamage(float damage) {
        this.heartStopAccumulatedDamage = damage;
        this.doSync();
    }

    public SpellSelection getSpellSelection() {
        return this.spellSelection;
    }

    public void setSpellSelection(SpellSelection spellSelection) {
        this.spellSelection = spellSelection;
        this.doSync();
    }

    public void learnSpell(AbstractSpell spell) {
        this.learnedSpellData.learnedSpells.add(spell.getSpellResource());
        this.doSync();
    }

    public void forgetAllSpells() {
        this.learnedSpellData.learnedSpells.clear();
        this.doSync();
    }

    public boolean isSpellLearned(AbstractSpell spell) {
        return !spell.needsLearning() || this.learnedSpellData.learnedSpells.contains(spell.getSpellResource());
    }

    public SpinAttackType getSpinAttackType() {
        return this.spinAttackType;
    }

    public void setSpinAttackType(SpinAttackType spinAttackType) {
        this.spinAttackType = spinAttackType;
        this.doSync();
    }

    public int getEvasionHitsRemaining() {
        return this.evasionHitsRemaining;
    }

    public void subtractEvasionHit() {
        --this.evasionHitsRemaining;
        this.doSync();
    }

    public void setEvasionHitsRemaining(int hitsRemaining) {
        this.evasionHitsRemaining = hitsRemaining;
        this.doSync();
    }

    public void addHeartstopDamage(float damage) {
        this.heartStopAccumulatedDamage += damage;
        this.doSync();
    }

    public void addEffects(long effectFlags) {
        this.syncedEffectFlags |= effectFlags;
        this.doSync();
    }

    public void removeEffects(long effectFlags) {
        this.syncedEffectFlags &= effectFlags ^ 0xFFFFFFFFFFFFFFFFL;
        this.doSync();
    }

    public void doSync() {
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Messages.sendToPlayer(new ClientboundSyncPlayerData(this), serverPlayer);
            Messages.sendToPlayersTrackingEntity(new ClientboundSyncPlayerData(this), (Entity)serverPlayer);
        } else {
            livingEntity = this.livingEntity;
            if (livingEntity instanceof IMagicEntity) {
                IMagicEntity abstractSpellCastingMob = (IMagicEntity)livingEntity;
                Messages.sendToPlayersTrackingEntity(new ClientboundSyncEntityData(this, abstractSpellCastingMob), (Entity)this.livingEntity);
            }
        }
    }

    public void syncToPlayer(ServerPlayer serverPlayer) {
        Messages.sendToPlayer(new ClientboundSyncPlayerData(this), serverPlayer);
    }

    public void setIsCasting(boolean isCasting, String castingSpellId, int castingSpellLevel, String castingEquipmentSlot) {
        this.isCasting = isCasting;
        this.castingSpellId = castingSpellId;
        this.castingSpellLevel = castingSpellLevel;
        this.castingEquipmentSlot = castingEquipmentSlot;
        this.doSync();
    }

    public boolean isCasting() {
        return this.isCasting;
    }

    public String getCastingSpellId() {
        return this.castingSpellId;
    }

    public int getCastingSpellLevel() {
        return this.castingSpellLevel;
    }

    protected SyncedSpellData clone() {
        return new SyncedSpellData(this.livingEntity);
    }

    public String toString() {
        return String.format("isCasting:%s, spellID:%s, spellLevel:%d, effectFlags:%d", this.isCasting, this.castingSpellId, this.castingSpellLevel, this.syncedEffectFlags);
    }

    public SyncedSpellData getPersistentData() {
        SyncedSpellData persistentData = new SyncedSpellData(this.livingEntity);
        persistentData.learnedSpellData.learnedSpells.addAll(this.learnedSpellData.learnedSpells);
        return persistentData;
    }
}

