/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.eldritch;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractEldritchSpell
extends AbstractSpell {
    public static final Style ELDRITCH_OBFUSCATED_STYLE = Style.f_131099_.m_178524_(Boolean.valueOf(true)).m_131150_(new ResourceLocation("alt"));

    @Override
    public MutableComponent getDisplayName(Player player) {
        boolean obfuscateName = player != null && this.obfuscateStats(player);
        return super.getDisplayName(player).m_130948_(obfuscateName ? ELDRITCH_OBFUSCATED_STYLE : Style.f_131099_);
    }

    @Override
    public boolean allowLooting() {
        return false;
    }

    @Override
    public boolean canBeCraftedBy(Player player) {
        return this.isLearned(player);
    }

    @Override
    public boolean obfuscateStats(Player player) {
        return !this.isLearned(player);
    }

    @Override
    public CastResult canBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player) {
        if (!this.isLearned(player)) {
            return new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_unlearned").m_130940_(ChatFormatting.RED));
        }
        return super.canBeCastedBy(spellLevel, castSource, playerMagicData, player);
    }

    @Override
    public boolean isLearned(Player player) {
        if (player == null) {
            return false;
        }
        if (player.f_19853_.f_46443_) {
            return ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(this);
        }
        return MagicData.getPlayerMagicData((LivingEntity)player).getSyncedData().isSpellLearned(this);
    }

    @Override
    public boolean needsLearning() {
        return true;
    }
}

