/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.renderer;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.obscuria.lootjournal.LootJournalConfig;
import com.obscuria.lootjournal.client.Filtering;
import com.obscuria.lootjournal.client.pickup.ItemPickup;
import com.obscuria.lootjournal.client.pickup.MoreItemsPickup;
import com.obscuria.lootjournal.client.pickup.Pickup;
import com.obscuria.lootjournal.client.renderer.Anchor;
import com.obscuria.lootjournal.client.renderer.Style;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public final class PickupComponent {
    private static final HashMap<Integer, PickupInstance> occupiedSlots = Maps.newHashMap();
    private static final List<PickupInstance> visiblePickups = Lists.newArrayList();
    private static final Deque<Pickup> queued = Queues.newArrayDeque();

    public static void append(int itemId, int playerId, int amount) {
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_19879_() == playerId && (entity = player.f_19853_.m_6815_(itemId)) instanceof ItemEntity) {
            ItemEntity entity2 = (ItemEntity)entity;
            ItemStack stack = entity2.m_32055_().m_41777_();
            stack.m_41764_(amount);
            PickupComponent.append(stack);
        }
    }

    public static void append(ItemStack stack) {
        if (!Filtering.isAllowed(stack)) {
            return;
        }
        Integer displayCapacity = (Integer)LootJournalConfig.displayCapacity.get();
        Integer queueCapacity = (Integer)LootJournalConfig.queueCapacity.get();
        if (queueCapacity > 0) {
            Pickup pickup = queued.size() < queueCapacity ? ItemPickup.of(stack) : MoreItemsPickup.of(stack);
            PickupComponent.appendOrQueue(pickup);
        } else {
            Pickup pickup = visiblePickups.size() < displayCapacity ? ItemPickup.of(stack) : MoreItemsPickup.of(stack);
            PickupComponent.appendNoQueue(pickup);
        }
    }

    private static void appendOrQueue(Pickup pickup) {
        if (PickupComponent.merge(pickup)) {
            return;
        }
        int index = PickupComponent.findFreeIndex((Integer)LootJournalConfig.displayCapacity.get());
        if (index > -1) {
            PickupInstance instance = new PickupInstance(pickup, index);
            visiblePickups.add(instance);
            occupiedSlots.put(index, instance);
        } else {
            queued.add(pickup);
        }
    }

    private static void appendNoQueue(Pickup pickup) {
        if (PickupComponent.merge(pickup)) {
            return;
        }
        int index = PickupComponent.findFreeIndex(256);
        if (index > -1) {
            PickupInstance instance = new PickupInstance(pickup, index);
            visiblePickups.add(instance);
            occupiedSlots.put(index, instance);
        }
    }

    private static boolean merge(Pickup pickup) {
        for (PickupInstance instance : visiblePickups) {
            if (!instance.merge(pickup)) continue;
            return true;
        }
        for (Pickup other : queued) {
            if (!other.merge(pickup)) continue;
            return true;
        }
        return false;
    }

    private static int findFreeIndex(int size) {
        for (int i = 0; i < size; ++i) {
            if (occupiedSlots.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    @ApiStatus.Internal
    public static void render(PoseStack pose) {
        Window window = Minecraft.m_91087_().m_91268_();
        Integer capacity = (Integer)LootJournalConfig.displayCapacity.get();
        Style style = (Style)((Object)LootJournalConfig.style.get());
        Anchor anchor = (Anchor)((Object)LootJournalConfig.anchor.get());
        int originX = anchor.originX(window);
        int originY = anchor.originY(window);
        int step = anchor.step();
        visiblePickups.removeIf(instance -> {
            if (instance.render(pose, style, anchor, originX, originY + step * instance.index)) {
                occupiedSlots.remove(instance.index);
                return true;
            }
            return false;
        });
        if (queued.isEmpty() || occupiedSlots.size() >= capacity) {
            return;
        }
        queued.removeIf(pickup -> {
            int index = PickupComponent.findFreeIndex(capacity);
            if (index > -1) {
                PickupInstance instance = new PickupInstance((Pickup)pickup, index);
                visiblePickups.add(instance);
                occupiedSlots.put(index, instance);
                return true;
            }
            return false;
        });
    }

    private static class PickupInstance {
        private static final long FADE_IN = 750L;
        private static final long FADE_OUT = 1500L;
        private final Pickup pickup;
        private long startTime = -1L;
        private long lastTime;
        private double delta;
        private double factor;
        int index;

        PickupInstance(Pickup pickup, int index) {
            this.pickup = pickup;
            this.index = index;
        }

        boolean render(PoseStack pose, Style style, Anchor anchor, int x, int y) {
            long currentTime = Util.m_137550_();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
                this.lastTime = currentTime;
            }
            this.delta = (double)(currentTime - this.lastTime) / 1000.0;
            this.lastTime = currentTime;
            long time = currentTime - this.startTime;
            if (!Minecraft.m_91087_().f_91066_.f_92062_) {
                style.render(this.pickup, pose, anchor, x, y, this.factor, time);
            }
            this.updateFactor(time);
            return time > this.getMaxTime();
        }

        boolean merge(Pickup other) {
            if (this.pickup.merge(other)) {
                this.startTime = Util.m_137550_();
                return true;
            }
            return this.pickup.merge(other);
        }

        private void updateFactor(long time) {
            if (time <= 750L) {
                this.factor = Math.min(this.factor + this.delta * 2.0, 1.0);
            }
            if (time >= this.getMaxTime() - 1500L) {
                this.factor = Math.max(this.factor - this.delta, 0.0);
            }
        }

        private long getDisplayTime() {
            return (long)(1000.0 * (Double)LootJournalConfig.duration.get());
        }

        private long getMaxTime() {
            return 2250L + this.getDisplayTime();
        }
    }
}

