/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.obscuria.lootjournal.client.pickup.Pickup;
import com.obscuria.lootjournal.client.renderer.Anchor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum Style {
    DEFAULT(Style::renderStyleDefault),
    FLAT(Style::renderStyleFlat),
    NO_BACKGROUND(Style::renderStyleNoBackground);

    private static final ResourceLocation DECORATIONS;
    private final RenderFunc renderFunc;

    private Style(RenderFunc renderFunc) {
        this.renderFunc = renderFunc;
    }

    public void render(Pickup pickup, PoseStack pose, Anchor anchor, int x, int y, double factor, long time) {
        Font font = Minecraft.m_91087_().f_91062_;
        double actualX = (double)x + Style.getOffset(factor, anchor.isInverted());
        MutableComponent name = pickup.getName();
        int nameWidth = font.m_92852_((FormattedText)name);
        MutableComponent total = pickup.shouldRenderTotal() ? Component.m_237113_((String)String.valueOf(pickup.getTotal())) : Component.m_237119_();
        int totalWidth = pickup.shouldRenderTotal() ? font.m_92852_((FormattedText)total) + 5 : 0;
        pose.m_85836_();
        pose.m_85837_(actualX, (double)y, 400.0);
        RenderSystem.m_69478_();
        this.renderFunc.render(pickup, pose, anchor, font, name, nameWidth, total, totalWidth, actualX, y, time);
        RenderSystem.m_69461_();
        pose.m_85849_();
    }

    private static void renderStyleDefault(Pickup pickup, PoseStack pose, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)DECORATIONS);
        if (anchor.isInverted()) {
            GuiComponent.m_93133_((PoseStack)pose, (int)(-36 - nameWidth - totalWidth), (int)0, (float)0.0f, (float)0.0f, (int)256, (int)12, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)pose, (int)(-26 - totalWidth), (int)1, (float)0.0f, (float)12.0f, (int)256, (int)10, (int)256, (int)256);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)name, (int)(-29 - nameWidth - totalWidth), (int)2, (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)total.m_130940_(ChatFormatting.GRAY), (int)(-totalWidth), (int)2, (int)0xFFFFFF);
            Style.renderIcon(pickup, pose, x - 11.0 - (double)totalWidth, y + 6.0, time);
        } else {
            GuiComponent.m_93133_((PoseStack)pose, (int)(-218 + nameWidth + totalWidth), (int)0, (float)0.0f, (float)0.0f, (int)256, (int)12, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)pose, (int)(-230 + totalWidth), (int)1, (float)0.0f, (float)12.0f, (int)256, (int)10, (int)256, (int)256);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)name, (int)(30 + totalWidth), (int)2, (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)total.m_130940_(ChatFormatting.GRAY), (int)5, (int)2, (int)0xFFFFFF);
            Style.renderIcon(pickup, pose, x + 11.0 + (double)totalWidth, y + 6.0, time);
        }
    }

    private static void renderStyleFlat(Pickup pickup, PoseStack pose, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isInverted()) {
            GuiComponent.m_93172_((PoseStack)pose, (int)-3, (int)0, (int)(-25 - nameWidth - totalWidth), (int)12, (int)Integer.MIN_VALUE);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)name, (int)(-23 - nameWidth - totalWidth), (int)2, (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)total.m_130940_(ChatFormatting.GRAY), (int)(-totalWidth), (int)2, (int)0xFFFFFF);
            Style.renderIcon(pickup, pose, x - 11.0 - (double)totalWidth, y + 6.0, time);
        } else {
            GuiComponent.m_93172_((PoseStack)pose, (int)3, (int)0, (int)(25 + nameWidth + totalWidth), (int)12, (int)Integer.MIN_VALUE);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)name, (int)(23 + totalWidth), (int)2, (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)total.m_130940_(ChatFormatting.GRAY), (int)5, (int)2, (int)0xFFFFFF);
            Style.renderIcon(pickup, pose, x + 11.0 + (double)totalWidth, y + 6.0, time);
        }
    }

    private static void renderStyleNoBackground(Pickup pickup, PoseStack pose, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isInverted()) {
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)name, (int)(-23 - nameWidth - totalWidth), (int)2, (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)total.m_130940_(ChatFormatting.GRAY), (int)(-totalWidth), (int)2, (int)0xFFFFFF);
            Style.renderIcon(pickup, pose, x - 11.0 - (double)totalWidth, y + 6.0, time);
        } else {
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)name, (int)(23 + totalWidth), (int)2, (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)total.m_130940_(ChatFormatting.GRAY), (int)5, (int)2, (int)0xFFFFFF);
            Style.renderIcon(pickup, pose, x + 11.0 + (double)totalWidth, y + 6.0, time);
        }
    }

    private static void renderIcon(Pickup pickup, PoseStack pose, double x, double y, long time) {
        RenderSystem.m_157191_().m_85837_(x, y, 500.0);
        RenderSystem.m_157182_();
        pickup.renderIcon(pose, time);
        RenderSystem.m_157191_().m_85837_(-x, -y, -500.0);
        RenderSystem.m_157182_();
    }

    private static Component getName(String raw, int count) {
        if (((String)raw).length() > 24) {
            raw = ((String)raw).substring(0, 23) + "...";
        }
        return Component.m_237113_((String)((String)raw + " x" + count));
    }

    private static double getOffset(double factor, boolean inverted) {
        double offset = -220.0 + 220.0 * (1.0 - Math.pow(factor - 1.0, 2.0));
        return inverted ? -offset : offset;
    }

    static {
        DECORATIONS = new ResourceLocation("loot_journal:textures/gui/decorations.png");
    }

    @FunctionalInterface
    private static interface RenderFunc {
        public void render(Pickup var1, PoseStack var2, Anchor var3, Font var4, MutableComponent var5, int var6, MutableComponent var7, int var8, double var9, double var11, long var13);
    }
}

