/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.config.ConfigManager;

public class BarrelModel
implements IUnbakedGeometry<BarrelModel> {
    private final UnbakedModel opened;
    private final UnbakedModel unopened;
    private final UnbakedModel vanilla;
    private final UnbakedModel old_opened;
    private final UnbakedModel old_unopened;

    public BarrelModel(UnbakedModel opened, UnbakedModel unopened, UnbakedModel vanilla, UnbakedModel old_unopened, UnbakedModel old_opened) {
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
        this.old_opened = old_opened;
        this.old_unopened = old_unopened;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(context.getMaterial("particle"));
        materials.addAll(this.unopened.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.opened.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.vanilla.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.old_opened.m_5500_(modelGetter, missingTextureErrors));
        materials.addAll(this.old_unopened.m_5500_(modelGetter, missingTextureErrors));
        return materials;
    }

    private static BakedModel buildModel(UnbakedModel entry, ModelState modelTransform, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        return entry.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BarrelBakedModel(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), spriteGetter.apply(context.getMaterial("particle")), overrides, BarrelModel.buildModel(this.opened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.unopened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.vanilla, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.old_opened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.old_unopened, modelTransform, bakery, spriteGetter, modelLocation), context.getTransforms());
    }

    private static final class BarrelBakedModel
    implements IDynamicBakedModel {
        private final boolean ambientOcclusion;
        private final boolean gui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final BakedModel opened;
        private final BakedModel unopened;
        private final BakedModel vanilla;
        private final BakedModel old_opened;
        private final BakedModel old_unopened;
        private final ItemTransforms cameraTransforms;

        public BarrelBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, BakedModel opened, BakedModel unopened, BakedModel vanilla, BakedModel old_opened, BakedModel old_unopened, ItemTransforms cameraTransforms) {
            this.isSideLit = isSideLit;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
            this.opened = opened;
            this.unopened = unopened;
            this.vanilla = vanilla;
            this.old_opened = old_opened;
            this.old_unopened = old_unopened;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nonnull RenderType renderType) {
            BakedModel model = ConfigManager.isVanillaTextures() ? this.vanilla : (extraData.has(LootrBarrelBlock.OPENED) ? (extraData.get(LootrBarrelBlock.OPENED) == Boolean.TRUE ? (ConfigManager.isOldTextures() ? this.old_opened : this.opened) : (ConfigManager.isOldTextures() ? this.old_unopened : this.unopened)) : (ConfigManager.isOldTextures() ? this.old_unopened : this.unopened));
            return model.getQuads(state, side, rand, extraData, renderType);
        }

        public boolean m_7541_() {
            return this.ambientOcclusion;
        }

        public boolean m_7539_() {
            return this.gui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
            if (ConfigManager.isVanillaTextures()) {
                return this.vanilla.m_6160_();
            }
            if (data.get(LootrBarrelBlock.OPENED) == Boolean.TRUE) {
                return ConfigManager.isOldTextures() ? this.old_opened.m_6160_() : this.opened.m_6160_();
            }
            return ConfigManager.isOldTextures() ? this.old_unopened.m_6160_() : this.unopened.m_6160_();
        }

        public ItemTransforms m_7442_() {
            return this.cameraTransforms;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }
    }

    public static final class Loader
    implements IGeometryLoader<BarrelModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public BarrelModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            UnbakedModel unopened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"unopened"), BlockModel.class);
            UnbakedModel opened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"opened"), BlockModel.class);
            UnbakedModel vanilla = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"vanilla"), BlockModel.class);
            UnbakedModel old_unopened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"old_unopened"), BlockModel.class);
            UnbakedModel old_opened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"old_opened"), BlockModel.class);
            return new BarrelModel(opened, unopened, vanilla, old_unopened, old_opened);
        }
    }
}

