/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.content.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddSeveralItemsModifier
extends LootModifier {
    public static final Supplier<Codec<AddSeveralItemsModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddSeveralItemsModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.addedItem), (App)Codec.INT.optionalFieldOf("min", (Object)1).forGetter(m -> m.min), (App)Codec.INT.optionalFieldOf("max", (Object)1).forGetter(m -> m.max))).apply((Applicative)inst, AddSeveralItemsModifier::new)));
    private final Item addedItem;
    private final int min;
    private final int max;

    protected AddSeveralItemsModifier(LootItemCondition[] conditionsIn, Item addedItemIn, int min, int max) {
        super(conditionsIn);
        this.addedItem = addedItemIn;
        this.min = min;
        this.max = max;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack addedStack = new ItemStack((ItemLike)this.addedItem, Mth.m_216271_((RandomSource)context.m_230907_(), (int)this.min, (int)this.max));
        if (addedStack.m_41613_() < addedStack.m_41741_()) {
            generatedLoot.add((Object)addedStack);
        } else {
            ItemStack subStack;
            for (int i = addedStack.m_41613_(); i > 0; i -= subStack.m_41613_()) {
                subStack = addedStack.m_41777_();
                subStack.m_41764_(Math.min(addedStack.m_41741_(), i));
                generatedLoot.add((Object)subStack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

