/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.classloading;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import org.objectweb.asm.Type;

public class ModFileScanDataDeduplicator {
    private final Interner<Type> typeInterner = Interners.newStrongInterner();
    private final Function<Type, Type> internerFn = type -> type != null ? (Type)this.typeInterner.intern(type) : null;
    private static Field classClazzField;
    private static Field parentField;
    private static Field interfacesField;
    private static Field annotationClazzField;
    private static Field annotationTypeField;
    private static final boolean reflectionSuccessful;

    ModFileScanDataDeduplicator() {
    }

    private void runDeduplication() {
        ModList.get().forEachModFile(this::deduplicateFile);
    }

    private void deduplicateFile(IModFile file) {
        ModFileScanData data = file.getScanResult();
        if (data != null) {
            data.getClasses().forEach(this::deduplicateClass);
            data.getAnnotations().forEach(this::deduplicateAnnotation);
        }
    }

    private void deduplicateClass(ModFileScanData.ClassData data) {
        try {
            Type type = (Type)classClazzField.get(data);
            type = this.internerFn.apply(type);
            classClazzField.set(data, type);
            type = (Type)parentField.get(data);
            type = this.internerFn.apply(type);
            parentField.set(data, type);
            Set types = (Set)interfacesField.get(data);
            types = types.stream().map(this.internerFn).collect(Collectors.toSet());
            interfacesField.set(data, types);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void deduplicateAnnotation(ModFileScanData.AnnotationData data) {
        try {
            Type type = (Type)annotationClazzField.get(data);
            type = this.internerFn.apply(type);
            annotationClazzField.set(data, type);
            type = (Type)annotationTypeField.get(data);
            type = this.internerFn.apply(type);
            annotationTypeField.set(data, type);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static void deduplicate() {
        if (!reflectionSuccessful) {
            return;
        }
        new ModFileScanDataDeduplicator().runDeduplication();
    }

    static {
        boolean success = false;
        try {
            classClazzField = ModFileScanData.ClassData.class.getDeclaredField("clazz");
            classClazzField.setAccessible(true);
            parentField = ModFileScanData.ClassData.class.getDeclaredField("parent");
            parentField.setAccessible(true);
            interfacesField = ModFileScanData.ClassData.class.getDeclaredField("interfaces");
            interfacesField.setAccessible(true);
            annotationClazzField = ModFileScanData.AnnotationData.class.getDeclaredField("clazz");
            annotationClazzField.setAccessible(true);
            annotationTypeField = ModFileScanData.AnnotationData.class.getDeclaredField("annotationType");
            annotationTypeField.setAccessible(true);
            success = true;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        reflectionSuccessful = success;
    }
}

