/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.effect;

import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.config.Configuration;
import io.github.mortuusars.monobank.core.stealth.Stealth;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ThiefEffect
extends MobEffect {
    public static final int MAX_AREA_SIZE = 48;

    public ThiefEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public static MobEffectInstance createInstance(Duration duration, int amplifier) {
        return new MobEffectInstance((MobEffect)Registry.Effects.THIEF.get(), (int)(duration.getSeconds() * 20L), amplifier, false, false);
    }

    public static MobEffectInstance createInstance(Duration duration) {
        return ThiefEffect.createInstance(duration, 0);
    }

    public static int getBaseDurationSeconds() {
        return (Integer)Configuration.THIEF_EFFECT_BASE_DURATION.get();
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.EMPTY_LIST;
    }

    public void m_6742_(LivingEntity thiefEntity, int amplifier) {
        Level level = thiefEntity.f_19853_;
        if (level.f_46443_ || level.m_46467_() % 10L != 0L || level.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        int baseRadius = 16;
        int searchRadius = Math.min(48, baseRadius + baseRadius / 2 * amplifier);
        int aggroRadius = Math.max((int)((float)searchRadius * Stealth.getValueOf(thiefEntity)), 2);
        AABB maxArea = new AABB(thiefEntity.m_20183_()).m_82377_(48.0, 24.0, 48.0);
        List entities = level.m_45933_(null, maxArea);
        for (Entity entity : entities) {
            if (!entity.m_6095_().m_204039_(Registry.EntityTags.THIEF_ATTACKERS) || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (!(entity instanceof NeutralMob)) continue;
            NeutralMob neutralMob = (NeutralMob)entity;
            float distanceToThief = living.m_20270_((Entity)thiefEntity);
            if (neutralMob.m_6779_(thiefEntity) && distanceToThief <= (float)aggroRadius && living.m_142582_((Entity)thiefEntity)) {
                neutralMob.m_6710_(thiefEntity);
                continue;
            }
            if (neutralMob.m_5448_() != thiefEntity || neutralMob.m_6779_(thiefEntity) && (!(distanceToThief >= 26.0f) || neutralMob.m_21188_() == thiefEntity)) continue;
            neutralMob.m_21662_();
        }
    }
}

